/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.main.ResourceManager;
import com.hbm.render.RenderSparks;
import com.hbm.render.model.ModelBaleflare;
import com.hbm.render.model.ModelBuckshot;
import com.hbm.render.model.ModelBullet;
import com.hbm.render.model.ModelGrenade;
import com.hbm.render.model.ModelMIRV;
import com.hbm.render.model.ModelMiniNuke;
import com.hbm.render.model.ModelRocket;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderBulletMk2
extends Render<EntityBulletBase> {
    public static final IRenderFactory<EntityBulletBase> FACTORY = man -> new RenderBulletMk2(man);
    private ModelBullet bullet;
    private ModelBuckshot buckshot;
    private ModelRocket rocket;
    private ModelGrenade grenade;
    private ModelMiniNuke nuke;
    private ModelMIRV mirv;
    private ModelBaleflare bf;
    private ResourceLocation bullet_rl = new ResourceLocation("hbm:textures/models/bullet.png");
    private ResourceLocation emplacer = new ResourceLocation("hbm:textures/models/emplacer.png");
    private ResourceLocation tau = new ResourceLocation("hbm:textures/models/tau.png");
    private ResourceLocation buckshot_rl = new ResourceLocation("hbm:textures/entity/buckshot.png");
    private ResourceLocation rocket_rl = new ResourceLocation("hbm:textures/entity/ModelRocket.png");
    private ResourceLocation rocket_he = new ResourceLocation("hbm:textures/entity/ModelRocketHE.png");
    private ResourceLocation rocket_in = new ResourceLocation("hbm:textures/entity/ModelRocketIncendiary.png");
    private ResourceLocation rocket_sh = new ResourceLocation("hbm:textures/entity/ModelRocketShrapnel.png");
    private ResourceLocation rocket_emp = new ResourceLocation("hbm:textures/entity/ModelRocketEMP.png");
    private ResourceLocation rocket_gl = new ResourceLocation("hbm:textures/entity/ModelRocketGlare.png");
    private ResourceLocation rocket_sl = new ResourceLocation("hbm:textures/entity/ModelRocketSleek.png");
    private ResourceLocation rocket_nu = new ResourceLocation("hbm:textures/entity/ModelRocketNuclear.png");
    private ResourceLocation rocket_phos = new ResourceLocation("hbm:textures/entity/ModelRocketPhosphorus.png");
    private ResourceLocation rocket_can = new ResourceLocation("hbm:textures/entity/ModelRocketCanister.png");
    private ResourceLocation grenade_rl = new ResourceLocation("hbm:textures/entity/ModelGrenade.png");
    private ResourceLocation grenade_he = new ResourceLocation("hbm:textures/entity/ModelGrenadeHE.png");
    private ResourceLocation grenade_in = new ResourceLocation("hbm:textures/entity/ModelGrenadeIncendiary.png");
    private ResourceLocation grenade_to = new ResourceLocation("hbm:textures/entity/ModelGrenadeToxic.png");
    private ResourceLocation grenade_sl = new ResourceLocation("hbm:textures/entity/ModelGrenadeSleek.png");
    private ResourceLocation grenade_tr = new ResourceLocation("hbm:textures/entity/ModelGrenadeTraining.png");

    protected RenderBulletMk2(RenderManager renderManager) {
        super(renderManager);
        this.bullet = new ModelBullet();
        this.buckshot = new ModelBuckshot();
        this.rocket = new ModelRocket();
        this.grenade = new ModelGrenade();
        this.nuke = new ModelMiniNuke();
        this.mirv = new ModelMIRV();
        this.bf = new ModelBaleflare();
    }

    public void doRender(EntityBulletBase bullet, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        int style = (Integer)bullet.func_184212_Q().func_187225_a(EntityBulletBase.STYLE);
        int trail = (Integer)bullet.func_184212_Q().func_187225_a(EntityBulletBase.TRAIL);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if (style != 13) {
            GL11.glRotatef((float)(bullet.field_70126_B + (bullet.field_70177_z - bullet.field_70126_B) * partialTicks - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(bullet.field_70127_C + (bullet.field_70125_A - bullet.field_70127_C) * partialTicks + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)(new Random(bullet.func_145782_y()).nextInt(90) - 45), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        switch (style) {
            case -1: {
                break;
            }
            case 0: {
                this.renderBullet(trail);
                break;
            }
            case 3: {
                this.renderDart(trail, bullet.func_145782_y());
                break;
            }
            case 1: {
                this.renderFlechette();
                break;
            }
            case 4: {
                this.renderBullet(trail);
                break;
            }
            case 2: {
                this.renderBuckshot();
                break;
            }
            case 5: {
                this.renderRocket(trail);
                break;
            }
            case 9: {
                this.renderGrenade(trail);
                break;
            }
            case 7: {
                this.renderNuke(0);
                break;
            }
            case 8: {
                this.renderNuke(1);
                break;
            }
            case 10: {
                this.renderNuke(2);
                break;
            }
            case 11: {
                this.renderOrb(trail);
                break;
            }
            case 12: {
                this.renderMeteor(trail);
                break;
            }
            case 13: {
                this.renderTracer(new Vec3d(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y).func_72432_b(), bullet.func_174824_e(partialTicks), partialTicks);
                break;
            }
            case 14: {
                this.renderAPDS();
                break;
            }
            default: {
                this.renderBullet(trail);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderBullet(int type) {
        if (type == 2) {
            this.func_110776_a(this.emplacer);
        } else if (type == 1) {
            this.func_110776_a(this.tau);
        } else if (type == 0) {
            this.func_110776_a(this.bullet_rl);
        }
        this.bullet.renderAll(0.0625f);
    }

    private void renderBuckshot() {
        this.func_110776_a(this.buckshot_rl);
        this.buckshot.renderAll(0.0625f);
    }

    private void renderRocket(int type) {
        switch (type) {
            case 0: {
                this.func_110776_a(this.rocket_rl);
                break;
            }
            case 1: {
                this.func_110776_a(this.rocket_he);
                break;
            }
            case 2: {
                this.func_110776_a(this.rocket_in);
                break;
            }
            case 3: {
                this.func_110776_a(this.rocket_sh);
                break;
            }
            case 4: {
                this.func_110776_a(this.rocket_emp);
                break;
            }
            case 5: {
                this.func_110776_a(this.rocket_gl);
                break;
            }
            case 6: {
                this.func_110776_a(this.rocket_sl);
                break;
            }
            case 7: {
                this.func_110776_a(this.rocket_nu);
                break;
            }
            case 9: {
                this.func_110776_a(this.rocket_phos);
                break;
            }
            case 10: {
                this.func_110776_a(this.rocket_can);
            }
        }
        if (type == 8) {
            this.func_110776_a(ResourceManager.rpc_tex);
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ResourceManager.rpc.renderAll();
            return;
        }
        this.rocket.renderAll(0.0625f);
    }

    private void renderGrenade(int type) {
        GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
        switch (type) {
            case 0: {
                this.func_110776_a(this.grenade_rl);
                break;
            }
            case 1: {
                this.func_110776_a(this.grenade_he);
                break;
            }
            case 2: {
                this.func_110776_a(this.grenade_in);
                break;
            }
            case 3: {
                this.func_110776_a(this.grenade_to);
                break;
            }
            case 4: {
                this.func_110776_a(this.grenade_sl);
                break;
            }
            case 5: {
                this.func_110776_a(this.grenade_tr);
            }
        }
        this.grenade.renderAll(0.0625f);
    }

    private void renderNuke(int type) {
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        switch (type) {
            case 0: {
                this.func_110776_a(new ResourceLocation("hbm:textures/models/MiniNuke.png"));
                this.nuke.renderAll(0.0625f);
                break;
            }
            case 1: {
                this.func_110776_a(new ResourceLocation("hbm:textures/models/Mirv.png"));
                this.mirv.renderAll(0.0625f);
                break;
            }
            case 2: {
                this.func_110776_a(new ResourceLocation("hbm:textures/models/BaleFlare.png"));
                this.bf.renderAll(0.0625f);
            }
        }
    }

    private void renderFlechette() {
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(0.0, -1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, -1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 1.0, 1.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        tess.func_78381_a();
        buf.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(1.0, 0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, -0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, 0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(1.0, 0.5, -0.5).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(0.15f, 0.15f, 0.15f, 1.0f).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GL11.glPopMatrix();
    }

    private void renderDart(int style, int eID) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        switch (style) {
            case 2: {
                red = 1.0f;
                green = 0.0f;
                blue = 0.0f;
                break;
            }
            case 1: {
                red = 1.0f;
                green = 1.0f;
                blue = 0.0f;
                break;
            }
            case 0: {
                red = 0.25f;
                green = 0.0f;
                blue = 0.75f;
                break;
            }
            case 4: {
                red = 0.0f;
                green = 1.0f;
                blue = 0.0f;
                break;
            }
            case 3: {
                Random rand = new Random(eID * eID);
                red = (float)rand.nextInt(2) * 0.8f;
                green = (float)rand.nextInt(2) * 0.8f;
                blue = (float)rand.nextInt(2) * 0.8f;
            }
        }
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glScalef((float)0.25f, (float)0.125f, (float)0.125f);
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(3.0, -1.0, -1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(3.0, 1.0, -1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(3.0, -1.0, 1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(3.0, 1.0, 1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(3.0, -1.0, -1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(3.0, -1.0, 1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(3.0, 1.0, -1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(3.0, 1.0, 1.0).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(6.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tess.func_78381_a();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(4.0, 0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 0.5, 0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(0.0, 0.5, -0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, -0.5, 0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(0.0, -0.5, -0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, 0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 0.5, 0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(0.0, -0.5, 0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(4.0, -0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(4.0, 0.5, -0.5).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buf.func_181662_b(0.0, 0.5, -0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buf.func_181662_b(0.0, -0.5, -0.5).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopMatrix();
    }

    private void renderOrb(int type) {
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179132_a((boolean)false);
        switch (type) {
            case 0: {
                this.func_110776_a(ResourceManager.tom_flame_tex);
                ResourceManager.sphere_uv_anim.renderAll();
                GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
                ResourceManager.sphere_uv_anim.renderAll();
                GL11.glScalef((float)3.3333333f, (float)3.3333333f, (float)3.3333333f);
                for (int i = 0; i < 5; ++i) {
                    RenderSparks.renderSpark((int)(System.currentTimeMillis() / 100L + (long)(100 * i)), 0.0, 0.0, 0.0, 0.5f, 2, 2, 0x8080FF, 0xFFFFFF);
                }
                break;
            }
            case 1: {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)0.5f, (float)0.0f, (float)0.0f, (float)0.5f);
                ResourceManager.sphere_uv.renderAll();
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                ResourceManager.sphere_uv.renderAll();
                GL11.glScalef((float)1.3333334f, (float)1.3333334f, (float)1.3333334f);
                GlStateManager.func_179098_w();
                for (int i = 0; i < 3; ++i) {
                    RenderSparks.renderSpark((int)(System.currentTimeMillis() / 100L + (long)(100 * i)), 0.0, 0.0, 0.0, 1.0f, 2, 3, 0xFF0000, 0xFF8080);
                }
                break;
            }
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void renderMeteor(int type) {
        GlStateManager.func_179089_o();
        GlStateManager.func_179140_f();
        switch (type) {
            case 0: {
                this.func_110776_a(new ResourceLocation("hbm:textures/blocks/block_meteor_molten.png"));
                break;
            }
            case 1: {
                this.func_110776_a(new ResourceLocation("textures/blocks/obsidian.png"));
            }
        }
        ResourceManager.meteor.renderAll();
        GlStateManager.func_179145_e();
    }

    private void renderTracer(Vec3d bulletDirection, Vec3d bulletPos, float partialTicks) {
        Entity rv = Minecraft.func_71410_x().func_175606_aa();
        double eyeX = rv.field_70169_q + (rv.field_70165_t - rv.field_70169_q) * (double)partialTicks;
        double eyeY = rv.field_70167_r + (rv.field_70163_u - rv.field_70167_r) * (double)partialTicks;
        double eyeZ = rv.field_70166_s + (rv.field_70161_v - rv.field_70166_s) * (double)partialTicks;
        Vec3d eyePos = new Vec3d(eyeX, eyeY, eyeZ).func_178787_e(ActiveRenderInfo.getCameraPosition());
        Vec3d tan = eyePos.func_178788_d(bulletPos).func_72431_c(bulletDirection).func_72432_b().func_186678_a(0.05);
        bulletDirection = bulletDirection.func_186678_a(10.0);
        this.func_110776_a(ResourceManager.fresnel_ms);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(tan.field_72450_a, tan.field_72448_b, tan.field_72449_c).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(tan.field_72450_a + bulletDirection.field_72450_a, tan.field_72448_b + bulletDirection.field_72448_b, tan.field_72449_c + bulletDirection.field_72449_c).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(-tan.field_72450_a + bulletDirection.field_72450_a, -tan.field_72448_b + bulletDirection.field_72448_b, -tan.field_72449_c + bulletDirection.field_72449_c).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(-tan.field_72450_a, -tan.field_72448_b, -tan.field_72449_c).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(tan.field_72450_a, tan.field_72448_b, tan.field_72449_c).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(tan.field_72450_a + bulletDirection.field_72450_a, tan.field_72448_b + bulletDirection.field_72448_b, tan.field_72449_c + bulletDirection.field_72449_c).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(-tan.field_72450_a + bulletDirection.field_72450_a, -tan.field_72448_b + bulletDirection.field_72448_b, -tan.field_72449_c + bulletDirection.field_72449_c).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(-tan.field_72450_a, -tan.field_72448_b, -tan.field_72449_c).func_187315_a(0.0, 1.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    private void renderAPDS() {
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.func_179103_j((int)7425);
        this.func_110776_a(ResourceManager.flechette_tex);
        ResourceManager.projectiles.renderPart("Flechette");
        GlStateManager.func_179103_j((int)7424);
    }

    protected ResourceLocation getEntityTexture(EntityBulletBase entity) {
        return this.bullet_rl;
    }
}

