/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity;

import com.hbm.entity.particle.EntityModFX;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MultiCloudRenderer
extends Render<EntityModFX> {
    private TextureAtlasSprite tex;
    private Item[] textureItems;
    private int meta;

    public MultiCloudRenderer(Item[] items, RenderManager renderManager) {
        super(renderManager);
        this.textureItems = items;
        this.meta = 0;
    }

    public MultiCloudRenderer(Item[] items, int m, RenderManager renderManager) {
        super(renderManager);
        this.textureItems = items;
        this.meta = m;
    }

    public void doRender(EntityModFX fx, double x, double y, double z, float entityYaw, float partialTicks) {
        this.func_180548_c(fx);
        if (this.tex != null) {
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.func_179091_B();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glScalef((float)7.5f, (float)7.5f, (float)7.5f);
            Random randy = new Random(fx.hashCode());
            Random rand = new Random(100L);
            for (int i = 0; i < 5; ++i) {
                float d = (float)randy.nextInt(10) * 0.05f;
                GlStateManager.func_179124_c((float)(1.0f - d), (float)(1.0f - d), (float)(1.0f - d));
                double dX = (rand.nextGaussian() - 1.0) * 0.15;
                double dY = (rand.nextGaussian() - 1.0) * 0.15;
                double dZ = (rand.nextGaussian() - 1.0) * 0.15;
                double size = rand.nextDouble() * 0.5 + 0.25;
                GL11.glTranslatef((float)((float)dX), (float)((float)dY), (float)((float)dZ));
                GL11.glScaled((double)size, (double)size, (double)size);
                GL11.glPushMatrix();
                Tessellator tessellator = Tessellator.func_178181_a();
                this.func_77026_a(tessellator, this.tex);
                GL11.glPopMatrix();
                GL11.glScaled((double)(1.0 / size), (double)(1.0 / size), (double)(1.0 / size));
                GL11.glTranslatef((float)((float)(-dX)), (float)((float)(-dY)), (float)((float)(-dZ)));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation getEntityTexture(EntityModFX fx) {
        Item item = this.textureItems[0];
        if (fx.particleAge <= fx.maxAge && fx.particleAge >= fx.maxAge / 8 * 7) {
            item = this.textureItems[7];
        }
        if (fx.particleAge < fx.maxAge / 8 * 7 && fx.particleAge >= fx.maxAge / 8 * 6) {
            item = this.textureItems[6];
        }
        if (fx.particleAge < fx.maxAge / 8 * 6 && fx.particleAge >= fx.maxAge / 8 * 5) {
            item = this.textureItems[5];
        }
        if (fx.particleAge < fx.maxAge / 8 * 5 && fx.particleAge >= fx.maxAge / 8 * 4) {
            item = this.textureItems[4];
        }
        if (fx.particleAge < fx.maxAge / 8 * 4 && fx.particleAge >= fx.maxAge / 8 * 3) {
            item = this.textureItems[3];
        }
        if (fx.particleAge < fx.maxAge / 8 * 3 && fx.particleAge >= fx.maxAge / 8 * 2) {
            item = this.textureItems[2];
        }
        if (fx.particleAge < fx.maxAge / 8 * 2 && fx.particleAge >= fx.maxAge / 8 * 1) {
            item = this.textureItems[1];
        }
        if (fx.particleAge < fx.maxAge / 8 && fx.particleAge >= 0) {
            item = this.textureItems[0];
        }
        this.tex = Minecraft.func_71410_x().func_175599_af().func_184393_a(new ItemStack(item, 1, this.meta), null, null).func_177554_e();
        return TextureMap.field_110575_b;
    }

    private void func_77026_a(Tessellator tes, TextureAtlasSprite tas) {
        BufferBuilder buf = tes.func_178180_c();
        float f = tas.func_94209_e();
        float f1 = tas.func_94212_f();
        float f2 = tas.func_94206_g();
        float f3 = tas.func_94210_h();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)(0.0f - f5), (double)(0.0f - f6), 0.0).func_187315_a((double)f, (double)f3).func_181675_d();
        buf.func_181662_b((double)(f4 - f5), (double)(0.0f - f6), 0.0).func_187315_a((double)f1, (double)f3).func_181675_d();
        buf.func_181662_b((double)(f4 - f5), (double)(f4 - f6), 0.0).func_187315_a((double)f1, (double)f2).func_181675_d();
        buf.func_181662_b((double)(0.0f - f5), (double)(f4 - f6), 0.0).func_187315_a((double)f, (double)f2).func_181675_d();
        tes.func_78381_a();
    }
}

