/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle_instanced;

import com.hbm.main.ModEventHandlerClient;
import com.hbm.particle_instanced.ParticleInstanced;
import java.nio.ByteBuffer;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ParticleContrailInstanced
extends ParticleInstanced {
    private int age = 0;
    private int maxAge;
    private float scale;
    private float[] vals = new float[24];
    private boolean doFlames = false;
    private static float flameRed;
    private static float flameGreen;
    private static float flameBlue;
    private static float lowRed;
    private static float lowGreen;
    private static float lowBlue;

    public ParticleContrailInstanced(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_187119_C = ModEventHandlerClient.contrail;
        this.maxAge = 400 + this.field_187136_p.nextInt(50);
        this.field_70551_j = 0.0f;
        this.field_70553_i = 0.0f;
        this.field_70552_h = 0.0f;
        this.scale = 1.0f;
        this.initVals();
    }

    public ParticleContrailInstanced(World worldIn, double posXIn, double posYIn, double posZIn, float red, float green, float blue, float scale) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_187119_C = ModEventHandlerClient.contrail;
        this.maxAge = 600 + this.field_187136_p.nextInt(50);
        lowRed = red;
        lowGreen = green;
        lowBlue = blue;
        this.scale = scale;
        this.initVals();
    }

    public ParticleContrailInstanced(World worldIn, double posXIn, double posYIn, double posZIn, float flameRed, float flameGreen, float flameBlue, float red, float green, float blue, float scale) {
        this(worldIn, posXIn, posYIn, posZIn, red, green, blue, scale);
        ParticleContrailInstanced.flameRed = flameRed;
        ParticleContrailInstanced.flameGreen = flameGreen;
        ParticleContrailInstanced.flameBlue = flameBlue;
        this.doFlames = true;
    }

    public void initVals() {
        Random urandom = new Random(((Object)((Object)this)).hashCode());
        for (int i = 0; i < 6; ++i) {
            this.vals[i * 4] = (float)(urandom.nextGaussian() * 0.5);
            this.vals[i * 4 + 1] = (float)(urandom.nextGaussian() * 0.5);
            this.vals[i * 4 + 2] = (float)(urandom.nextGaussian() * 0.5);
        }
    }

    public void setMotion(double x, double y, double z) {
        this.field_187129_i = x;
        this.field_187130_j = y;
        this.field_187131_k = z;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_82339_as = 1.0f - (float)Math.pow((float)this.age / (float)this.maxAge, 2.0);
        ++this.age;
        if (this.age == this.maxAge) {
            this.func_187112_i();
        }
        this.field_187129_i *= 0.91;
        this.field_187130_j *= 0.91;
        this.field_187131_k *= 0.91;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    private byte getColor(int index) {
        float pColor = 0.0f;
        if (index == 0) {
            pColor = this.doFlames ? lowRed + (flameRed - lowRed) * this.field_82339_as * 0.1f : lowRed;
            this.field_70552_h = pColor;
        } else if (index == 1) {
            pColor = this.doFlames ? lowGreen + (flameGreen - lowGreen) * this.field_82339_as * 0.1f : lowGreen;
            this.field_70553_i = pColor;
        } else if (index == 2) {
            pColor = this.doFlames ? lowBlue + (flameBlue - lowBlue) * this.field_82339_as * 0.1f : lowBlue;
            this.field_70551_j = pColor;
        }
        return (byte)(MathHelper.func_76131_a((float)pColor, (float)0.0f, (float)1.0f) * 255.0f);
    }

    @Override
    public void addDataToBuffer(ByteBuffer buf, float partialTicks) {
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        this.field_70544_f = (1.0f - this.field_82339_as) * 3.0f + 0.5f * this.scale;
        for (int ii = 0; ii < 6; ++ii) {
            buf.putFloat(x + this.vals[ii * 4]);
            buf.putFloat(y + this.vals[ii * 4 + 1]);
            buf.putFloat(z + this.vals[ii * 4 + 2]);
            buf.putFloat(this.field_70544_f);
            buf.putFloat(this.field_187119_C.func_94209_e());
            buf.putFloat(this.field_187119_C.func_94206_g());
            buf.putFloat(this.field_187119_C.func_94212_f() - this.field_187119_C.func_94209_e());
            buf.putFloat(this.field_187119_C.func_94210_h() - this.field_187119_C.func_94206_g());
            byte r = this.getColor(0);
            byte g = this.getColor(1);
            byte b = this.getColor(2);
            byte a = (byte)(this.field_82339_as * 255.0f);
            buf.put(r);
            buf.put(g);
            buf.put(b);
            buf.put(a);
            buf.put((byte)-16);
            buf.put((byte)-16);
        }
    }

    @Override
    public int getFaceCount() {
        return 6;
    }

    public int func_189214_a(float p_189214_1_) {
        return 240;
    }

    public int func_70537_b() {
        return 1;
    }
}

