/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.handler.JetpackHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JetpackSyncPacket
implements IMessage {
    int playerId;
    JetpackHandler.JetpackInfo info;

    public JetpackSyncPacket() {
    }

    public JetpackSyncPacket(EntityPlayer player) {
        this.playerId = player.func_145782_y();
        this.info = JetpackHandler.get(player);
    }

    public void fromBytes(ByteBuf buf) {
        this.playerId = buf.readInt();
        this.info = new JetpackHandler.JetpackInfo(false);
        this.info.read(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerId);
        this.info.write(buf);
    }

    public static class Handler
    implements IMessageHandler<JetpackSyncPacket, IMessage> {
        public IMessage onMessage(JetpackSyncPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                ctx.getServerHandler().field_147369_b.field_71133_b.func_152344_a(() -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    JetpackHandler.JetpackInfo info = JetpackHandler.get((EntityPlayer)player);
                    if (info == null) {
                        info = new JetpackHandler.JetpackInfo(false);
                        JetpackHandler.put((EntityPlayer)player, info);
                    }
                    JetpackHandler.put((EntityPlayer)player, message.info);
                });
            } else {
                this.handleMessageClient(message, ctx);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handleMessageClient(JetpackSyncPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Entity ent = world.func_73045_a(m.playerId);
                if (ent instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)ent;
                    JetpackHandler.JetpackInfo info = JetpackHandler.get(player);
                    if (info == null) {
                        info = new JetpackHandler.JetpackInfo(true);
                        JetpackHandler.put(player, info);
                    }
                    info.setFromServer(m.info);
                }
            });
        }
    }
}

