/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AssemblerRecipeSyncPacket
implements IMessage {
    public List<AssemblerRecipe> recipes;
    public HashSet<RecipesCommon.ComparableStack> hidden;

    public AssemblerRecipeSyncPacket() {
    }

    public AssemblerRecipeSyncPacket(List<RecipesCommon.ComparableStack> recipes, HashSet<RecipesCommon.ComparableStack> hidden) {
        this.recipes = new ArrayList<AssemblerRecipe>(recipes.size());
        for (int i = 0; i < recipes.size(); ++i) {
            RecipesCommon.ComparableStack c = recipes.get(i);
            if (AssemblerRecipes.recipes.get(c) == null) continue;
            this.recipes.add(new AssemblerRecipe(AssemblerRecipes.recipes.get(c), c, AssemblerRecipes.time.get(c)));
        }
        this.hidden = hidden;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.recipes = new ArrayList<AssemblerRecipe>(size);
        for (int i = 0; i < size; ++i) {
            RecipesCommon.ComparableStack output;
            int count;
            int inputSize = buf.readByte();
            RecipesCommon.AStack[] inputs = new RecipesCommon.AStack[inputSize];
            for (int j = 0; j < inputSize; ++j) {
                byte type = buf.readByte();
                if (type == 0) {
                    count = buf.readInt();
                    int id = buf.readInt();
                    int meta = buf.readInt();
                    ItemStack stack = new ItemStack(Item.func_150899_d((int)id), count, meta);
                    try {
                        stack.func_77982_d(CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    inputs[j] = new RecipesCommon.NbtComparableStack(stack);
                    continue;
                }
                if (type == 1) {
                    count = buf.readInt();
                    int len = buf.readInt();
                    byte[] bytes = new byte[len];
                    buf.readBytes(bytes);
                    String name = new String(bytes, Charset.forName("ascii"));
                    inputs[j] = new RecipesCommon.OreDictStack(name, count);
                    continue;
                }
                if (type != 2) continue;
                count = buf.readInt();
                int id = buf.readInt();
                int meta = buf.readInt();
                ItemStack stack = new ItemStack(Item.func_150899_d((int)id), count, meta);
                inputs[j] = new RecipesCommon.ComparableStack(stack);
            }
            int id = buf.readInt();
            int meta = buf.readInt();
            count = buf.readInt();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)id), count, meta);
            byte type = buf.readByte();
            if (type == 1) {
                try {
                    stack.func_77982_d(CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                output = new RecipesCommon.NbtComparableStack(stack);
            } else {
                output = new RecipesCommon.ComparableStack(stack);
            }
            int time = buf.readInt();
            this.recipes.add(new AssemblerRecipe(inputs, output, time));
        }
        int hiddenSize = buf.readInt();
        this.hidden = new HashSet(hiddenSize);
        for (int i = 0; i < hiddenSize; ++i) {
            RecipesCommon.ComparableStack hideStack;
            int id = buf.readInt();
            int meta = buf.readInt();
            int count = buf.readInt();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)id), count, meta);
            byte type = buf.readByte();
            if (type == 1) {
                try {
                    stack.func_77982_d(CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                hideStack = new RecipesCommon.NbtComparableStack(stack);
            } else {
                hideStack = new RecipesCommon.ComparableStack(stack);
            }
            this.hidden.add(hideStack);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipes.size());
        for (int i = 0; i < this.recipes.size(); ++i) {
            AssemblerRecipe recipe = this.recipes.get(i);
            RecipesCommon.AStack[] inputs = recipe.in;
            RecipesCommon.ComparableStack output = recipe.out;
            buf.writeByte(inputs.length);
            for (int j = 0; j < inputs.length; ++j) {
                RecipesCommon.AStack stack = inputs[j];
                if (stack instanceof RecipesCommon.NbtComparableStack) {
                    RecipesCommon.NbtComparableStack nStack = (RecipesCommon.NbtComparableStack)stack;
                    buf.writeByte(0);
                    buf.writeInt(nStack.count());
                    buf.writeInt(Item.func_150891_b((Item)nStack.item));
                    buf.writeInt(nStack.meta);
                    try {
                        CompressedStreamTools.func_74800_a((NBTTagCompound)nStack.getStack().func_77978_p(), (DataOutput)new ByteBufOutputStream(buf));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (stack instanceof RecipesCommon.OreDictStack) {
                    RecipesCommon.OreDictStack oStack = (RecipesCommon.OreDictStack)stack;
                    buf.writeByte(1);
                    buf.writeInt(oStack.count());
                    byte[] bytes = oStack.name.getBytes(Charset.forName("ascii"));
                    buf.writeInt(bytes.length);
                    buf.writeBytes(bytes);
                    continue;
                }
                if (!(stack instanceof RecipesCommon.ComparableStack)) continue;
                RecipesCommon.ComparableStack cStack = (RecipesCommon.ComparableStack)stack;
                buf.writeByte(2);
                buf.writeInt(cStack.count());
                buf.writeInt(Item.func_150891_b((Item)cStack.item));
                buf.writeInt(cStack.meta);
            }
            buf.writeInt(Item.func_150891_b((Item)output.item));
            buf.writeInt(output.meta);
            buf.writeInt(output.count());
            if (output instanceof RecipesCommon.NbtComparableStack) {
                buf.writeByte(1);
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)output.getStack().func_77978_p(), (DataOutput)new ByteBufOutputStream(buf));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                buf.writeByte(0);
            }
            buf.writeInt(this.recipes.get((int)i).time);
        }
        buf.writeInt(this.hidden.size());
        for (RecipesCommon.ComparableStack stack : this.hidden) {
            buf.writeInt(Item.func_150891_b((Item)stack.item));
            buf.writeInt(stack.meta);
            buf.writeInt(stack.count());
            if (stack instanceof RecipesCommon.NbtComparableStack) {
                buf.writeByte(1);
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)stack.getStack().func_77978_p(), (DataOutput)new ByteBufOutputStream(buf));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            buf.writeByte(0);
        }
    }

    private static class AssemblerRecipe {
        RecipesCommon.AStack[] in;
        RecipesCommon.ComparableStack out;
        int time;

        public AssemblerRecipe(RecipesCommon.AStack[] in, RecipesCommon.ComparableStack out, int time) {
            this.in = in;
            this.out = out;
            this.time = time;
        }
    }

    public static class Handler
    implements IMessageHandler<AssemblerRecipeSyncPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(AssemblerRecipeSyncPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                AssemblerRecipes.backupRecipes = AssemblerRecipes.recipes;
                AssemblerRecipes.backupTime = AssemblerRecipes.time;
                AssemblerRecipes.backupRecipeList = AssemblerRecipes.recipeList;
                AssemblerRecipes.backupHidden = AssemblerRecipes.hidden;
                AssemblerRecipes.recipes = new HashMap(m.recipes.size());
                AssemblerRecipes.time = new HashMap(m.recipes.size());
                AssemblerRecipes.recipeList = new ArrayList<RecipesCommon.ComparableStack>(m.recipes.size());
                AssemblerRecipes.hidden = m.hidden;
                for (AssemblerRecipe r : m.recipes) {
                    AssemblerRecipes.recipes.put(r.out, r.in);
                    AssemblerRecipes.time.put(r.out, r.time);
                    AssemblerRecipes.recipeList.add(r.out);
                }
            });
            return null;
        }
    }
}

