/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.items.ModItems;
import com.hbm.items.special.ItemLootCrate;
import com.hbm.main.MainRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMissile
extends Item {
    public PartType type;
    public PartSize top;
    public PartSize bottom;
    public Rarity rarity;
    public float health;
    private String title;
    private String author;
    private String witty;
    public static HashMap<Integer, ItemMissile> parts = new HashMap();
    public Object[] attributes;

    public ItemMissile(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.missileTab);
        ModItems.ALL_ITEMS.add(this);
    }

    public ItemMissile makeChip(float inaccuracy) {
        this.type = PartType.CHIP;
        this.top = PartSize.ANY;
        this.bottom = PartSize.ANY;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeWarhead(WarheadType type, float punch, float weight, PartSize size) {
        this.type = PartType.WARHEAD;
        this.top = PartSize.NONE;
        this.bottom = size;
        this.attributes = new Object[]{type, Float.valueOf(punch), Float.valueOf(weight)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeFuselage(FuelType type, float fuel, PartSize top, PartSize bottom) {
        this.type = PartType.FUSELAGE;
        this.top = top;
        this.bottom = bottom;
        this.attributes = new Object[]{type, Float.valueOf(fuel)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeStability(float inaccuracy, PartSize size) {
        this.type = PartType.FINS;
        this.top = size;
        this.bottom = size;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeThruster(FuelType type, float consumption, float lift, PartSize size) {
        this.type = PartType.THRUSTER;
        this.top = size;
        this.bottom = PartSize.NONE;
        this.attributes = new Object[]{type, Float.valueOf(consumption), Float.valueOf(lift)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.title != null) {
            list.add(TextFormatting.DARK_PURPLE + "\"" + this.title + "\"");
        }
        try {
            switch (this.type) {
                case CHIP: {
                    list.add(TextFormatting.BOLD + "Inaccuracy: " + TextFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case WARHEAD: {
                    list.add(TextFormatting.BOLD + "Size: " + TextFormatting.GRAY + this.getSize(this.bottom));
                    list.add(TextFormatting.BOLD + "Type: " + TextFormatting.GRAY + this.getWarhead((WarheadType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + "Strength: " + TextFormatting.RED + (Float)this.attributes[1]);
                    list.add(TextFormatting.BOLD + "Weight: " + TextFormatting.GRAY + (Float)this.attributes[2] + "t");
                    break;
                }
                case FUSELAGE: {
                    list.add(TextFormatting.BOLD + "Top size: " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + "Bottom size: " + TextFormatting.GRAY + this.getSize(this.bottom));
                    list.add(TextFormatting.BOLD + "Fuel type: " + TextFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + "Fuel amount: " + TextFormatting.GRAY + (Float)this.attributes[1] + "l");
                    break;
                }
                case FINS: {
                    list.add(TextFormatting.BOLD + "Size: " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + "Inaccuracy: " + TextFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case THRUSTER: {
                    list.add(TextFormatting.BOLD + "Size: " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + "Fuel type: " + TextFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + "Fuel consumption: " + TextFormatting.GRAY + (Float)this.attributes[1] + "l/tick");
                    list.add(TextFormatting.BOLD + "Max. payload: " + TextFormatting.GRAY + (Float)this.attributes[2] + "t");
                }
            }
        }
        catch (Exception ex) {
            list.add("### I AM ERROR ###");
        }
        if (this.type != PartType.CHIP) {
            list.add(TextFormatting.BOLD + "Health: " + TextFormatting.GREEN + this.health + "HP");
        }
        if (this.rarity != null) {
            list.add(TextFormatting.BOLD + "Rarity: " + TextFormatting.GRAY + this.rarity.name);
        }
        if (this.author != null) {
            list.add(TextFormatting.WHITE + "   by " + this.author);
        }
        if (this.witty != null) {
            list.add(TextFormatting.GOLD + "   " + TextFormatting.ITALIC + "\"" + this.witty + "\"");
        }
    }

    public String getSize(PartSize size) {
        switch (size) {
            case ANY: {
                return "Any";
            }
            case SIZE_10: {
                return "\u00a7e1.0m";
            }
            case SIZE_15: {
                return "\u00a761.5m";
            }
            case SIZE_20: {
                return "\u00a7c2.0m";
            }
        }
        return "None";
    }

    public String getWarhead(WarheadType type) {
        switch (type) {
            case HE: {
                return TextFormatting.YELLOW + "HE";
            }
            case INC: {
                return TextFormatting.GOLD + "Incendiary";
            }
            case CLUSTER: {
                return TextFormatting.GRAY + "Cluster";
            }
            case BUSTER: {
                return TextFormatting.WHITE + "Bunker Buster";
            }
            case NUCLEAR: {
                return TextFormatting.DARK_GREEN + "Nuclear";
            }
            case TX: {
                return TextFormatting.DARK_PURPLE + "Thermonuclear (TX)";
            }
            case N2: {
                return TextFormatting.RED + "N\u00b2";
            }
            case BALEFIRE: {
                return TextFormatting.GREEN + "BF";
            }
            case SCHRAB: {
                return TextFormatting.AQUA + "Schrabidium";
            }
            case TAINT: {
                return TextFormatting.DARK_PURPLE + "Taint";
            }
            case CLOUD: {
                return TextFormatting.LIGHT_PURPLE + "Cloud";
            }
            case VOLCANO: {
                return TextFormatting.DARK_RED + "Volcano";
            }
            case MIRV: {
                return TextFormatting.DARK_PURPLE + "MIRV";
            }
        }
        return TextFormatting.BOLD + "N/A";
    }

    public String getFuel(FuelType type) {
        switch (type) {
            case KEROSENE: {
                return TextFormatting.LIGHT_PURPLE + "Kerosene / Peroxide";
            }
            case SOLID: {
                return TextFormatting.GOLD + "Solid Fuel";
            }
            case HYDROGEN: {
                return TextFormatting.DARK_AQUA + "Hydrogen / Oxygen";
            }
            case XENON: {
                return TextFormatting.DARK_PURPLE + "Xenon Gas";
            }
            case BALEFIRE: {
                return TextFormatting.GREEN + "BF Rocket Fuel / Peroxide";
            }
        }
        return TextFormatting.BOLD + "N/A";
    }

    public ItemMissile copy(String s) {
        ItemMissile part = new ItemMissile(s);
        part.type = this.type;
        part.top = this.top;
        part.bottom = this.bottom;
        part.health = this.health;
        part.attributes = this.attributes;
        part.health = this.health;
        return part;
    }

    public ItemMissile setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ItemMissile setTitle(String title) {
        this.title = title;
        return this;
    }

    public ItemMissile setWittyText(String witty) {
        this.witty = witty;
        return this;
    }

    public ItemMissile setHealth(float health) {
        this.health = health;
        return this;
    }

    public ItemMissile setRarity(Rarity rarity) {
        this.rarity = rarity;
        if (this.type == PartType.FUSELAGE) {
            if (this.top == PartSize.SIZE_10) {
                ItemLootCrate.list10.add(this);
            }
            if (this.top == PartSize.SIZE_15) {
                ItemLootCrate.list15.add(this);
            }
        } else {
            ItemLootCrate.listMisc.add(this);
        }
        return this;
    }

    public static enum Rarity {
        COMMON(TextFormatting.GRAY + "Common"),
        UNCOMMON(TextFormatting.YELLOW + "Uncommon"),
        RARE(TextFormatting.GREEN + "Rare"),
        EPIC(TextFormatting.AQUA + "Epic"),
        LEGENDARY(TextFormatting.LIGHT_PURPLE + "Legendary"),
        SEWS_CLOTHES_AND_SUCKS_HORSE_COCK(TextFormatting.DARK_AQUA + "Strange");

        String name;

        private Rarity(String name) {
            this.name = name;
        }
    }

    public static enum FuelType {
        KEROSENE,
        SOLID,
        HYDROGEN,
        XENON,
        BALEFIRE;

    }

    public static enum WarheadType {
        HE,
        INC,
        BUSTER,
        CLUSTER,
        NUCLEAR,
        TX,
        N2,
        BALEFIRE,
        SCHRAB,
        TAINT,
        CLOUD,
        VOLCANO,
        MIRV;

    }

    public static enum PartSize {
        ANY,
        NONE,
        SIZE_10,
        SIZE_15,
        SIZE_20;

    }

    public static enum PartType {
        CHIP,
        WARHEAD,
        FUSELAGE,
        FINS,
        THRUSTER;

    }
}

