/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.GunConfiguration;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.main.ResourceManager;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PacketSpecialDeath;
import com.hbm.particle.gluon.ParticleGluonBurnTrail;
import com.hbm.particle.gluon.ParticleGluonFlare;
import com.hbm.particle.gluon.ParticleGluonMuzzleSmoke;
import com.hbm.particle.tau.ParticleTauParticle;
import com.hbm.render.RenderHelper;
import com.hbm.render.item.weapon.ItemRenderGunEgon;
import com.hbm.sound.GunEgonSoundHandler;
import com.hbm.util.BobMathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemGunEgon
extends ItemGunBase {
    public float charge = 0.25f;
    public static float chargeScaling = 1.011619f;
    public static int activeTicks = 0;
    public static Map<EntityPlayer, ParticleGluonBurnTrail> activeTrailParticles = new HashMap<EntityPlayer, ParticleGluonBurnTrail>();
    public static Map<EntityPlayer, GunEgonSoundHandler> soundsByPlayer = new HashMap<EntityPlayer, GunEgonSoundHandler>();

    public ItemGunEgon(GunConfiguration config, String s) {
        super(config, s);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer player, int slot, EnumHand hand) {
        super.updateClient(stack, world, player, slot, hand);
        if (hand == EnumHand.OFF_HAND) {
            return;
        }
        if (player == Minecraft.func_71410_x().field_71439_g) {
            if (m1 && Library.countInventoryItem(player.field_71071_by, ItemGunEgon.getBeltType(player, stack, true)) >= 2) {
                int i;
                activeTicks = Math.min(activeTicks + 1, 5);
                float[] angles = ItemGunEgon.getBeamDirectionOffset(player.field_70170_p.func_72820_D() + 1L);
                Vec3d look = Library.changeByAngle(player.func_70676_i(1.0f), angles[0], angles[1]);
                RayTraceResult r = Library.rayTraceIncludeEntitiesCustomDirection(player, look, 50.0, 1.0f);
                if (r != null && r.field_72307_f != null && r.field_72313_a != RayTraceResult.Type.MISS && r.field_178784_b != null) {
                    Vec3i norm = r.field_178784_b.func_176730_m();
                    Vec3d pos = r.field_72307_f.func_72441_c((double)((float)norm.func_177958_n() * 0.1f), (double)((float)norm.func_177956_o() * 0.1f), (double)((float)norm.func_177952_p() * 0.1f));
                    ParticleGluonFlare flare = new ParticleGluonFlare(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flare);
                } else {
                    Vec3d pos = player.func_174824_e(1.0f).func_178787_e(look.func_186678_a(50.0));
                    ParticleGluonFlare flare = new ParticleGluonFlare(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)flare);
                }
                Random rand = world.field_73012_v;
                float partialTicks = MainRegistry.proxy.partialTicks();
                float[] offset = ItemRenderGunEgon.getOffset((float)player.field_70170_p.func_72820_D() + partialTicks);
                float fovDiff = (ModEventHandlerClient.currentFOV - 70.0f) * 2.0E-4f;
                Vec3d start = new Vec3d(-0.18 + (double)(offset[0] * 0.075f) - (double)fovDiff, -0.2 + (double)(offset[1] * 0.1f), 0.5 - (double)(fovDiff * 30.0f));
                start = start.func_178789_a((float)Math.toRadians(-(player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks)));
                start = start.func_178785_b((float)Math.toRadians(-(player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks)));
                start = start.func_178787_e(player.func_174824_e(partialTicks));
                for (i = 0; i < 2; ++i) {
                    Vec3d randPos = new Vec3d((double)rand.nextFloat() - 0.5, (double)rand.nextFloat() - 0.5, (double)rand.nextFloat() - 0.5).func_186678_a(0.05);
                    ParticleTauParticle p = new ParticleTauParticle(world, start.field_72450_a + randPos.field_72450_a, start.field_72448_b + randPos.field_72448_b, start.field_72449_c + randPos.field_72449_c, 0.05f, 0.02f, 1, 3, 0.0f);
                    p.motion((rand.nextFloat() - 0.5f) * 0.04f, (rand.nextFloat() - 0.5f) * 0.04f, (rand.nextFloat() - 0.5f) * 0.04f);
                    p.lifetime(6 + rand.nextInt(4));
                    p.color(0.2f, 0.4f + world.field_73012_v.nextFloat() * 0.5f, 1.0f, 2.0f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                }
                if (Minecraft.func_71410_x().field_71441_e.func_72820_D() % 2L == 0L) {
                    ModEventHandlerClient.firstPersonAuxParticles.add(new ParticleGluonMuzzleSmoke(world, 0.0, 0.0, 4.1, 0, ResourceManager.gluon_muzzle_smoke, 10.0f, 50.0f, 9.0f).color(0.2f, 0.4f + world.field_73012_v.nextFloat() * 0.5f, 1.0f, 3.0f).lifetime(10));
                }
                if (Minecraft.func_71410_x().field_71441_e.func_72820_D() % 4L == 0L) {
                    ModEventHandlerClient.firstPersonAuxParticles.add(new ParticleGluonMuzzleSmoke(world, 0.0, 0.0, 4.0, 1, ResourceManager.gluon_muzzle_glow, 30.0f, 50.0f, -1.0f).color(0.2f, 0.4f + world.field_73012_v.nextFloat() * 0.5f, 1.0f, 2.0f).lifetime(16));
                }
                if (activeTicks < 3) {
                    for (i = 0; i < 3; ++i) {
                        ModEventHandlerClient.firstPersonAuxParticles.add(new ParticleGluonMuzzleSmoke(world, 0.0, 0.0, 4.1, 0, ResourceManager.gluon_muzzle_smoke, 10.0f, 50.0f, 25.0f).color(0.2f, 0.4f, 1.0f, 3.0f).lifetime(7));
                    }
                    if (activeTicks == 1) {
                        ModEventHandlerClient.firstPersonAuxParticles.add(new ParticleGluonMuzzleSmoke(world, 0.0, 0.0, 4.1, 0, ResourceManager.flare, 10.0f, 50.0f, 25.0f).color(0.2f, 0.4f, 1.0f, 3.0f).lifetime(7));
                    }
                }
            } else {
                activeTicks = Math.max(activeTicks - 1, 0);
                activeTrailParticles.remove(player);
            }
        }
    }

    @Override
    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, EnumHand hand) {
        super.updateServer(stack, world, player, slot, hand);
        if (hand == EnumHand.OFF_HAND) {
            return;
        }
        if (ItemGunEgon.getIsMouseDown(stack) && Library.countInventoryItem(player.field_71071_by, ItemGunEgon.getBeltType(player, stack, true)) >= 2) {
            ItemGunEgon.setIsFiring(stack, true);
            if (world.func_72820_D() % 5L == 0L) {
                Library.consumeInventoryItem(player.field_71071_by, ItemGunEgon.getBeltType(player, stack, true));
                Library.consumeInventoryItem(player.field_71071_by, ItemGunEgon.getBeltType(player, stack, true));
            }
            float[] angles = ItemGunEgon.getBeamDirectionOffset(player.field_70170_p.func_72820_D() + 1L);
            Vec3d look = Library.changeByAngle(player.func_70676_i(1.0f), angles[0], angles[1]);
            RayTraceResult r = Library.rayTraceIncludeEntitiesCustomDirection(player, look, 50.0, 1.0f);
            if (r != null && r.field_72313_a == RayTraceResult.Type.ENTITY && r.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)r.field_72308_g;
                if (ent instanceof EntityPlayer && ((EntityPlayer)ent).func_184812_l_()) {
                    return;
                }
                this.charge *= chargeScaling;
                float damage = Math.min(ent.func_110143_aJ(), this.charge);
                ent.func_110142_aN().func_94547_a(ModDamageSource.gluon, ent.func_110143_aJ(), damage);
                ent.func_70606_j(ent.func_110143_aJ() - damage);
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PacketSpecialDeath((Entity)ent, 1, new float[0]), (Entity)ent);
                if (ent instanceof EntityPlayerMP) {
                    PacketDispatcher.wrapper.sendTo((IMessage)new PacketSpecialDeath((Entity)ent, 1, new float[0]), (EntityPlayerMP)ent);
                }
                if (ent.func_110143_aJ() <= 0.0f) {
                    PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PacketSpecialDeath((Entity)ent, 0, new float[0]), (Entity)ent);
                    ent.func_70106_y();
                    ent.func_70645_a(ModDamageSource.gluon);
                    ent.func_174812_G();
                    if (ent instanceof EntityPlayerMP) {
                        PacketDispatcher.wrapper.sendTo((IMessage)new PacketSpecialDeath((Entity)ent, 0, new float[0]), (EntityPlayerMP)ent);
                    }
                }
            } else {
                this.charge = 1.0f;
            }
        } else {
            ItemGunEgon.setIsFiring(stack, false);
        }
    }

    public static void setIsFiring(ItemStack stack, boolean b) {
        ItemGunEgon.writeNBT(stack, "egonFiring", b ? 1 : 0);
    }

    public static boolean getIsFiring(ItemStack stack) {
        return ItemGunEgon.readNBT(stack, "egonFiring") == 1;
    }

    @Override
    protected boolean tryShoot(ItemStack stack, World world, EntityPlayer player, boolean main2) {
        return false;
    }

    public static float getFirstPersonAnimFade(EntityPlayer ent) {
        if (ent.func_184614_ca().func_77973_b() != ModItems.gun_egon) {
            return 0.0f;
        }
        return MathHelper.func_76131_a((float)((m1 && Library.countInventoryItem(ent.field_71071_by, ItemGunEgon.getBeltType(ent, ent.func_184614_ca(), true)) >= 2 ? (float)activeTicks + MainRegistry.proxy.partialTicks() : (float)activeTicks - MainRegistry.proxy.partialTicks()) / 5.0f), (float)0.0f, (float)1.0f);
    }

    public static float[] getBeamDirectionOffset(float time) {
        float sinval = MathHelper.func_76126_a((float)(time * 1.2f)) + MathHelper.func_76126_a((float)(time * 0.8f - 10.0f)) + MathHelper.func_76126_a((float)(time * 1.0f + 10.0f));
        sinval /= 3.0f;
        float sinval2 = MathHelper.func_76126_a((float)(time * 0.6f)) + MathHelper.func_76126_a((float)(time * 0.2f + 20.0f)) + MathHelper.func_76126_a((float)(time * 0.1f + 20.0f));
        return new float[]{BobMathUtil.remap(sinval /= 3.0f, -1.0f, 1.0f, -3.0f, 3.0f), BobMathUtil.remap(sinval2, -1.0f, 1.0f, -0.5f, 0.5f)};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomHudElement() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHud(ScaledResolution res, GuiIngame gui, ItemStack stack, float partialTicks) {
        float x = res.func_78326_a() / 2;
        float y = res.func_78328_b() / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.gluontau_hud);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.drawGuiRect(x - 2.0f, y - 2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 1.0f, 1.0f);
        RenderHelper.resetColor();
        GlStateManager.func_179084_k();
    }
}

