/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hbm.handler.WeaponAbility;
import com.hbm.items.ModItems;
import com.hbm.items.tool.IItemAbility;
import com.hbm.lib.HBMSoundHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSwordAbility
extends ItemSword
implements IItemAbility {
    private EnumRarity rarity = EnumRarity.COMMON;
    protected float damage;
    protected double movement;
    private List<WeaponAbility> hitAbility = new ArrayList<WeaponAbility>();

    public ItemSwordAbility(float damage, double movement, Item.ToolMaterial material, String s) {
        super(material);
        this.damage = damage;
        this.movement = movement;
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add((Item)this);
    }

    public ItemSwordAbility addHitAbility(WeaponAbility weaponAbility) {
        this.hitAbility.add(weaponAbility);
        return this;
    }

    public ItemSwordAbility setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity != EnumRarity.COMMON ? this.rarity : super.func_77613_e(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && !this.hitAbility.isEmpty() && attacker instanceof EntityPlayer && this.canOperate(stack)) {
            if (this == ModItems.mese_gavel) {
                attacker.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, HBMSoundHandler.whack, SoundCategory.HOSTILE, 3.0f, 1.0f);
            }
            for (WeaponAbility ability : this.hitAbility) {
                ability.onHit(attacker.field_70170_p, (EntityPlayer)attacker, (Entity)target, this);
            }
        }
        stack.func_77972_a(1, attacker);
        return super.func_77644_a(stack, target, attacker);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635"), "Tool modifier", this.movement, 1));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damage, 0));
        }
        return map;
    }

    @Override
    public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ, EnumHand hand) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175623_d(pos)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState block = world.func_180495_p(pos);
        if (!this.canHarvestBlock(block, stack)) {
            return;
        }
        IBlockState refBlock = world.func_180495_p(new BlockPos(refX, refY, refZ));
        float refStrength = ForgeHooks.blockStrength((IBlockState)refBlock, (EntityPlayer)player, (World)world, (BlockPos)new BlockPos(refX, refY, refZ));
        float strength = ForgeHooks.blockStrength((IBlockState)block, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        int event = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        if (event < 0) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, false)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return;
        }
        player.func_184586_b(hand).func_179548_a(world, block, pos, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
                block.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, block, world.func_175625_s(pos), stack);
                block.func_177230_c().func_180637_b(world, pos, event);
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack;
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)block));
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if ((itemstack = player.func_184586_b(hand)) != null) {
                itemstack.func_179548_a(world, block, new BlockPos(x, y, z), (EntityPlayer)player);
                if (itemstack.func_190926_b()) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, new BlockPos(x, y, z), Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (!this.hitAbility.isEmpty()) {
            list.add("Weapon modifiers: ");
            for (WeaponAbility ability : this.hitAbility) {
                list.add("  " + TextFormatting.RED + ability.getFullName());
            }
        }
    }

    protected boolean canOperate(ItemStack stack) {
        return true;
    }
}

