/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSurveyScanner
extends Item {
    public ItemSurveyScanner(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add(this);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Right click to perform scan.");
        tooltip.add("Shift click to change mode.");
        tooltip.add("Current mode: " + (this.getMode(stack) == 0 ? "\u00a73Resources\u00a7r" : "\u00a76Structures\u00a7r"));
    }

    public int getMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("mode", 0);
            return 0;
        }
        return stack.func_77978_p().func_74762_e("mode");
    }

    public void setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("mode", mode);
    }

    public int getLevel(IBlockState state, int i) {
        Block b = state.func_177230_c();
        if (i == 0) {
            if (b == ModBlocks.ore_bedrock_block) {
                return 1000;
            }
            ItemStack stack = new ItemStack(b, 1, b.func_176201_c(state));
            if (stack.func_190926_b()) {
                return 0;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            for (int j = 0; j < ids.length; ++j) {
                String s = OreDictionary.getOreName((int)ids[j]);
                if (s.length() <= 3 || !s.substring(0, 3).equals("ore")) continue;
                return 1;
            }
        } else {
            if (b == Blocks.field_150344_f || b == Blocks.field_150347_e || b == Blocks.field_150359_w || b == Blocks.field_150417_aV) {
                return 1;
            }
            if (b instanceof IBomb) {
                return 100;
            }
            if (b instanceof ITileEntityProvider) {
                return 10;
            }
            if (b == Blocks.field_150385_bj) {
                return 5;
            }
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            int mode = this.getMode(stack);
            this.setMode(stack, mode == 1 ? 0 : 1);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.techBoop, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(mode == 0 ? "\u00a76[Scanner]\u00a7e Mode switched to \u00a76Structures\u00a7r" : "\u00a73[Scanner]\u00a7b Mode switched to \u00a73Resources\u00a7r", new Object[0]));
            }
        } else {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            int mode = this.getMode(stack);
            int level = 0;
            int range = 25;
            int samples = 500;
            int lx = 0;
            int lz = 0;
            for (int i = 0; i < samples; ++i) {
                lx = (int)MathHelper.func_151237_a((double)(world.field_73012_v.nextGaussian() * (double)range / 3.0), (double)(-range), (double)range);
                lz = (int)MathHelper.func_151237_a((double)(world.field_73012_v.nextGaussian() * (double)range / 3.0), (double)(-range), (double)range);
                for (int ly = y + 15; ly > 0; --ly) {
                    level += this.getLevel(world.func_180495_p((BlockPos)mPos.func_181079_c(x + lx, ly, z + lz)), mode);
                }
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.techBleep, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(mode == 0 ? "\u00a73[Scanner]\u00a7b Ore Level: \u00a73" + level : "\u00a76[Scanner]\u00a7e Structure Level: \u00a76" + level, new Object[0]));
            }
        }
        player.func_184609_a(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.block_beryllium && Library.hasInventoryItem(player.field_71071_by, ModItems.entanglement_kit)) {
            player.func_184204_a(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

