/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.special.ItemHazard;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRTGPellet
extends ItemHazard {
    private short heat = 0;
    private boolean doesDecay = false;
    private Item decayItem = null;
    private long halflife = 0L;
    private long lifespan = 0L;
    private static final String[] facts = new String[]{"One gram of Pu-238 costs $8,000.", "One gram of Pu-238 produces just under half a Watt of decay heat.", "The typical plutonium RTG contains close to eight kilograms of Pu-238.", "Pu-238's half life is 87.7 years.", "A plutonium RTG was used to power the New Horizons probe that visited Pluto in 2015.", "Po-210 can also be used for RTGs as it generates 140 W/g of decay heat due to its 138 day half life.", "Pa-231 is an isotope of protactinium that easily fissions, but it isn't quite fissile.", "Muons generated by matter-antimatter reactions can trigger nuclear fusion reactions at room temperature.", "Roughly 20% of U-235 nuclei will fail to fission when hit by a neutron. They become U-236 nuclei instead.", "Thorium reactors are really uranium reactors that convert thorium into U-233.", "Natural uranium consists of 99.284% U-238, 0.711% U-235, and 0.0055% U-234.", "Most nuclear reactors use uranium that has been enriched to 3-5% U-235.", "Uranium-based nuclear weapons require uranium enriched to at least 85-90% U-235.", "Depleted uranium is uranium that has had most of its U-235 removed. It is effectively pure U-238.", "In the 1920s, uranium was considered a useless byproduct of the production of radium.", "The Manhattan Project referred to refined natural uranium as tuballoy, enriched uranium as oralloy, and depleted uranium as depletalloy."};

    public ItemRTGPellet(int heatIn, float radiation, String s) {
        super(radiation, s);
        this.heat = (short)heatIn;
        this.func_77625_d(1);
        this.func_77655_b(s);
    }

    public ItemRTGPellet setDecays(Item depleted, long halflife, int halflifes) {
        this.doesDecay = true;
        this.decayItem = depleted;
        this.halflife = halflife;
        this.lifespan = halflife * (long)halflifes;
        return this;
    }

    public long getMaxLifespan() {
        return this.lifespan;
    }

    public long getHalfLife() {
        return this.halflife;
    }

    public short getHeat() {
        return this.heat;
    }

    @CheckForNull
    public Item getDecayItem() {
        return this.decayItem == null ? null : this.decayItem;
    }

    public boolean getDoesDecay() {
        return this.doesDecay;
    }

    public static ItemStack handleDecay(ItemStack stack, ItemRTGPellet instance) {
        if (instance.getDoesDecay()) {
            if (instance.getLifespan(stack) <= 0L) {
                return new ItemStack(instance.getDecayItem());
            }
            instance.decay(stack);
        }
        return stack;
    }

    public void decay(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRTGPellet) {
            if (!((ItemRTGPellet)stack.func_77973_b()).getDoesDecay()) {
                return;
            }
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("PELLET_DEPLETION", this.getLifespan(stack) - 1L);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("PELLET_DEPLETION", this.getMaxLifespan());
            }
        }
    }

    public long getLifespan(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemRTGPellet) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74763_f("PELLET_DEPLETION");
            }
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("PELLET_DEPLETION", this.getMaxLifespan());
            return this.getMaxLifespan();
        }
        return 0L;
    }

    public static double getDecay(ItemRTGPellet fuel, ItemStack stack) {
        return Math.pow(0.5, (double)(fuel.getMaxLifespan() - fuel.getLifespan(stack)) / (double)fuel.getHalfLife());
    }

    public static short getScaledPower(ItemRTGPellet fuel, ItemStack stack) {
        return (short)Math.ceil((double)fuel.getHeat() * ItemRTGPellet.getDecay(fuel, stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        if (!world.field_72995_K) {
            player.func_145747_a(new TextComponentString(facts[world.field_73012_v.nextInt(facts.length)]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        }
        return super.func_77659_a(world, player, handIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDoesDecay() && this.getLifespan(stack) != this.getMaxLifespan();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ItemRTGPellet instance = (ItemRTGPellet)stack.func_77973_b();
        return 1.0 - ItemRTGPellet.getDecay(instance, stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, list, flagIn);
        ItemRTGPellet instance = (ItemRTGPellet)stack.func_77973_b();
        list.add("\u00a7c" + I18nUtil.resolveKey("desc.item.rtgHeat", ItemRTGPellet.getScaledPower(instance, stack)) + "\u00a7r");
        if (instance.getDoesDecay()) {
            list.add("\u00a7aFuel left: " + (double)((int)(ItemRTGPellet.getDecay(instance, stack) * 1.0E8)) / 1000000.0 + "%\u00a7r");
            list.add(I18nUtil.resolveKey("desc.item.rtgDecay", new ItemStack(instance.getDecayItem()).func_82833_r()));
            list.add("EXTENDED INFO:");
            list.add(String.format("%s / %s ticks", instance.getLifespan(stack), instance.getMaxLifespan()));
            String[] halfLife = BobMathUtil.ticksToDate(instance.getHalfLife());
            String[] timeLeft = BobMathUtil.ticksToDate(instance.getLifespan(stack));
            String[] maxLife = BobMathUtil.ticksToDate(instance.getMaxLifespan());
            list.add(String.format("\u00a7aHalf life:      %sy %sd %sh %sm %ss\u00a7r", halfLife));
            list.add(String.format("Time remaining: %sy %sd %sh %sm %ss", timeLeft));
            list.add(String.format("Decay Time:     %sy %sd %sh %sm %ss", maxLife));
        }
    }

    public String getData() {
        return String.format("%s (%s HE/t) %s", I18nUtil.resolveKey(this.func_77658_a().concat(".name"), new Object[0]), this.getHeat() * 5, this.getDoesDecay() ? " (decays)" : "");
    }
}

