/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.special.ItemHazard;
import com.hbm.lib.Library;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemFuelRod
extends ItemHazard {
    private int lifeTime;
    private int heat;
    private float irad;
    private boolean iblind;

    public ItemFuelRod(float radiation, boolean blinding, int life, int heat, String s) {
        super(radiation, false, blinding, s);
        this.irad = radiation;
        this.iblind = blinding;
        this.lifeTime = life;
        this.heat = heat;
        this.func_77656_e(100);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GREEN + "[Radioactive]");
        tooltip.add(TextFormatting.YELLOW + "" + this.irad + " RAD/s");
        if (this.iblind) {
            tooltip.add(TextFormatting.DARK_AQUA + "[Blinding]");
        }
        tooltip.add(TextFormatting.GOLD + "[Reactor Fuel Rod]");
        tooltip.add(TextFormatting.DARK_AQUA + "  Generates " + this.heat + " heat per tick");
        tooltip.add(TextFormatting.DARK_AQUA + "  Lasts " + Library.getShortNumber(this.lifeTime) + " ticks");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return super.initCapabilities(stack, nbt);
    }

    public static void setLifetime(ItemStack stack, int time) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("life", time);
    }

    public static int getLifeTime(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return 0;
        }
        return stack.func_77978_p().func_74762_e("life");
    }

    public int getMaxLifeTime() {
        return this.lifeTime;
    }

    public int getHeatPerTick() {
        return this.heat;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemFuelRod.getLifeTime(stack) / (double)((ItemFuelRod)stack.func_77973_b()).lifeTime;
    }
}

