/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.config.GeneralConfig;
import com.hbm.forgefluid.FluidTypeHandler;
import com.hbm.forgefluid.HbmFluidHandlerItemStack;
import com.hbm.interfaces.IHasCustomModel;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidTank
extends Item
implements IHasCustomModel {
    public static final ModelResourceLocation fluidTankModel = new ModelResourceLocation("hbm:fluid_tank_full", "inventory");
    public static final ModelResourceLocation fluidBarrelModel = new ModelResourceLocation("hbm:fluid_barrel_full", "inventory");
    private int cap;

    public ItemFluidTank(String s, int cap) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77637_a(MainRegistry.controlTab);
        this.func_77627_a(true);
        this.func_77656_e(cap);
        this.func_77625_d(1);
        this.cap = cap;
        ModItems.ALL_ITEMS.add(this);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemFluidTank.isFullOrEmpty(stack) ? 64 : 1;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (GeneralConfig.registerTanks && (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g)) {
            ItemStack empty = new ItemStack((Item)this, 1, 0);
            empty.func_77982_d(new NBTTagCompound());
            items.add((Object)empty);
            for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
                if (FluidTypeHandler.noContainer((Fluid)entry.getValue())) continue;
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack((Fluid)entry.getValue(), this.cap).writeToNBT(new NBTTagCompound()));
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String s = ("" + I18n.func_135052_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[0])).trim();
        String s1 = null;
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            s1 = "" + I18n.func_135052_a((String)FluidUtil.getFluidContained((ItemStack)stack).getLocalizedName(), (Object[])new Object[0]).trim();
        } else {
            if (this == ModItems.fluid_tank_full) {
                return "Empty Universal Fluid Tank";
            }
            if (this == ModItems.fluid_barrel_full) {
                return "Empty Fluid Barrel";
            }
        }
        if (s1 != null) {
            s = s + " " + s1;
        }
        return s;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new HbmFluidHandlerItemStack(stack, this.cap);
    }

    @Override
    public ModelResourceLocation getResourceLocation() {
        if (this == ModItems.fluid_tank_full) {
            return fluidTankModel;
        }
        if (this == ModItems.fluid_barrel_full) {
            return fluidBarrelModel;
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        String s = (f == null ? "0" : Integer.valueOf(f.amount)) + "/" + this.cap + " mb";
        if (stack.func_190916_E() > 1) {
            s = stack.func_190916_E() + "x " + s;
        }
        list.add(s);
    }

    public static ItemStack getFullBarrel(Fluid f, int amount) {
        ItemStack stack = new ItemStack(ModItems.fluid_barrel_full, amount, 0);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, 16000).writeToNBT(new NBTTagCompound()));
        return stack;
    }

    public static ItemStack getFullBarrel(Fluid f) {
        return ItemFluidTank.getFullBarrel(f, 1);
    }

    public static ItemStack getFullTank(Fluid f, int amount) {
        ItemStack stack = new ItemStack(ModItems.fluid_tank_full, amount, 0);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, 1000).writeToNBT(new NBTTagCompound()));
        return stack;
    }

    public static ItemStack getFullTank(Fluid f) {
        return ItemFluidTank.getFullTank(f, 1);
    }

    public static boolean isFullOrEmpty(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() == ModItems.fluid_barrel_full) {
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
            if (f == null) {
                return true;
            }
            return f.amount == 16000 || f.amount == 0;
        }
        if (stack.func_77942_o() && stack.func_77973_b() == ModItems.fluid_tank_full) {
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
            if (f == null) {
                return true;
            }
            return f.amount == 1000 || f.amount == 0;
        }
        return stack.func_77973_b() == ModItems.fluid_barrel_full || stack.func_77973_b() == ModItems.fluid_tank_full;
    }

    public static boolean isEmptyTank(ItemStack out) {
        return out.func_77973_b() == ModItems.fluid_tank_full && FluidUtil.getFluidContained((ItemStack)out) == null;
    }

    public static boolean isFullTank(ItemStack stack, Fluid fluid) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        return stack.func_77973_b() == ModItems.fluid_tank_full && f != null && f.getFluid() == fluid && f.amount == 1000;
    }

    public static boolean isEmptyBarrel(ItemStack out) {
        return out.func_77973_b() == ModItems.fluid_barrel_full && FluidUtil.getFluidContained((ItemStack)out) == null;
    }

    public static boolean isFullBarrel(ItemStack stack, Fluid fluid) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        return stack.func_77973_b() == ModItems.fluid_barrel_full && f != null && f.getFluid() == fluid && f.amount == 16000;
    }
}

