/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.capability.HbmCapability;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSBPowered;
import com.hbm.items.gear.ArmorFSB;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.model.ModelArmorDNT;
import com.hbm.util.I18nUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorDNT
extends ArmorFSBPowered {
    @SideOnly(value=Side.CLIENT)
    ModelArmorDNT[] models;
    private static final UUID speed = UUID.fromString("6ab858ba-d712-485c-bae9-e5e765fc555a");

    public ArmorDNT(ItemArmor.ArmorMaterial material, int layer, EntityEquipmentSlot slot, String texture, long maxPower, long chargeRate, long consumption, long drain, String s) {
        super(material, layer, slot, texture, maxPower, chargeRate, consumption, drain, s);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.models == null) {
            this.models = new ModelArmorDNT[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorDNT(i);
            }
        }
        return this.models[armorSlot.func_188454_b()];
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this != ModItems.dns_plate) {
            return;
        }
        HbmCapability.IHBMData props = HbmCapability.getData((Entity)player);
        Multimap multimap = super.getAttributeModifiers(EntityEquipmentSlot.CHEST, stack);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speed, "DNT SPEED", 0.25, 0));
        player.func_110140_aT().func_111148_a(multimap);
        if (player.func_70051_ag()) {
            player.func_110140_aT().func_111147_b(multimap);
        }
        if (!world.field_72995_K && ArmorDNT.hasFSBArmor((EntityLivingBase)player) && (props.isJetpackActive() || !player.field_70122_E && !player.func_70093_af() && props.getEnableBackpack())) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "jetpack_dns");
            data.func_74768_a("player", player.func_145782_y());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
        }
        if (ArmorDNT.hasFSBArmor((EntityLivingBase)player)) {
            ArmorUtil.resetFlightTime(player);
            if (props.isJetpackActive()) {
                if (player.field_70181_x < 0.6) {
                    player.field_70181_x += 0.2;
                }
                player.field_70143_R = 0.0f;
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.immolatorShoot, SoundCategory.PLAYERS, 0.125f, 1.5f);
            } else if (!player.func_70093_af() && !player.field_70122_E && props.getEnableBackpack()) {
                player.field_70143_R = 0.0f;
                if (player.field_70181_x < -1.0) {
                    player.field_70181_x += 0.4;
                } else if (player.field_70181_x < -0.1) {
                    player.field_70181_x += 0.2;
                } else if (player.field_70181_x < 0.0) {
                    player.field_70181_x = 0.0;
                }
                player.field_70159_w *= 1.05;
                player.field_70179_y *= 1.05;
                if (player.field_191988_bg != 0.0f) {
                    player.field_70159_w += player.func_70040_Z().field_72450_a * 0.25 * (double)player.field_191988_bg;
                    player.field_70179_y += player.func_70040_Z().field_72449_c * 0.25 * (double)player.field_191988_bg;
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.immolatorShoot, SoundCategory.PLAYERS, 0.125f, 1.5f);
            }
            if (player.func_70093_af() && !player.field_70122_E) {
                player.field_70181_x -= 0.1;
            }
        }
    }

    @Override
    public void handleAttack(LivingAttackEvent event, ArmorFSB chestplate) {
        EntityPlayer player;
        EntityLivingBase e = event.getEntityLiving();
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor((EntityLivingBase)(player = (EntityPlayer)e))) {
            if (event.getSource().func_94541_c()) {
                return;
            }
            e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, SoundEvents.field_187677_b, SoundCategory.PLAYERS, 5.0f, 1.0f + e.func_70681_au().nextFloat() * 0.5f);
            event.setCanceled(true);
        }
    }

    @Override
    public void handleHurt(LivingHurtEvent event, ArmorFSB chestplate) {
        EntityPlayer player;
        EntityLivingBase e = event.getEntityLiving();
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor((EntityLivingBase)(player = (EntityPlayer)e))) {
            if (event.getSource().func_94541_c()) {
                event.setAmount(event.getAmount() * 0.001f);
                return;
            }
            event.setAmount(0.0f);
        }
    }

    public static String getColor(long a, long b) {
        float fraction = 100.0f * (float)a / (float)b;
        if (fraction > 75.0f) {
            return "\u00a7a";
        }
        if (fraction > 25.0f) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        long power = this.getCharge(stack);
        list.add("Charge: " + ArmorDNT.getColor(power, this.maxPower) + Library.getShortNumber(power) + " \u00a72/ " + Library.getShortNumber(this.maxPower));
        list.add(TextFormatting.GOLD + I18nUtil.resolveKey("armor.fullSetBonus", new Object[0]));
        if (!this.effects.isEmpty()) {
            for (PotionEffect effect : this.effects) {
                list.add(TextFormatting.AQUA + "  " + I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]));
            }
        }
        list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.explosionImmune", new Object[0]));
        list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.cap", 5));
        list.add(TextFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.modifier", Float.valueOf(0.001f)));
        list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.vats", new Object[0]));
        list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.thermal", new Object[0]));
        list.add(TextFormatting.RED + "  " + I18nUtil.resolveKey("armor.hardLanding", new Object[0]));
        list.add(TextFormatting.DARK_RED + "  " + I18nUtil.resolveKey("armor.ignoreLimit", new Object[0]));
        list.add(TextFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.rocketBoots", new Object[0]));
        list.add(TextFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.fastFall", new Object[0]));
        list.add(TextFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.sprintBoost", new Object[0]));
    }
}

