/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.forgefluid.FluidTypeHandler;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.PressRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCassette;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.packet.ItemFolderPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GUIScreenTemplateFolder
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_planner.png");
    protected int xSize = 176;
    protected int ySize = 229;
    protected int guiLeft;
    protected int guiTop;
    int currentPage = 0;
    List<ItemStack> stacks = new ArrayList<ItemStack>();
    List<FolderButton> buttons = new ArrayList<FolderButton>();
    private final EntityPlayer player;
    private final List<ItemStack> allStacks;
    private GuiTextField search;

    private void search(String sub) {
        this.stacks.clear();
        this.currentPage = 0;
        if (sub == null || sub.isEmpty()) {
            this.stacks.addAll(this.allStacks);
            this.updateButtons();
            return;
        }
        sub = sub.toLowerCase();
        for (ItemStack stack : this.allStacks) {
            ItemCassette.TrackType track;
            if (stack.func_82833_r().toLowerCase().contains(sub)) {
                this.stacks.add(stack);
                continue;
            }
            if (stack.func_77973_b() instanceof ItemForgeFluidIdentifier) {
                Fluid fluid = ItemForgeFluidIdentifier.getType(stack);
                if (!I18nUtil.resolveKey(fluid.getUnlocalizedName(), new Object[0]).toLowerCase().contains(sub)) continue;
                this.stacks.add(stack);
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemCassette) || !I18nUtil.resolveKey((track = ItemCassette.getType(stack)).getTrackTitle(), new Object[0]).toLowerCase().contains(sub)) continue;
            this.stacks.add(stack);
        }
        this.updateButtons();
    }

    public GUIScreenTemplateFolder(EntityPlayer player) {
        int i;
        this.player = player;
        this.allStacks = new ArrayList<ItemStack>();
        for (Item i2 : PressRecipes.stamps_plate) {
            this.allStacks.add(new ItemStack(i2));
        }
        for (Item i2 : PressRecipes.stamps_wire) {
            this.allStacks.add(new ItemStack(i2));
        }
        for (Item i2 : PressRecipes.stamps_circuit) {
            this.allStacks.add(new ItemStack(i2));
        }
        for (int i3 = 1; i3 < ItemCassette.TrackType.values().length; ++i3) {
            this.allStacks.add(new ItemStack(ModItems.siren_track, 1, i3));
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (FluidTypeHandler.noID(fluid)) continue;
            this.allStacks.add(ItemForgeFluidIdentifier.getStackFromFluid(fluid));
        }
        for (i = 0; i < AssemblerRecipes.recipeList.size(); ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", i);
            ItemStack stack = new ItemStack(ModItems.assembly_template, 1, 0);
            stack.func_77982_d(tag);
            this.allStacks.add(stack);
        }
        for (i = 0; i < ChemplantRecipes.EnumChemistryTemplate.values().length; ++i) {
            this.allStacks.add(new ItemStack(ModItems.chemistry_template, 1, i));
        }
        this.search(null);
    }

    int getPageCount() {
        return (int)Math.ceil((this.stacks.size() - 1) / 35);
    }

    public void func_73876_c() {
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        if (this.currentPage > this.getPageCount()) {
            this.currentPage = this.getPageCount();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GlStateManager.func_179145_e();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(0, this.field_146289_q, this.guiLeft + 61, this.guiTop + 213, 48, 12);
        this.search.func_146193_g(0xFFFFFF);
        this.search.func_146204_h(0xFFFFFF);
        this.search.func_146185_a(false);
        this.search.func_146203_f(100);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void updateButtons() {
        if (!this.buttons.isEmpty()) {
            this.buttons.clear();
        }
        for (int i = this.currentPage * 35; i < Math.min(this.currentPage * 35 + 35, this.stacks.size()); ++i) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 + 27 * (i % 5), this.guiTop + 26 + 27 * (int)Math.floor((double)i / 5.0) - this.currentPage * 27 * 7, this.stacks.get(i)));
        }
        if (this.currentPage != 0) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 - 18, this.guiTop + 26 + 81, 1, "Previous"));
        }
        if (this.currentPage != this.getPageCount()) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 + 108 + 18, this.guiTop + 26 + 81, 2, "Next"));
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        if (i >= this.guiLeft + 45 && i < this.guiLeft + 117 && j >= this.guiTop + 211 && j < this.guiTop + 223) {
            this.search.func_146195_b(true);
        } else {
            this.search.func_146195_b(false);
        }
        try {
            for (FolderButton b : this.buttons) {
                if (!b.isMouseOnButton(i, j)) continue;
                b.executeAction();
            }
        }
        catch (Exception ex) {
            this.updateButtons();
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0]), this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0])) / 2, this.guiTop + 10, 0x404040);
        for (FolderButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 45, this.guiTop + 211, 176, 54, 72, 12);
        }
        for (FolderButton b : this.buttons) {
            b.drawButton(b.isMouseOnButton(i, j));
        }
        for (FolderButton b : this.buttons) {
            b.drawIcon(b.isMouseOnButton(i, j));
        }
        this.search.func_146194_f();
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (this.search.func_146201_a(p_73869_1_, p_73869_2_)) {
            this.search(this.search.func_146179_b());
            return;
        }
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    class FolderButton {
        int xPos;
        int yPos;
        int type;
        String info;
        ItemStack stack;

        public FolderButton(int x, int y, int t, String i) {
            this.xPos = x;
            this.yPos = y;
            this.type = t;
            this.info = i;
        }

        public FolderButton(int x, int y, ItemStack stack) {
            this.xPos = x;
            this.yPos = y;
            this.type = 0;
            this.info = stack.func_82833_r();
            this.stack = stack.func_77946_l();
        }

        public void updateButton(int mouseX, int mouseY) {
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton(boolean b) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            GUIScreenTemplateFolder.this.func_73729_b(this.xPos, this.yPos, b ? 194 : 176, this.type == 1 ? 18 : (this.type == 2 ? 36 : 0), 18, 18);
        }

        public void drawIcon(boolean b) {
            try {
                RenderHelper.func_74520_c();
                if (this.stack != null) {
                    if (this.stack.func_77973_b() == ModItems.assembly_template) {
                        GUIScreenTemplateFolder.this.field_146296_j.func_184391_a((EntityLivingBase)GUIScreenTemplateFolder.this.player, AssemblerRecipes.getOutputFromTempate(this.stack), this.xPos + 1, this.yPos + 1);
                    } else if (this.stack.func_77973_b() == ModItems.chemistry_template) {
                        GUIScreenTemplateFolder.this.field_146296_j.func_184391_a((EntityLivingBase)GUIScreenTemplateFolder.this.player, new ItemStack(ModItems.chemistry_icon, 1, this.stack.func_77952_i()), this.xPos + 1, this.yPos + 1);
                    } else {
                        GUIScreenTemplateFolder.this.field_146296_j.func_184391_a((EntityLivingBase)GUIScreenTemplateFolder.this.player, this.stack, this.xPos + 1, this.yPos + 1);
                    }
                }
                RenderHelper.func_74518_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            String s = this.info;
            if (this.stack != null) {
                if (this.stack.func_77973_b() instanceof ItemForgeFluidIdentifier) {
                    s = s + ": " + I18n.func_135052_a((String)ItemForgeFluidIdentifier.getType(this.stack).getUnlocalizedName(), (Object[])new Object[0]);
                } else if (this.stack.func_77973_b() instanceof ItemCassette) {
                    s = ItemCassette.TrackType.getEnum(this.stack.func_77952_i()).getTrackTitle();
                }
            }
            GUIScreenTemplateFolder.this.func_146283_a(Arrays.asList(s), x, y);
        }

        public void executeAction() {
            GUIScreenTemplateFolder.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.type == 0) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new ItemFolderPacket(this.stack.func_77946_l()));
            } else if (this.type == 1) {
                if (GUIScreenTemplateFolder.this.currentPage > 0) {
                    --GUIScreenTemplateFolder.this.currentPage;
                }
                GUIScreenTemplateFolder.this.updateButtons();
            } else if (this.type == 2) {
                if (GUIScreenTemplateFolder.this.currentPage < GUIScreenTemplateFolder.this.getPageCount()) {
                    ++GUIScreenTemplateFolder.this.currentPage;
                }
                GUIScreenTemplateFolder.this.updateButtons();
            }
        }
    }
}

