/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.NodeOutput;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class NodeSetVar
extends NodeOutput {
    public Control ctrl;
    public boolean global = false;
    public NodeDropdown varSelector;
    public String varName;

    public NodeSetVar(float x, float y, Control ctrl) {
        super(x, y);
        this.ctrl = ctrl;
        this.inputs.add(new NodeConnection("Input", this, 0, true, DataValue.DataType.GENERIC, new DataValueFloat(0.0f)));
        NodeDropdown globalSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            if (s.equals("Global") && !this.global) {
                this.global = true;
                this.varName = "";
            }
            if (s.equals("Local") && this.global) {
                this.global = false;
                this.varName = "";
            }
            this.setVarSelector();
            return null;
        }, () -> this.global ? "Global" : "Local");
        globalSelector.list.addItems("Global", "Local");
        this.otherElements.add(globalSelector);
        this.varSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            this.varName = s;
            DataValue val = this.global ? ctrl.getGlobalVar((String)s) : ctrl.getVar((String)s);
            ((NodeConnection)this.inputs.get((int)0)).type = val.getType();
            ((NodeConnection)this.inputs.get(0)).setDefault(val);
            return null;
        }, () -> this.varName);
        this.setVarSelector();
        this.otherElements.add(this.varSelector);
        this.varName = "";
        this.recalcSize();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "setVar");
        tag.func_74768_a("controlIdx", sys.parent.panel.controls.indexOf(sys.parent));
        tag.func_74757_a("global", this.global);
        tag.func_74778_a("varName", this.varName);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.global = tag.func_74767_n("global");
        this.varName = tag.func_74779_i("varName");
        super.readFromNBT(tag, sys);
    }

    public void setVarSelector() {
        this.varSelector.list.itemNames.clear();
        if (this.global) {
            for (String name : this.ctrl.panel.globalVars.keySet()) {
                this.varSelector.list.addItems(name);
            }
        } else {
            for (String name : this.ctrl.vars.keySet()) {
                this.varSelector.list.addItems(name);
            }
        }
    }

    @Override
    public boolean doOutput(IControllable from, Map<String, NodeSystem> sendNodeMap, List<BlockPos> positions) {
        if (this.varName.isEmpty()) {
            return false;
        }
        if (this.global) {
            this.ctrl.panel.globalVars.put(this.varName, ((NodeConnection)this.inputs.get(0)).evaluate());
        } else {
            this.ctrl.vars.put(this.varName, ((NodeConnection)this.inputs.get(0)).evaluate());
        }
        return false;
    }

    @Override
    public NodeType getType() {
        return NodeType.OUTPUT;
    }

    @Override
    public String getDisplayName() {
        return "Set Variable";
    }
}

