/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.SubElement;
import com.hbm.main.ClientProxy;
import com.hbm.render.RenderHelper;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class SubElementPlacement
extends SubElement {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/control_panel/gui_control_grid.png");
    public static ResourceLocation grid = new ResourceLocation("hbm:textures/gui/control_panel/placement_grid.png");
    public float ogPosX;
    public float ogPosY;
    public Control selectedControl;
    public boolean controlGrabbed = false;
    public GuiButton deleteElement;
    public GuiButton newElement;
    private boolean gridGrabbed = false;
    protected float gridX = 0.0f;
    protected float gridY = 0.0f;
    protected float gridScale = 0.1f;
    private float prevMouseX;
    private float prevMouseY;

    public SubElementPlacement(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.newElement = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 103, cY - 76, 20, 20, "+"));
        this.deleteElement = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 103, cY - 98, 20, 20, "-"));
        float[] cGrid = this.convertToGridSpace(cX + 10, cY + 20);
        this.gridX = -cGrid[0];
        this.gridY = cGrid[1];
        super.initGui();
    }

    protected void clear() {
        this.ogPosX = 0.0f;
        this.ogPosY = 0.0f;
        this.selectedControl = null;
        this.gridGrabbed = false;
        this.controlGrabbed = false;
        this.gridX = 0.0f;
        this.gridY = 0.0f;
        this.gridScale = 1.0f;
    }

    public void resetPrevPos() {
        this.prevMouseX = this.gui.mouseX;
        this.prevMouseY = this.gui.mouseY;
    }

    @Override
    protected void drawScreen() {
        float dWheel = Mouse.getDWheel();
        float dScale = dWheel * this.gridScale * 7.5E-4f;
        float prevX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale;
        float prevY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale;
        this.gridScale = MathHelper.func_76131_a((float)(this.gridScale - dScale), (float)0.025f, (float)0.15f);
        float currentX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale;
        float currentY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale;
        this.gridX += prevX - currentX;
        this.gridY -= prevY - currentY;
        if (this.gridGrabbed || this.gui.currentEditControl != null) {
            float dX = (this.gui.mouseX - this.prevMouseX) * this.gridScale;
            float dY = (this.gui.mouseY - this.prevMouseY) * this.gridScale;
            if (this.gridGrabbed) {
                this.gridX -= dX;
                this.gridY += dY;
            } else if (this.gui.currentEditControl != null) {
                this.gui.currentEditControl.posX += dX;
                this.gui.currentEditControl.posY += dY;
            }
        }
        if ((this.prevMouseX != this.gui.mouseX || this.prevMouseY != this.gui.mouseY) && this.controlGrabbed) {
            this.gui.control.panel.controls.remove(this.selectedControl);
            this.gui.currentEditControl = this.selectedControl;
            this.selectedControl = null;
            this.controlGrabbed = false;
        }
        this.prevMouseX = this.gui.mouseX;
        this.prevMouseY = this.gui.mouseY;
        GlStateManager.func_179140_f();
        GL11.glEnable((int)3089);
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        int minX = (cX - 78) * this.gui.res.func_78325_e();
        int minY = (cY - 111) * this.gui.res.func_78325_e();
        int maxX = (cX + 102) * this.gui.res.func_78325_e();
        int maxY = (cY + 69) * this.gui.res.func_78325_e();
        GL11.glScissor((int)minX, (int)minY, (int)Math.max(maxX - minX, 0), (int)Math.max(maxY - minY, 0));
        this.gui.field_146297_k.func_110434_K().func_110577_a(grid);
        float[] box = this.gui.control.panel.getBox();
        float[] pos1 = this.convertFromGridSpace(box[0] - 0.03125f, box[1] - 0.03125f);
        float[] pos2 = this.convertFromGridSpace(box[2] + 0.03125f, box[3] + 0.03125f);
        float uScale = this.gui.control.panel.width / 4.0f;
        float vScale = this.gui.control.panel.height / 4.0f;
        RenderHelper.drawGuiRect(pos1[0], pos1[1], 0.0f, 0.0f, pos2[0] - pos1[0], pos2[1] - pos1[1], uScale + 0.015625f, vScale + 0.015625f);
        GL11.glPushMatrix();
        float spX = this.gui.getGuiLeft();
        float spY = this.gui.getGuiTop();
        GL11.glTranslated((double)spX, (double)spY, (double)0.0);
        GL11.glScaled((double)(1.0f / this.gridScale), (double)(1.0f / this.gridScale), (double)(1.0f / this.gridScale));
        GL11.glTranslated((double)(-spX), (double)(-spY), (double)0.0);
        GL11.glTranslated((double)(-this.gridX), (double)this.gridY, (double)0.0);
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mat = new Matrix4f();
        mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        float gridMX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
        float gridMY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
        this.renderItems(gridMX, gridMY);
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
    }

    public void renderItems(float mx, float my) {
        for (Control c : this.gui.control.panel.controls) {
            this.renderControl(c);
        }
        if (this.gui.currentEditControl != null) {
            boolean canPlace;
            boolean ctrl = Keyboard.isKeyDown((int)29);
            float prevX = this.gui.currentEditControl.posX;
            float prevY = this.gui.currentEditControl.posY;
            if (ctrl) {
                this.gui.currentEditControl.posX = (float)Math.round(prevX * 4.0f) * 0.25f;
                this.gui.currentEditControl.posY = (float)Math.round(prevY * 4.0f) * 0.25f;
            }
            if (!(canPlace = this.canPlace())) {
                GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)true);
            }
            this.renderControl(this.gui.currentEditControl);
            if (ctrl) {
                this.gui.currentEditControl.posX = prevX;
                this.gui.currentEditControl.posY = prevY;
            }
            if (!canPlace) {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
    }

    public void renderControl(Control c) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(c.getGuiTexture());
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float[] box = c.getBox();
        float rgb = c == this.selectedControl ? 1.0f : 0.9f;
        buf.func_181662_b((double)box[0], (double)box[1], 0.0).func_187315_a(0.0, 0.0).func_181666_a(rgb, rgb, rgb, 1.0f).func_181675_d();
        buf.func_181662_b((double)box[0], (double)box[3], 0.0).func_187315_a(0.0, 1.0).func_181666_a(rgb, rgb, rgb, 1.0f).func_181675_d();
        buf.func_181662_b((double)box[2], (double)box[3], 0.0).func_187315_a(1.0, 1.0).func_181666_a(rgb, rgb, rgb, 1.0f).func_181675_d();
        buf.func_181662_b((double)box[2], (double)box[1], 0.0).func_187315_a(1.0, 0.0).func_181666_a(rgb, rgb, rgb, 1.0f).func_181675_d();
        tes.func_78381_a();
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(texture);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    @Override
    protected void enableButtons(boolean enable) {
        this.newElement.field_146124_l = enable;
        this.newElement.field_146125_m = enable;
        this.deleteElement.field_146124_l = enable;
        this.deleteElement.field_146125_m = enable;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.newElement) {
            this.gui.pushElement(this.gui.choice);
        } else if (button == this.deleteElement) {
            this.gui.control.panel.controls.remove(this.selectedControl);
            this.selectedControl = null;
        }
    }

    protected boolean canPlace() {
        if (this.gui.currentEditControl == null) {
            return false;
        }
        for (Control c : this.gui.control.panel.controls) {
            if (!RenderHelper.boxesOverlap(c.getBox(), this.gui.currentEditControl.getBox())) continue;
            return false;
        }
        return RenderHelper.boxContainsOther(this.gui.control.panel.getBox(), this.gui.currentEditControl.getBox());
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int button) {
        float gridMX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
        float gridMY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
        if (button == 0) {
            if (this.gui.currentEditControl != null) {
                float prevX = this.gui.currentEditControl.posX;
                float prevY = this.gui.currentEditControl.posY;
                if (Keyboard.isKeyDown((int)29)) {
                    this.gui.currentEditControl.posX = (float)Math.round(this.gui.currentEditControl.posX * 4.0f) * 0.25f;
                    this.gui.currentEditControl.posY = (float)Math.round(this.gui.currentEditControl.posY * 4.0f) * 0.25f;
                }
                if (this.canPlace()) {
                    this.gui.control.panel.controls.add(this.gui.currentEditControl);
                    this.gui.currentEditControl = null;
                } else {
                    this.gui.currentEditControl.posX = prevX;
                    this.gui.currentEditControl.posY = prevY;
                }
            } else {
                for (Control c : this.gui.control.panel.controls) {
                    if (!RenderHelper.intersects2DBox(gridMX, gridMY, c.getBox())) continue;
                    this.selectedControl = c;
                    this.controlGrabbed = true;
                    return;
                }
                this.selectedControl = null;
                this.controlGrabbed = false;
            }
        }
        if (button == 2) {
            this.gridGrabbed = true;
            this.prevMouseX = this.gui.mouseX;
            this.prevMouseY = this.gui.mouseY;
        }
    }

    @Override
    protected void mouseReleased(int mouseX, int mouseY, int state) {
        if (state == 2) {
            this.gridGrabbed = false;
        }
        if (state == 0) {
            if (this.canPlace()) {
                if (Keyboard.isKeyDown((int)29)) {
                    this.gui.currentEditControl.posX = (float)Math.round(this.gui.currentEditControl.posX * 4.0f) * 0.25f;
                    this.gui.currentEditControl.posY = (float)Math.round(this.gui.currentEditControl.posY * 4.0f) * 0.25f;
                }
                this.gui.control.panel.controls.add(this.gui.currentEditControl);
                this.gui.currentEditControl = null;
            }
            this.controlGrabbed = false;
        }
    }

    protected float[] convertToGridSpace(float x, float y) {
        float gridMX = (x - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
        float gridMY = (y - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
        return new float[]{gridMX, gridMY};
    }

    protected float[] convertFromGridSpace(float gridMX, float gridMY) {
        float x = (gridMX - this.gridX - (float)this.gui.getGuiLeft()) / this.gridScale + (float)this.gui.getGuiLeft();
        float y = (gridMY + this.gridY - (float)this.gui.getGuiTop()) / this.gridScale + (float)this.gui.getGuiTop();
        return new float[]{x, y};
    }
}

