/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.ItemList;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.SubElement;
import com.hbm.inventory.control_panel.nodes.Node;
import com.hbm.inventory.control_panel.nodes.NodeCancelEvent;
import com.hbm.inventory.control_panel.nodes.NodeEventBroadcast;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeMath;
import com.hbm.inventory.control_panel.nodes.NodeOutput;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.main.ClientProxy;
import com.hbm.render.RenderHelper;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class SubElementNodeEditor
extends SubElement {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/control_panel/gui_control_grid.png");
    public static ResourceLocation grid = new ResourceLocation("hbm:textures/gui/control_panel/grid.png");
    public GuiButton back;
    public ItemList addMenu;
    private NodeSystem currentSystem;
    private ControlEvent currentEvent;
    private List<ControlEvent> sendEvents;
    private boolean gridGrabbed = false;
    protected float gridX = 0.0f;
    protected float gridY = 0.0f;
    protected float gridScale = 1.0f;
    private float prevMouseX;
    private float prevMouseY;

    public SubElementNodeEditor(GuiControlEdit gui) {
        super(gui);
    }

    protected void setData(Map<String, NodeSystem> map, ControlEvent c, List<ControlEvent> sendEvents) {
        this.currentSystem = map.computeIfAbsent(c.name, e -> new NodeSystem(this.gui.currentEditControl, this));
        this.currentSystem.nodeEditor = this;
        this.currentSystem.gui = this.gui;
        this.currentSystem.activeNode = null;
        this.currentSystem.selectedNodes = new ArrayList<Node>();
        this.currentSystem.drag = false;
        this.currentSystem.dragDist = 0.0f;
        this.currentEvent = c;
        this.gridX = 0.0f;
        this.gridY = 0.0f;
        this.gridScale = 1.0f;
        this.sendEvents = sendEvents;
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.back = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 104, cY - 112, 20, 20, "<"));
        super.initGui();
    }

    @Override
    protected void keyTyped(char typedChar, int code) {
        if (code == 30 && Keyboard.isKeyDown((int)42)) {
            if (this.addMenu != null) {
                this.addMenu.close();
            }
            this.addMenu = new ItemList(this.gui.mouseX, this.gui.mouseY, 32.0f, s -> {
                if (s.endsWith("Input")) {
                    ItemList list = new ItemList(0.0f, 0.0f, 32.0f, s2 -> {
                        float x = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
                        float y = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
                        Node node = null;
                        if (s2.equals("Event Data")) {
                            HashMap<String, DataValue> vars = new HashMap<String, DataValue>(this.currentEvent.vars);
                            vars.put(this.sendEvents == null ? "to index" : "from index", new DataValueFloat(0.0f));
                            node = new NodeInput(x, y, "Event Data").setVars(vars);
                        } else if (s2.equals("Get Variable")) {
                            node = new NodeGetVar(x, y, this.gui.currentEditControl);
                        }
                        if (node != null) {
                            this.addMenu.close();
                            this.addMenu = null;
                            this.currentSystem.addNode(node);
                            this.currentSystem.activeNode = node;
                        }
                        return null;
                    });
                    list.addItems("Event Data");
                    list.addItems("Get Variable");
                    return list;
                }
                if (s.endsWith("Math")) {
                    ItemList list = new ItemList(0.0f, 0.0f, 32.0f, s2 -> {
                        float x = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
                        float y = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
                        NodeMath node = null;
                        if (s2.equals("Math Node")) {
                            node = new NodeMath(x, y);
                        }
                        if (node != null) {
                            this.addMenu.close();
                            this.addMenu = null;
                            this.currentSystem.addNode(node);
                            this.currentSystem.activeNode = node;
                        }
                        return null;
                    });
                    list.addItems("Math Node");
                    return list;
                }
                if (s.endsWith("Output")) {
                    ItemList list = new ItemList(0.0f, 0.0f, 32.0f, s2 -> {
                        float x = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
                        float y = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
                        NodeOutput node = null;
                        if (s2.equals("Broadcast")) {
                            node = new NodeEventBroadcast(x, y, this.sendEvents);
                        } else if (s2.equals("Cancel")) {
                            node = new NodeCancelEvent(x, y);
                        } else if (s2.equals("Set Variable")) {
                            node = new NodeSetVar(x, y, this.gui.currentEditControl);
                        }
                        if (node != null) {
                            this.addMenu.close();
                            this.addMenu = null;
                            this.currentSystem.addNode(node);
                            this.currentSystem.activeNode = node;
                        }
                        return null;
                    });
                    if (this.sendEvents != null) {
                        if (this.sendEvents.size() > 0) {
                            list.addItems("Broadcast");
                        }
                    } else {
                        list.addItems("Cancel");
                    }
                    list.addItems("Set Variable");
                    return list;
                }
                return null;
            });
            this.addMenu.addItems("{expandable}Input", "{expandable}Output", "{expandable}Math", "{expandable}Logic");
        }
        if (code == 211 || code == 45) {
            ArrayList<Node> selected = new ArrayList<Node>(this.currentSystem.selectedNodes);
            for (Node n : selected) {
                this.currentSystem.removeNode(n);
            }
        }
        if (this.currentSystem != null) {
            this.currentSystem.keyTyped(typedChar, code);
        }
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(texture);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    @Override
    protected void drawScreen() {
        float dWheel = Mouse.getDWheel();
        float dScale = dWheel * this.gridScale * 7.5E-4f;
        float prevX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale;
        float prevY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale;
        this.gridScale = MathHelper.func_76131_a((float)(this.gridScale - dScale), (float)0.25f, (float)2.5f);
        float currentX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale;
        float currentY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale;
        this.gridX += prevX - currentX;
        this.gridY -= prevY - currentY;
        if (this.gridGrabbed) {
            float dX = this.gui.mouseX - this.prevMouseX;
            float dY = this.gui.mouseY - this.prevMouseY;
            this.gridX -= dX * this.gridScale;
            this.gridY += dY * this.gridScale;
            this.prevMouseX = this.gui.mouseX;
            this.prevMouseY = this.gui.mouseY;
        }
        GlStateManager.func_179140_f();
        GL11.glEnable((int)3089);
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        int minX = (cX - 78) * this.gui.res.func_78325_e();
        int minY = (cY - 111) * this.gui.res.func_78325_e();
        int maxX = (cX + 102) * this.gui.res.func_78325_e();
        int maxY = (cY + 69) * this.gui.res.func_78325_e();
        GL11.glScissor((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        this.gui.field_146297_k.func_110434_K().func_110577_a(grid);
        float x = this.gridX / (float)this.gui.getXSize();
        float y = -this.gridY / (float)this.gui.getYSize();
        RenderHelper.drawGuiRectColor(this.gui.getGuiLeft(), this.gui.getGuiTop(), x, y, this.gui.getXSize(), this.gui.getYSize(), this.gridScale + x, this.gridScale + y, 0.2f, 0.2f, 0.2f, 1.0f);
        GL11.glPushMatrix();
        float spX = this.gui.getGuiLeft();
        float spY = this.gui.getGuiTop();
        GL11.glTranslated((double)spX, (double)spY, (double)0.0);
        GL11.glScaled((double)(1.0f / this.gridScale), (double)(1.0f / this.gridScale), (double)(1.0f / this.gridScale));
        GL11.glTranslated((double)(-spX), (double)(-spY), (double)0.0);
        GL11.glTranslated((double)(-this.gridX), (double)this.gridY, (double)0.0);
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        Matrix4f mat = new Matrix4f();
        mat.load(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        float gridMX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.gridScale + (float)this.gui.getGuiLeft() + this.gridX;
        float gridMY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.gridScale + (float)this.gui.getGuiTop() - this.gridY;
        this.currentSystem.render(gridMX, gridMY);
        GL11.glPopMatrix();
        if (this.addMenu != null) {
            this.addMenu.render(this.gui.mouseX, this.gui.mouseY);
        }
        GL11.glDisable((int)3089);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.addMenu != null && button == 0) {
            if (RenderHelper.intersects2DBox(mouseX, mouseY, this.addMenu.getBoundingBox())) {
                this.addMenu.mouseClicked(mouseX, mouseY);
            } else {
                this.addMenu.close();
                this.addMenu = null;
            }
        } else if (button == 0) {
            this.currentSystem.onClick(mouseX, mouseY);
        }
        if (button == 2) {
            this.gridGrabbed = true;
            this.prevMouseX = this.gui.mouseX;
            this.prevMouseY = this.gui.mouseY;
        }
    }

    @Override
    protected void mouseReleased(int mouseX, int mouseY, int state) {
        if (state == 2) {
            this.gridGrabbed = false;
        }
        if (this.addMenu == null && state == 0) {
            this.currentSystem.clickReleased(mouseX, mouseY);
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.back) {
            if (this.currentSystem != null) {
                this.currentSystem.removeClientData();
                this.currentSystem = null;
            }
            this.gui.popElement();
        }
    }

    @Override
    public void onClose() {
        if (this.currentSystem != null) {
            this.currentSystem.removeClientData();
            this.currentSystem = null;
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        this.back.field_146124_l = enable;
        this.back.field_146125_m = enable;
    }
}

