/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlRegistry;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.SubElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;

public class SubElementItemChoice
extends SubElement {
    public GuiButton pageLeft;
    public GuiButton pageRight;
    public int currentPage = 1;
    public int numPages = 1;
    public List<GuiButton> buttons = new ArrayList<GuiButton>();

    public SubElementItemChoice(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.pageLeft = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 75, cY + 92, 20, 20, "<"));
        this.pageRight = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 75, cY + 92, 20, 20, ">"));
        List<Control> controls = ControlRegistry.getAllControls();
        for (int i = 0; i < controls.size(); ++i) {
            int offset = i % 7 * 25;
            this.buttons.add(this.gui.func_189646_b(new GuiButton(i + 1000, cX - 70, cY - 90 + offset, 160, 20, controls.get((int)i).name)));
        }
        this.numPages = (this.buttons.size() + 6) / 7;
        super.initGui();
    }

    @Override
    protected void drawScreen() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        String text = this.currentPage + "/" + this.numPages;
        this.gui.getFontRenderer().func_175065_a(text, (float)cX, (float)(cY + 100), -8947849, false);
        text = "Select item to add";
        this.gui.getFontRenderer().func_175065_a(text, (float)(cX - this.gui.getFontRenderer().func_78256_a(text) / 2), (float)(cY - 110), -8947849, false);
    }

    private void recalculateVisibleButtons() {
        int idx;
        for (GuiButton b : this.buttons) {
            b.field_146125_m = false;
            b.field_146124_l = false;
        }
        for (int i = idx = (this.currentPage - 1) * 7; i < idx + 7 && i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).field_146125_m = true;
            this.buttons.get((int)i).field_146124_l = true;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.pageLeft) {
            this.currentPage = Math.max(1, this.currentPage - 1);
            this.recalculateVisibleButtons();
        } else if (button == this.pageRight) {
            this.currentPage = Math.min(this.numPages, this.currentPage + 1);
            this.recalculateVisibleButtons();
        } else {
            switch (button.field_146127_k) {
                case 1000: {
                    this.gui.currentEditControl = ControlRegistry.getNew("button", this.gui.control.panel);
                    this.gui.pushElement(this.gui.linker);
                }
            }
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        if (enable) {
            this.recalculateVisibleButtons();
        } else {
            for (GuiButton b : this.buttons) {
                b.field_146125_m = false;
                b.field_146124_l = false;
            }
        }
        this.pageLeft.field_146125_m = enable;
        this.pageLeft.field_146124_l = enable;
        this.pageRight.field_146125_m = enable;
        this.pageRight.field_146124_l = enable;
    }
}

