/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ButtonHoverText;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.SubElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.MathHelper;

public class SubElementEventEditor
extends SubElement {
    public List<ControlEvent> receiveEvents = new ArrayList<ControlEvent>();
    public List<ControlEvent> sendEvents = new ArrayList<ControlEvent>();
    public List<GuiButton> receiveButtons = new ArrayList<GuiButton>();
    public List<GuiButton> sendButtons = new ArrayList<GuiButton>();
    public int currentReceivePage = 1;
    public int numReceivePages = 1;
    public int currentSendPage = 1;
    public int numSendPages = 1;
    public GuiButton receivePageLeft;
    public GuiButton receivePageRight;
    public GuiButton sendPageLeft;
    public GuiButton sendPageRight;
    public GuiButton done;

    public SubElementEventEditor(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.receivePageLeft = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 74, cY - 29, 20, 20, "<"));
        this.receivePageRight = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 76, cY - 29, 20, 20, ">"));
        this.sendPageLeft = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 74, cY + 70, 20, 20, "<"));
        this.sendPageRight = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 76, cY + 70, 20, 20, ">"));
        this.done = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 74, cY + 92, 170, 20, "Done"));
        super.initGui();
    }

    protected void accumulateEventTypes(List<IControllable> list) {
        int i;
        ControlEvent evt;
        this.gui.getButtons().removeAll(this.receiveButtons);
        this.gui.getButtons().removeAll(this.sendButtons);
        this.receiveButtons.clear();
        this.sendButtons.clear();
        this.receiveEvents.clear();
        this.sendEvents.clear();
        for (IControllable c : list) {
            ControlEvent evt2;
            for (String name : c.getOutEvents()) {
                evt2 = ControlEvent.getRegisteredEvent(name);
                if (this.receiveEvents.contains(evt2)) continue;
                this.receiveEvents.add(ControlEvent.getRegisteredEvent(name));
            }
            for (String name : c.getInEvents()) {
                evt2 = ControlEvent.getRegisteredEvent(name);
                if (this.sendEvents.contains(evt2)) continue;
                this.sendEvents.add(ControlEvent.getRegisteredEvent(name));
            }
        }
        for (String name : this.gui.currentEditControl.getOutEvents()) {
            evt = ControlEvent.getRegisteredEvent(name);
            if (this.receiveEvents.contains(evt)) continue;
            this.receiveEvents.add(ControlEvent.getRegisteredEvent(name));
        }
        for (String name : this.gui.currentEditControl.getInEvents()) {
            evt = ControlEvent.getRegisteredEvent(name);
            if (this.receiveEvents.contains(evt)) continue;
            this.receiveEvents.add(ControlEvent.getRegisteredEvent(name));
        }
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.numReceivePages = (this.receiveEvents.size() + 2) / 3;
        for (i = 0; i < this.receiveEvents.size(); ++i) {
            int offset = i % 3 * 25;
            this.receiveButtons.add(this.gui.func_189646_b(new ButtonHoverText(i + 1000, cX - 74, cY - 100 + offset, 170, 20, this.receiveEvents.get((int)i).name, "<Click to edit>")));
        }
        this.currentReceivePage = MathHelper.func_76125_a((int)this.currentReceivePage, (int)1, (int)this.numReceivePages);
        this.numSendPages = (this.sendEvents.size() + 2) / 3;
        for (i = 0; i < this.sendEvents.size(); ++i) {
            int offset = i % 3 * 25;
            this.sendButtons.add(this.gui.func_189646_b(new ButtonHoverText(i + 2000, cX - 74, cY + 5 + offset, 170, 20, this.sendEvents.get((int)i).name, "<Click to edit>")));
        }
        this.currentSendPage = MathHelper.func_76125_a((int)this.currentSendPage, (int)1, (int)this.numSendPages);
    }

    private void recalculateVisibleButtons() {
        int idx;
        int i;
        for (GuiButton b : this.receiveButtons) {
            b.field_146125_m = false;
            b.field_146124_l = false;
        }
        for (GuiButton b : this.sendButtons) {
            b.field_146125_m = false;
            b.field_146124_l = false;
        }
        for (i = idx = (this.currentReceivePage - 1) * 3; i < idx + 3 && i < this.receiveButtons.size(); ++i) {
            this.receiveButtons.get((int)i).field_146125_m = true;
            this.receiveButtons.get((int)i).field_146124_l = true;
        }
        if (this.sendButtons.size() > 0) {
            for (i = idx = (this.currentSendPage - 1) * 3; i < idx + 3 && i < this.sendButtons.size(); ++i) {
                this.sendButtons.get((int)i).field_146125_m = true;
                this.sendButtons.get((int)i).field_146124_l = true;
            }
        }
    }

    @Override
    protected void drawScreen() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        String text = this.currentReceivePage + "/" + this.numReceivePages;
        this.gui.getFontRenderer().func_175065_a(text, (float)cX, (float)(cY - 20), -8947849, false);
        text = this.currentSendPage + "/" + this.numSendPages;
        this.gui.getFontRenderer().func_175065_a(text, (float)cX, (float)(cY + 82), -8947849, false);
        text = "Receivable Events";
        this.gui.getFontRenderer().func_175065_a(text, (float)(cX - this.gui.getFontRenderer().func_78256_a(text) / 2 + 10), (float)(cY - 110), -8947849, false);
        text = "Sendable Events";
        this.gui.getFontRenderer().func_175065_a(text, (float)(cX - this.gui.getFontRenderer().func_78256_a(text) / 2 + 10), (float)(cY - 5), -8947849, false);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.receivePageLeft) {
            if (this.numReceivePages != 0) {
                this.currentReceivePage = Math.max(1, this.currentReceivePage - 1);
                this.recalculateVisibleButtons();
            }
        } else if (button == this.receivePageRight) {
            this.currentReceivePage = Math.min(this.numReceivePages, this.currentReceivePage + 1);
            this.recalculateVisibleButtons();
        } else if (button == this.sendPageLeft) {
            if (this.numSendPages != 0) {
                this.currentSendPage = Math.max(1, this.currentSendPage - 1);
                this.recalculateVisibleButtons();
            }
        } else if (button == this.sendPageRight) {
            this.currentSendPage = Math.min(this.numSendPages, this.currentSendPage + 1);
            this.recalculateVisibleButtons();
        } else if (button == this.done) {
            Object sys;
            Iterator<NodeSystem> itr = this.gui.currentEditControl.receiveNodeMap.values().iterator();
            while (itr.hasNext()) {
                sys = itr.next();
                if (!((NodeSystem)sys).outputNodes.isEmpty()) continue;
                itr.remove();
            }
            itr = this.gui.currentEditControl.sendNodeMap.values().iterator();
            while (itr.hasNext()) {
                sys = itr.next();
                if (!((NodeSystem)sys).outputNodes.isEmpty()) continue;
                itr.remove();
            }
            for (IControllable c : this.gui.linker.linked) {
                if (this.gui.currentEditControl.connectedSet.contains(c.getControlPos())) continue;
                this.gui.currentEditControl.connectedSet.add(c.getControlPos());
            }
            float[] gridMouse = this.gui.placement.convertToGridSpace(this.gui.mouseX, this.gui.mouseY);
            this.gui.currentEditControl.receiveEvent(ControlEvent.newEvent("initialize"));
            this.gui.currentEditControl.posX = gridMouse[0];
            this.gui.currentEditControl.posY = gridMouse[1];
            this.gui.placement.resetPrevPos();
            this.gui.resetStack();
        } else {
            int i = this.receiveButtons.indexOf(button);
            if (i != -1) {
                this.gui.nodeEditor.setData(this.gui.currentEditControl.receiveNodeMap, this.receiveEvents.get(i), this.sendEvents);
            } else {
                i = this.sendButtons.indexOf(button);
                if (i != -1) {
                    this.gui.nodeEditor.setData(this.gui.currentEditControl.sendNodeMap, this.sendEvents.get(i), null);
                }
            }
            if (i != -1) {
                this.gui.pushElement(this.gui.nodeEditor);
            }
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        if (enable) {
            this.recalculateVisibleButtons();
        } else {
            for (GuiButton b : this.receiveButtons) {
                b.field_146125_m = false;
                b.field_146124_l = false;
            }
            for (GuiButton b : this.sendButtons) {
                b.field_146125_m = false;
                b.field_146124_l = false;
            }
        }
        this.receivePageLeft.field_146125_m = enable;
        this.receivePageLeft.field_146124_l = enable;
        this.receivePageRight.field_146125_m = enable;
        this.receivePageRight.field_146124_l = enable;
        this.sendPageLeft.field_146125_m = enable;
        this.sendPageLeft.field_146124_l = enable;
        this.sendPageRight.field_146125_m = enable;
        this.sendPageRight.field_146124_l = enable;
        this.done.field_146125_m = enable;
        this.done.field_146124_l = enable;
    }
}

