/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.SubElementNodeEditor;
import com.hbm.inventory.control_panel.nodes.Node;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeOutput;
import com.hbm.render.RenderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class NodeSystem {
    public static final ResourceLocation node_tex = new ResourceLocation("hbm:textures/gui/control_panel/node.png");
    @SideOnly(value=Side.CLIENT)
    public SubElementNodeEditor nodeEditor;
    @SideOnly(value=Side.CLIENT)
    public GuiControlEdit gui;
    @SideOnly(value=Side.CLIENT)
    public Node activeNode;
    @SideOnly(value=Side.CLIENT)
    public List<Node> selectedNodes;
    @SideOnly(value=Side.CLIENT)
    public NodeConnection connectionInProgress;
    @SideOnly(value=Side.CLIENT)
    public NodeConnection currentTypingBox;
    @SideOnly(value=Side.CLIENT)
    protected boolean drag;
    @SideOnly(value=Side.CLIENT)
    protected float dragDist;
    @SideOnly(value=Side.CLIENT)
    protected float lastMouseX;
    @SideOnly(value=Side.CLIENT)
    protected float lastMouseY;
    public Control parent;
    public List<Node> nodes = new ArrayList<Node>();
    public List<NodeOutput> outputNodes = new ArrayList<NodeOutput>();
    private Map<String, DataValue> vars = new HashMap<String, DataValue>();

    public NodeSystem(Control parent) {
        this.parent = parent;
    }

    public NodeSystem(Control parent, SubElementNodeEditor gui) {
        this(parent);
        this.nodeEditor = gui;
        this.gui = gui.gui;
        this.activeNode = null;
        this.selectedNodes = new ArrayList<Node>();
        this.drag = false;
        this.dragDist = 0.0f;
    }

    public void setVar(String name, DataValue val) {
        this.vars.put(name, val);
    }

    public DataValue getVar(String name) {
        DataValue val = this.vars.get(name);
        if (val == null) {
            return new DataValueFloat(0.0f);
        }
        return val;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound nodes = new NBTTagCompound();
        for (int i = 0; i < this.nodes.size(); ++i) {
            nodes.func_74782_a("node" + i, (NBTBase)this.nodes.get(i).writeToNBT(new NBTTagCompound(), this));
        }
        tag.func_74782_a("nodes", (NBTBase)nodes);
        NBTTagCompound vars = new NBTTagCompound();
        for (Map.Entry<String, DataValue> e : this.vars.entrySet()) {
            vars.func_74782_a(e.getKey(), e.getValue().writeToNBT());
        }
        tag.func_74782_a("vars", (NBTBase)vars);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        int i;
        this.nodes.clear();
        this.outputNodes.clear();
        NBTTagCompound nodes = tag.func_74775_l("nodes");
        for (i = 0; i < nodes.func_150296_c().size(); ++i) {
            Node node = Node.nodeFromNBT(nodes.func_74775_l("node" + i), this);
            this.nodes.add(node);
            if (!(node instanceof NodeOutput)) continue;
            this.outputNodes.add((NodeOutput)node);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).readFromNBT(nodes.func_74775_l("node" + i), this);
        }
        NBTTagCompound vars = tag.func_74775_l("vars");
        for (String k : vars.func_150296_c()) {
            NBTBase base = vars.func_74781_a(k);
            DataValue val = DataValue.newFromNBT(base);
            if (val == null) continue;
            this.vars.put(k, val);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void removeClientData() {
        this.nodeEditor = null;
        this.gui = null;
        this.activeNode = null;
        this.selectedNodes.clear();
        this.connectionInProgress = null;
        this.currentTypingBox = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float mX, float mY) {
        if (this.drag && !Keyboard.isKeyDown((int)42)) {
            float distX = this.gui.mouseX - this.lastMouseX;
            float distY = this.gui.mouseY - this.lastMouseY;
            this.dragDist = (float)((double)this.dragDist + Math.sqrt(distX * distX + distY * distY));
            for (Node n : this.selectedNodes) {
                n.setPosition(n.posX + (this.gui.mouseX - this.lastMouseX) * this.nodeEditor.gridScale, n.posY + (this.gui.mouseY - this.lastMouseY) * this.nodeEditor.gridScale);
            }
            this.lastMouseX = this.gui.mouseX;
            this.lastMouseY = this.gui.mouseY;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)3.0f);
        GL11.glEnable((int)2848);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        float nodeMx = mX;
        float nodeMy = mY;
        if (this.connectionInProgress != null) {
            block1: for (int i = this.nodes.size() - 1; i >= 0; --i) {
                Node n;
                n = this.nodes.get(i);
                if (!RenderHelper.intersects2DBox(mX, mY, n.getExtendedBoundingBox())) continue;
                for (NodeConnection c : this.connectionInProgress.isInput ? n.outputs : n.inputs) {
                    if (this.connectionInProgress.parent == c.parent || !RenderHelper.intersects2DBox(mX, mY, c.getPortBox())) continue;
                    float[] center = RenderHelper.getBoxCenter(c.getPortBox());
                    nodeMx = center[0];
                    nodeMy = center[1];
                    break block1;
                }
            }
        }
        for (Node node : this.nodes) {
            node.drawConnections(nodeMx, nodeMy);
        }
        Tessellator.func_178181_a().func_78381_a();
        GL11.glDisable((int)2848);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179098_w();
        for (Node node : this.nodes) {
            node.render(mX, mY, this.activeNode == node, this.selectedNodes.contains(node));
        }
    }

    public void addNode(Node n) {
        this.nodes.add(n);
        if (n instanceof NodeOutput) {
            this.outputNodes.add((NodeOutput)n);
        }
    }

    public void removeNode(Node n) {
        if (this.activeNode == n) {
            this.activeNode = null;
        }
        this.selectedNodes.remove(n);
        this.outputNodes.remove(n);
        this.nodes.remove(n);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(float x, float y) {
        int i;
        this.lastMouseX = this.gui.mouseX;
        this.lastMouseY = this.gui.mouseY;
        float gridMX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.nodeEditor.gridScale + (float)this.gui.getGuiLeft() + this.nodeEditor.gridX;
        float gridMY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.nodeEditor.gridScale + (float)this.gui.getGuiTop() - this.nodeEditor.gridY;
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            if (!this.nodes.get(i).onClick(gridMX, gridMY)) continue;
            return;
        }
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            Node n = this.nodes.get(i);
            if (!RenderHelper.intersects2DBox(gridMX, gridMY, n.getExtendedBoundingBox())) continue;
            ArrayList<NodeConnection> union = new ArrayList<NodeConnection>();
            union.addAll(n.inputs);
            union.addAll(n.outputs);
            for (NodeConnection c : union) {
                if (!RenderHelper.intersects2DBox(gridMX, gridMY, c.getPortBox())) continue;
                if (c.connection != null) {
                    this.connectionInProgress = c.removeConnection();
                    this.connectionInProgress.drawsLine = true;
                } else {
                    this.connectionInProgress = c;
                    c.drawsLine = true;
                }
                return;
            }
        }
        this.drag = true;
        this.dragDist = 0.0f;
        boolean shift = Keyboard.isKeyDown((int)42);
        if (!shift && this.selectedNodes.size() <= 1) {
            this.selectedNodes.clear();
            this.activeNode = null;
        }
        boolean clear = true;
        for (int i2 = this.nodes.size() - 1; i2 >= 0; --i2) {
            Node n = this.nodes.get(i2);
            boolean intersectsBox = RenderHelper.intersects2DBox(gridMX, gridMY, n.getBoundingBox());
            for (NodeConnection c : n.inputs) {
                if (c.enumSelector != null) {
                    if (this.currentTypingBox != null) {
                        this.currentTypingBox.stopTyping();
                        this.currentTypingBox = null;
                    }
                    if (c.enumSelector.onClick(gridMX, gridMY)) {
                        return;
                    }
                }
                if (!intersectsBox || !RenderHelper.intersects2DBox(gridMX, gridMY, c.getValueBox()) || this.currentTypingBox == c || c.connection != null) continue;
                c.isTyping = true;
                c.startTyping();
                if (this.currentTypingBox != null) {
                    this.currentTypingBox.stopTyping();
                }
                this.currentTypingBox = c;
            }
            if (!intersectsBox) continue;
            clear = false;
            if (this.activeNode == n && this.selectedNodes.size() <= 1) {
                this.selectedNodes.remove(n);
                this.activeNode = null;
                break;
            }
            if (!this.selectedNodes.contains(n)) {
                this.selectedNodes.add(n);
            }
            this.activeNode = n;
            break;
        }
        if (this.currentTypingBox != null && !RenderHelper.intersects2DBox(gridMX, gridMY, this.currentTypingBox.getValueBox())) {
            this.currentTypingBox.stopTyping();
            this.currentTypingBox = null;
        }
        if (clear) {
            this.selectedNodes.clear();
            this.activeNode = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clickReleased(float x, float y) {
        Node n;
        int i;
        float gridMX = (this.gui.mouseX - (float)this.gui.getGuiLeft()) * this.nodeEditor.gridScale + (float)this.gui.getGuiLeft() + this.nodeEditor.gridX;
        float gridMY = (this.gui.mouseY - (float)this.gui.getGuiTop()) * this.nodeEditor.gridScale + (float)this.gui.getGuiTop() - this.nodeEditor.gridY;
        if (this.connectionInProgress != null) {
            for (i = this.nodes.size() - 1; i >= 0; --i) {
                n = this.nodes.get(i);
                if (!RenderHelper.intersects2DBox(gridMX, gridMY, n.getExtendedBoundingBox())) continue;
                for (NodeConnection c : this.connectionInProgress.isInput ? n.outputs : n.inputs) {
                    if (this.connectionInProgress.parent == c.parent || !RenderHelper.intersects2DBox(gridMX, gridMY, c.getPortBox())) continue;
                    c.removeConnection();
                    if (c.isInput) {
                        this.connectionInProgress.drawsLine = false;
                        c.drawsLine = true;
                        c.connection = this.connectionInProgress.parent;
                        c.connectionIndex = this.connectionInProgress.index;
                    } else {
                        this.connectionInProgress.connection = n;
                        this.connectionInProgress.connectionIndex = c.index;
                    }
                    this.connectionInProgress = null;
                    return;
                }
            }
            this.connectionInProgress.drawsLine = false;
            this.connectionInProgress = null;
        }
        if (!Keyboard.isKeyDown((int)42) && this.dragDist == 0.0f) {
            for (i = this.nodes.size() - 1; i >= 0; --i) {
                n = this.nodes.get(i);
                if (!RenderHelper.intersects2DBox(gridMX, gridMY, n.getBoundingBox())) continue;
                this.selectedNodes.clear();
                this.selectedNodes.add(n);
                this.activeNode = n;
                break;
            }
        }
        this.drag = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyTyped(char c, int key) {
        if (this.currentTypingBox != null) {
            this.currentTypingBox.keyTyped(c, key);
            if (!this.currentTypingBox.isTyping) {
                this.currentTypingBox = null;
            }
        }
    }

    public void resetCachedValues() {
        for (Node n : this.nodes) {
            n.cacheValid = false;
        }
    }

    public void receiveEvent(ControlPanel panel, Control ctrl, ControlEvent evt) {
        for (Node n : this.nodes) {
            if (!(n instanceof NodeInput)) continue;
            ((NodeInput)n).setOutputFromVars(evt.vars);
        }
        for (NodeOutput o : this.outputNodes) {
            o.doOutput(panel.parent, ctrl.sendNodeMap, ctrl.connectedSet);
        }
    }
}

