/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.DataValue;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class DataValueEnum<T extends Enum<T>>
extends DataValue {
    public Enum<T> value;
    public Class<T> enumClass;

    public DataValueEnum(Enum<T> e) {
        this.value = e;
        if (e != null) {
            this.enumClass = e.getClass();
        }
    }

    @Override
    public float getNumber() {
        return this.value.ordinal();
    }

    @Override
    public boolean getBoolean() {
        return this.value.toString().toLowerCase().equals("true");
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz) {
        if (clazz == this.enumClass) {
            return (E)this.value;
        }
        return (E)((Enum[])clazz.getEnumConstants())[0];
    }

    @Override
    public DataValue.DataType getType() {
        return DataValue.DataType.ENUM;
    }

    public T[] getPossibleValues() {
        return (Enum[])this.enumClass.getEnumConstants();
    }

    @Override
    public NBTBase writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("clazz", this.enumClass.getName());
        tag.func_74768_a("ordinal", this.value.ordinal());
        return tag;
    }

    @Override
    public void readFromNBT(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        try {
            this.enumClass = Class.forName(tag.func_74779_i("clazz"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.value = ((Enum[])this.enumClass.getEnumConstants())[tag.func_74762_e("ordinal")];
    }
}

