/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.controls.Button;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlRegistry {
    private static Map<String, Control> registry = new HashMap<String, Control>();
    private static Map<Class<? extends Control>, String> classToName = new HashMap<Class<? extends Control>, String>();

    private ControlRegistry() {
    }

    public static void init() {
        registry.put("button", new Button("Button", null));
        for (Map.Entry<String, Control> e : registry.entrySet()) {
            classToName.put(e.getValue().getClass(), e.getKey());
        }
    }

    public static List<Control> getAllControls() {
        ArrayList<Control> l = new ArrayList<Control>(registry.size());
        for (Control c : registry.values()) {
            l.add(c);
        }
        return l;
    }

    public static Control getNew(String name, ControlPanel panel) {
        return registry.get(name).newControl(panel);
    }

    public static String getName(Class<? extends Control> clazz) {
        return classToName.get(clazz);
    }
}

