/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.IControllable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="hbm")
public class ControlEventSystem {
    private static Map<World, ControlEventSystem> systems = new HashMap<World, ControlEventSystem>();
    private Set<IControllable> allControllables = new HashSet<IControllable>();
    private Set<IControllable> tickables = new HashSet<IControllable>();
    private Map<String, Map<BlockPos, IControllable>> controllablesByEventName = new HashMap<String, Map<BlockPos, IControllable>>();
    private Map<BlockPos, Set<IControllable>> positionSubscriptions = new HashMap<BlockPos, Set<IControllable>>();

    public void addControllable(IControllable c) {
        if (this.allControllables.contains(c)) {
            return;
        }
        for (String s : c.getInEvents()) {
            if (s.equals("tick")) {
                this.tickables.add(c);
                continue;
            }
            if (!this.controllablesByEventName.containsKey(s)) {
                this.controllablesByEventName.put(s, new HashMap());
            }
            this.controllablesByEventName.get(s).put(c.getControlPos(), c);
        }
        this.allControllables.add(c);
    }

    public void removeControllable(IControllable c) {
        for (String s : c.getInEvents()) {
            if (s.equals("tick")) {
                this.tickables.remove(c);
                continue;
            }
            this.controllablesByEventName.get(s).remove(c);
        }
        this.allControllables.remove(c);
    }

    public boolean isValid(IControllable c) {
        return this.allControllables.contains(c);
    }

    public void subscribeTo(IControllable subscriber, IControllable target) {
        if (!this.positionSubscriptions.containsKey(target.getControlPos())) {
            this.positionSubscriptions.put(target.getControlPos(), new HashSet());
        }
        if (!this.positionSubscriptions.get(target).contains(subscriber)) {
            this.positionSubscriptions.get(target.getControlPos()).add(subscriber);
        }
    }

    public void subscribeTo(IControllable subscriber, BlockPos target) {
        if (!this.positionSubscriptions.containsKey(target)) {
            this.positionSubscriptions.put(target, new HashSet());
        }
        if (!this.positionSubscriptions.get(target).contains(subscriber)) {
            this.positionSubscriptions.get(target).add(subscriber);
        }
    }

    public void unsubscribeFrom(IControllable subscriber, IControllable target) {
        if (this.positionSubscriptions.containsKey(target.getControlPos())) {
            this.positionSubscriptions.get(target.getControlPos()).remove(subscriber);
            if (this.positionSubscriptions.get(target.getControlPos()).isEmpty()) {
                this.positionSubscriptions.remove(target.getControlPos());
            }
        }
    }

    public void unsubscribeFrom(IControllable subscriber, BlockPos target) {
        if (this.positionSubscriptions.containsKey(target)) {
            this.positionSubscriptions.get(target).remove(subscriber);
            if (this.positionSubscriptions.get(target).isEmpty()) {
                this.positionSubscriptions.remove(target);
            }
        }
    }

    public void broadcastEvent(BlockPos from, ControlEvent evt, BlockPos pos) {
        Map<BlockPos, IControllable> map = this.controllablesByEventName.get(evt.name);
        if (map == null) {
            return;
        }
        IControllable c = map.get(pos);
        if (c != null) {
            c.receiveEvent(from, evt);
        }
    }

    public void broadcastEvent(BlockPos from, ControlEvent evt, Collection<BlockPos> positions) {
        Map<BlockPos, IControllable> map = this.controllablesByEventName.get(evt.name);
        if (map == null) {
            return;
        }
        if (positions == null) {
            for (IControllable c : map.values()) {
                c.receiveEvent(from, evt);
            }
        } else {
            for (BlockPos pos : positions) {
                IControllable c = map.get(pos);
                if (c == null) continue;
                c.receiveEvent(from, evt);
            }
        }
    }

    public void broadcastEvent(BlockPos from, ControlEvent c) {
        this.broadcastEvent(from, c, (Collection<BlockPos>)null);
    }

    public void broadcastToSubscribed(IControllable ctrl, ControlEvent evt) {
        Set<IControllable> subscribed = this.positionSubscriptions.get(ctrl.getControlPos());
        if (subscribed == null) {
            return;
        }
        for (IControllable sub : subscribed) {
            sub.receiveEvent(ctrl.getControlPos(), evt);
        }
    }

    public static ControlEventSystem get(World w) {
        if (!systems.containsKey(w)) {
            systems.put(w, new ControlEventSystem());
        }
        return systems.get(w);
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent evt) {
        if (systems.containsKey(evt.world)) {
            ControlEventSystem s = systems.get(evt.world);
            for (IControllable c : s.tickables) {
                c.receiveEvent(c.getControlPos(), ControlEvent.newEvent("tick").setVar("time", evt.world.func_72820_D()));
            }
        }
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload evt) {
        systems.remove(evt.getWorld());
    }
}

