/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.ControlRegistry;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.render.amlfrom1710.IModelCustom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Control {
    public String name;
    public ControlPanel panel;
    public List<BlockPos> connectedSet = new ArrayList<BlockPos>();
    public Map<String, NodeSystem> sendNodeMap = new HashMap<String, NodeSystem>();
    public Map<String, NodeSystem> receiveNodeMap = new HashMap<String, NodeSystem>();
    public Map<String, DataValue> vars = new HashMap<String, DataValue>();
    public Map<String, DataValue> varsPrev = new HashMap<String, DataValue>();
    public Set<String> customVarNames = new HashSet<String>();
    public float posX;
    public float posY;

    public Control(String name, ControlPanel panel) {
        this.name = name;
        this.panel = panel;
    }

    public void renderBatched() {
    }

    public void render() {
    }

    public List<String> getOutEvents() {
        return Collections.emptyList();
    }

    public List<String> getInEvents() {
        return Arrays.asList("tick", "initialize");
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IModelCustom getModel();

    @SideOnly(value=Side.CLIENT)
    public abstract ResourceLocation getGuiTexture();

    public abstract AxisAlignedBB getBoundingBox();

    public abstract float[] getBox();

    public abstract Control newControl(ControlPanel var1);

    public void receiveEvent(ControlEvent evt) {
        NodeSystem sys = this.receiveNodeMap.get(evt.name);
        if (sys != null) {
            sys.resetCachedValues();
            sys.receiveEvent(this.panel, this, evt);
        }
    }

    public DataValue getVar(String name) {
        return this.vars.getOrDefault(name, new DataValueFloat(0.0f));
    }

    public DataValue getGlobalVar(String name) {
        return this.panel.getVar(name);
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        void var6_14;
        tag.func_74778_a("name", ControlRegistry.getName(this.getClass()));
        tag.func_74778_a("myName", this.name);
        NBTTagCompound vars = new NBTTagCompound();
        for (Map.Entry<String, DataValue> entry : this.vars.entrySet()) {
            vars.func_74782_a(entry.getKey(), entry.getValue().writeToNBT());
        }
        tag.func_74782_a("vars", (NBTBase)vars);
        NBTTagCompound sendNodes = new NBTTagCompound();
        for (Map.Entry<String, NodeSystem> entry : this.sendNodeMap.entrySet()) {
            sendNodes.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("sendNodes", (NBTBase)sendNodes);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (Map.Entry<String, NodeSystem> entry : this.receiveNodeMap.entrySet()) {
            nBTTagCompound.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("receiveNodes", (NBTBase)nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        boolean bl = false;
        for (String s : this.customVarNames) {
            void var6_12;
            nBTTagCompound2.func_74778_a("var" + (int)var6_12, s);
            ++var6_12;
        }
        tag.func_74782_a("customvarnames", (NBTBase)nBTTagCompound2);
        NBTTagCompound connectedSet = new NBTTagCompound();
        boolean bl2 = false;
        while (var6_14 < this.connectedSet.size()) {
            connectedSet.func_74768_a("px" + (int)var6_14, this.connectedSet.get((int)var6_14).func_177958_n());
            connectedSet.func_74768_a("py" + (int)var6_14, this.connectedSet.get((int)var6_14).func_177956_o());
            connectedSet.func_74768_a("pz" + (int)var6_14, this.connectedSet.get((int)var6_14).func_177952_p());
            ++var6_14;
        }
        tag.func_74782_a("connectedset", (NBTBase)connectedSet);
        tag.func_74776_a("posX", this.posX);
        tag.func_74776_a("posY", this.posY);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound vars = tag.func_74775_l("vars");
        for (Object k : vars.func_150296_c()) {
            NBTBase base = vars.func_74781_a((String)k);
            DataValue val = DataValue.newFromNBT(base);
            if (val == null) continue;
            this.vars.put((String)k, val);
        }
        this.sendNodeMap.clear();
        this.receiveNodeMap.clear();
        NBTTagCompound sendNodes = tag.func_74775_l("sendNodes");
        for (Object s : sendNodes.func_150296_c()) {
            NodeSystem sys = new NodeSystem(this);
            this.sendNodeMap.put((String)s, sys);
            sys.readFromNBT(sendNodes.func_74775_l((String)s));
        }
        NBTTagCompound receiveNodes = tag.func_74775_l("receiveNodes");
        for (String s : receiveNodes.func_150296_c()) {
            NodeSystem sys = new NodeSystem(this);
            this.receiveNodeMap.put(s, sys);
            sys.readFromNBT(receiveNodes.func_74775_l(s));
        }
        NBTTagCompound customVarNames = tag.func_74775_l("customvarnames");
        for (int i = 0; i < customVarNames.func_150296_c().size(); ++i) {
            this.customVarNames.add(customVarNames.func_74779_i("var" + i));
        }
        NBTTagCompound connectedSet = tag.func_74775_l("connectedset");
        for (int i = 0; i < connectedSet.func_150296_c().size() / 3; ++i) {
            int x = connectedSet.func_74762_e("px" + i);
            int y = connectedSet.func_74762_e("py" + i);
            int z = connectedSet.func_74762_e("pz" + i);
            this.connectedSet.add(new BlockPos(x, y, z));
        }
        this.posX = tag.func_74760_g("posX");
        this.posY = tag.func_74760_g("posY");
    }
}

