/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PressRecipes {
    public static HashMap<Tuple.Pair<PressType, RecipesCommon.AStack>, ItemStack> pressRecipes = new HashMap();
    public static List<Item> stamps_flat = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_flat);
            this.add(ModItems.stamp_iron_flat);
            this.add(ModItems.stamp_steel_flat);
            this.add(ModItems.stamp_titanium_flat);
            this.add(ModItems.stamp_obsidian_flat);
            this.add(ModItems.stamp_schrabidium_flat);
            this.add(ModItems.stamp_desh_flat);
        }
    };
    public static List<Item> stamps_plate = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_plate);
            this.add(ModItems.stamp_iron_plate);
            this.add(ModItems.stamp_steel_plate);
            this.add(ModItems.stamp_titanium_plate);
            this.add(ModItems.stamp_obsidian_plate);
            this.add(ModItems.stamp_schrabidium_plate);
            this.add(ModItems.stamp_desh_plate);
        }
    };
    public static List<Item> stamps_wire = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_wire);
            this.add(ModItems.stamp_iron_wire);
            this.add(ModItems.stamp_steel_wire);
            this.add(ModItems.stamp_titanium_wire);
            this.add(ModItems.stamp_obsidian_wire);
            this.add(ModItems.stamp_schrabidium_wire);
            this.add(ModItems.stamp_desh_wire);
        }
    };
    public static List<Item> stamps_circuit = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_circuit);
            this.add(ModItems.stamp_iron_circuit);
            this.add(ModItems.stamp_steel_circuit);
            this.add(ModItems.stamp_titanium_circuit);
            this.add(ModItems.stamp_obsidian_circuit);
            this.add(ModItems.stamp_schrabidium_circuit);
            this.add(ModItems.stamp_desh_circuit);
        }
    };
    public static List<Item> stamps_357 = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_357);
            this.add(ModItems.stamp_desh_357);
        }
    };
    public static List<Item> stamps_44 = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_44);
            this.add(ModItems.stamp_desh_44);
        }
    };
    public static List<Item> stamps_9 = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_9);
            this.add(ModItems.stamp_desh_9);
        }
    };
    public static List<Item> stamps_50 = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_50);
            this.add(ModItems.stamp_desh_50);
        }
    };

    public static void addRecipe(PressType stamp, RecipesCommon.AStack input, ItemStack output) {
        if (!input.getStackList().isEmpty()) {
            pressRecipes.put(new Tuple.Pair<PressType, RecipesCommon.AStack>(stamp, input), output);
        }
    }

    public static void registerOverrides() {
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), new ItemStack(Items.field_151044_h));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack("dustQuartz"), new ItemStack(Items.field_151128_bU));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust()), new ItemStack(Items.field_151128_bU));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust()), new ItemStack(Items.field_151100_aR, 1, 4));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust()), new ItemStack(Items.field_151045_i));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust()), new ItemStack(Items.field_151166_bC));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.ComparableStack(ModItems.pellet_coal), new ItemStack(Items.field_151045_i));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.ComparableStack(ModItems.biomass), new ItemStack(ModItems.biomass_compressed));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.ComparableStack(ModItems.powder_lignite), new ItemStack(ModItems.briquette_lignite));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.ComparableStack(ModItems.meteorite_sword_reforged), new ItemStack(ModItems.meteorite_sword_hardened));
        PressRecipes.addRecipe(PressType.FLAT, new RecipesCommon.OreDictStack("fuelCoke"), new ItemStack(ModItems.ingot_graphite));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new ItemStack(ModItems.plate_iron));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new ItemStack(ModItems.plate_gold));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.TI.ingot()), new ItemStack(ModItems.plate_titanium));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new ItemStack(ModItems.plate_aluminium));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), new ItemStack(ModItems.plate_steel));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.PB.ingot()), new ItemStack(ModItems.plate_lead));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new ItemStack(ModItems.plate_copper));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack("ingotAdvanced"), new ItemStack(ModItems.plate_advanced_alloy));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new ItemStack(ModItems.plate_advanced_alloy));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new ItemStack(ModItems.plate_schrabidium));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot()), new ItemStack(ModItems.plate_combine_steel));
        PressRecipes.addRecipe(PressType.PLATE, new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot()), new ItemStack(ModItems.plate_saturnite));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new ItemStack(ModItems.wire_aluminium, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new ItemStack(ModItems.wire_copper, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.W.ingot()), new ItemStack(ModItems.wire_tungsten, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot()), new ItemStack(ModItems.wire_red_copper, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new ItemStack(ModItems.wire_gold, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new ItemStack(ModItems.wire_schrabidium, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack("ingotAdvanced"), new ItemStack(ModItems.wire_advanced_alloy, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new ItemStack(ModItems.wire_advanced_alloy, 8));
        PressRecipes.addRecipe(PressType.WIRE, new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.ingot()), new ItemStack(ModItems.wire_magnetized_tungsten, 8));
        PressRecipes.addRecipe(PressType.CIRCUIT, new RecipesCommon.ComparableStack(ModItems.circuit_raw), new ItemStack(ModItems.circuit_aluminium));
        PressRecipes.addRecipe(PressType.CIRCUIT, new RecipesCommon.ComparableStack(ModItems.circuit_bismuth_raw), new ItemStack(ModItems.circuit_bismuth));
        PressRecipes.addRecipe(PressType.CIRCUIT, new RecipesCommon.ComparableStack(ModItems.circuit_arsenic_raw), new ItemStack(ModItems.circuit_arsenic));
        PressRecipes.addRecipe(PressType.CIRCUIT, new RecipesCommon.ComparableStack(ModItems.circuit_tantalium_raw), new ItemStack(ModItems.circuit_tantalium));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_iron), new ItemStack(ModItems.gun_revolver_iron_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_steel), new ItemStack(ModItems.gun_revolver_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_lead), new ItemStack(ModItems.gun_revolver_lead_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_gold), new ItemStack(ModItems.gun_revolver_gold_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_schrabidium), new ItemStack(ModItems.gun_revolver_schrabidium_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_nightmare), new ItemStack(ModItems.gun_revolver_nightmare_ammo));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.ComparableStack(ModItems.assembly_desh), new ItemStack(ModItems.ammo_357_desh));
        PressRecipes.addRecipe(PressType.THREEFIFESEVEN, new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), new ItemStack(ModItems.gun_revolver_cursed_ammo));
        PressRecipes.addRecipe(PressType.FOURFOUR, new RecipesCommon.ComparableStack(ModItems.assembly_nopip), new ItemStack(ModItems.ammo_44));
        PressRecipes.addRecipe(PressType.NINE, new RecipesCommon.ComparableStack(ModItems.assembly_smg), new ItemStack(ModItems.ammo_9mm));
        PressRecipes.addRecipe(PressType.NINE, new RecipesCommon.ComparableStack(ModItems.assembly_uzi), new ItemStack(ModItems.ammo_22lr));
        PressRecipes.addRecipe(PressType.NINE, new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new ItemStack(ModItems.ammo_566_gold));
        PressRecipes.addRecipe(PressType.NINE, new RecipesCommon.ComparableStack(ModItems.assembly_lacunae), new ItemStack(ModItems.ammo_5mm));
        PressRecipes.addRecipe(PressType.NINE, new RecipesCommon.ComparableStack(ModItems.assembly_556), new ItemStack(ModItems.ammo_556));
        PressRecipes.addRecipe(PressType.FIVEZERO, new RecipesCommon.ComparableStack(ModItems.assembly_calamity), new ItemStack(ModItems.ammo_50bmg));
        PressRecipes.addRecipe(PressType.FIVEZERO, new RecipesCommon.ComparableStack(ModItems.assembly_actionexpress), new ItemStack(ModItems.ammo_50ae));
    }

    public static PressType getStampType(Item stamp) {
        if (stamps_flat.contains(stamp)) {
            return PressType.FLAT;
        }
        if (stamps_plate.contains(stamp)) {
            return PressType.PLATE;
        }
        if (stamps_wire.contains(stamp)) {
            return PressType.WIRE;
        }
        if (stamps_circuit.contains(stamp)) {
            return PressType.CIRCUIT;
        }
        if (stamps_357.contains(stamp)) {
            return PressType.THREEFIFESEVEN;
        }
        if (stamps_44.contains(stamp)) {
            return PressType.FOURFOUR;
        }
        if (stamps_9.contains(stamp)) {
            return PressType.NINE;
        }
        if (stamps_50.contains(stamp)) {
            return PressType.FIVEZERO;
        }
        return PressType.NONE;
    }

    public static List<ItemStack> toStack(List<Item> iList) {
        ArrayList<ItemStack> i_stamps = new ArrayList<ItemStack>();
        for (Item i : iList) {
            i_stamps.add(new ItemStack(i));
        }
        return i_stamps;
    }

    public static List<ItemStack> getStampList(PressType pType) {
        if (pType == PressType.FLAT) {
            return PressRecipes.toStack(stamps_flat);
        }
        if (pType == PressType.PLATE) {
            return PressRecipes.toStack(stamps_plate);
        }
        if (pType == PressType.WIRE) {
            return PressRecipes.toStack(stamps_wire);
        }
        if (pType == PressType.CIRCUIT) {
            return PressRecipes.toStack(stamps_circuit);
        }
        if (pType == PressType.THREEFIFESEVEN) {
            return PressRecipes.toStack(stamps_357);
        }
        if (pType == PressType.FOURFOUR) {
            return PressRecipes.toStack(stamps_44);
        }
        if (pType == PressType.NINE) {
            return PressRecipes.toStack(stamps_9);
        }
        if (pType == PressType.FIVEZERO) {
            return PressRecipes.toStack(stamps_50);
        }
        return new ArrayList<ItemStack>();
    }

    public static ItemStack getPressResult(ItemStack input, ItemStack stamp) {
        if (input == null || stamp == null) {
            return null;
        }
        PressType pType = PressRecipes.getStampType(stamp.func_77973_b());
        if (pType == PressType.NONE) {
            return null;
        }
        return PressRecipes.getPressOutput(pType, input);
    }

    public static ItemStack getPressOutput(PressType pType, ItemStack input) {
        int[] ids;
        ItemStack outputItem = pressRecipes.get(new Tuple.Pair<PressType, RecipesCommon.ComparableStack>(pType, new RecipesCommon.ComparableStack(input.func_77973_b(), 1, input.func_77952_i())));
        if (outputItem != null) {
            return outputItem;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(input.func_77973_b(), 1, input.func_77952_i()))) {
            RecipesCommon.OreDictStack oreStack = new RecipesCommon.OreDictStack(OreDictionary.getOreName((int)id));
            outputItem = pressRecipes.get(new Tuple.Pair<PressType, RecipesCommon.OreDictStack>(pType, oreStack));
            if (outputItem == null) continue;
            return outputItem;
        }
        return null;
    }

    public static enum PressType {
        NONE,
        FLAT,
        PLATE,
        WIRE,
        CIRCUIT,
        THREEFIFESEVEN,
        FOURFOUR,
        NINE,
        FIVEZERO;

    }
}

