/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DFCRecipes {
    public static HashMap<RecipesCommon.ComparableStack, Object[]> dfcRecipes = new HashMap();
    public static List<DFCRecipe> jeiDFCRecipes = null;

    public static void register() {
        DFCRecipes.setRecipe(100000L, ModItems.marshmallow, new ItemStack(ModItems.marshmallow_roasted));
        DFCRecipes.setRecipe(2000000L, OreDictManager.REDSTONE.dust(), new ItemStack(ModItems.nugget_mercury));
        DFCRecipes.setRecipe(2000000L, OreDictManager.REDSTONE.block(), new ItemStack(ModItems.bottle_mercury));
        DFCRecipes.setRecipe(10000000L, OreDictManager.W.dust(), new ItemStack(ModItems.powder_magnetized_tungsten));
        DFCRecipes.setRecipe(10000000L, OreDictManager.W.ingot(), new ItemStack(ModItems.ingot_magnetized_tungsten));
        DFCRecipes.setRecipe(60000000L, OreDictManager.MAGTUNG.dust(), new ItemStack(ModItems.powder_chlorophyte));
        DFCRecipes.setRecipe(60000000L, OreDictManager.MAGTUNG.ingot(), new ItemStack(ModItems.powder_chlorophyte));
        DFCRecipes.setRecipe(200000000L, ModItems.powder_chlorophyte, new ItemStack(ModItems.powder_balefire));
        DFCRecipes.setRecipe(600000000L, ModItems.powder_balefire, new ItemStack(ModItems.egg_balefire_shard));
        DFCRecipes.setRecipe(800000000L, ModItems.billet_thorium_fuel, new ItemStack(ModItems.billet_zfb_bismuth));
        DFCRecipes.setRecipe(1200000000L, Items.field_151055_y, new ItemStack(Blocks.field_150364_r));
        DFCRecipes.setRecipe(1200000000L, Blocks.field_150348_b, new ItemStack(Blocks.field_150366_p));
        DFCRecipes.setRecipe(1200000000L, Blocks.field_150351_n, new ItemStack(Blocks.field_150365_q));
        DFCRecipes.setRecipe(1200000000L, Blocks.field_150424_aL, new ItemStack(Blocks.field_150449_bY));
        DFCRecipes.setRecipe(1500000000L, ModItems.nugget_unobtainium_lesser, new ItemStack(ModItems.nugget_unobtainium_greater));
        DFCRecipes.setRecipe(2000000000L, OreDictManager.U.nugget(), new ItemStack(ModItems.nugget_schrabidium));
        DFCRecipes.setRecipe(2000000000L, OreDictManager.U.ingot(), new ItemStack(ModItems.ingot_schrabidium));
        DFCRecipes.setRecipe(2000000000L, OreDictManager.U.dust(), new ItemStack(ModItems.powder_schrabidium));
        DFCRecipes.setRecipe(2500000000L, ModItems.powder_nitan_mix, new ItemStack(ModItems.powder_spark_mix));
        DFCRecipes.setRecipe(5000000000L, ModItems.particle_hydrogen, new ItemStack(ModItems.particle_amat));
        DFCRecipes.setRecipe(20000000000L, OreDictManager.PU.nugget(), new ItemStack(ModItems.nugget_euphemium));
        DFCRecipes.setRecipe(20000000000L, OreDictManager.PU.ingot(), new ItemStack(ModItems.ingot_euphemium));
        DFCRecipes.setRecipe(20000000000L, OreDictManager.PU.dust(), new ItemStack(ModItems.powder_euphemium));
        DFCRecipes.setRecipe(30000000000L, ModItems.particle_amat, new ItemStack(ModItems.particle_aschrab));
        DFCRecipes.setRecipe(40000000000L, OreDictManager.VERTICIUM.nugget(), new ItemStack(ModItems.nugget_radspice));
        DFCRecipes.setRecipe(40000000000L, OreDictManager.VERTICIUM.ingot(), new ItemStack(ModItems.ingot_radspice));
        DFCRecipes.setRecipe(40000000000L, OreDictManager.VERTICIUM.dust(), new ItemStack(ModItems.powder_radspice));
        DFCRecipes.setRecipe(50000000000L, ModItems.billet_polonium, new ItemStack(ModItems.billet_yharonite));
        DFCRecipes.setRecipe(100000000000L, ModItems.meteorite_sword_warped, new ItemStack(ModItems.meteorite_sword_demonic));
        DFCRecipes.setRecipe(200000000000L, OreDictManager.SBD.dust(), new ItemStack(ModItems.powder_dineutronium));
        DFCRecipes.setRecipe(200000000000L, OreDictManager.SBD.ingot(), new ItemStack(ModItems.ingot_dineutronium));
        DFCRecipes.setRecipe(400000000000L, OreDictManager.U238.ingot(), new ItemStack(ModItems.ingot_u238m2));
        DFCRecipes.setRecipe(420000000000L, OreDictManager.U238.nugget(), new ItemStack(ModItems.nugget_u238m2));
        DFCRecipes.setRecipe(690000000000L, ModItems.gun_uboinik, new ItemStack(ModItems.gun_supershotgun));
        DFCRecipes.setRecipe(1000000000000L, ModItems.undefined, new ItemStack(ModItems.glitch));
        DFCRecipes.setRecipe(10000000000000L, ModItems.rod_of_discord, new ItemStack(ModItems.wand));
        DFCRecipes.setRecipe(12000000000000L, ModItems.battery_spark_cell_power, new ItemStack(ModItems.battery_creative));
        DFCRecipes.setRecipe(69000000000000L, Items.field_151099_bA, new ItemStack(ModItems.book_of_));
    }

    public static void setRecipe(long requiredFlux, ItemStack in, ItemStack out) {
        dfcRecipes.put(new RecipesCommon.ComparableStack(in), new Object[]{requiredFlux, out});
    }

    public static void setRecipe(long requiredFlux, Item in, ItemStack out) {
        dfcRecipes.put(new RecipesCommon.ComparableStack(in), new Object[]{requiredFlux, out});
    }

    public static void setRecipe(long requiredFlux, Block in, ItemStack out) {
        dfcRecipes.put(new RecipesCommon.ComparableStack(in), new Object[]{requiredFlux, out});
    }

    public static void setRecipe(long requiredFlux, String in, ItemStack out) {
        dfcRecipes.put(new RecipesCommon.ComparableStack((ItemStack)OreDictionary.getOres((String)in).get(0)), new Object[]{requiredFlux, out});
    }

    public static void removeRecipe(ItemStack in) {
        dfcRecipes.remove(new RecipesCommon.ComparableStack(in));
    }

    public static long getRequiredFlux(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_190926_b()) {
            return -1L;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        if (dfcRecipes.containsKey(comp)) {
            return (Long)dfcRecipes.get(comp)[0];
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!dfcRecipes.containsKey(key)) continue;
            return (Long)dfcRecipes.get(key)[1];
        }
        return -1L;
    }

    public static ItemStack getOutput(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        if (dfcRecipes.containsKey(comp)) {
            return (ItemStack)dfcRecipes.get(comp)[1];
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!dfcRecipes.containsKey(key)) continue;
            return (ItemStack)dfcRecipes.get(key)[1];
        }
        return null;
    }

    public static List<DFCRecipe> getDFCRecipes() {
        if (jeiDFCRecipes == null) {
            jeiDFCRecipes = new ArrayList<DFCRecipe>();
            for (Map.Entry<RecipesCommon.ComparableStack, Object[]> e : dfcRecipes.entrySet()) {
                jeiDFCRecipes.add(new DFCRecipe(e.getKey().toStack(), (Long)e.getValue()[0], (ItemStack)e.getValue()[1]));
            }
        }
        return jeiDFCRecipes;
    }

    public static class DFCRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final long requiredFlux;
        private final ItemStack output;

        public DFCRecipe(ItemStack input, long requiredFlux, ItemStack output) {
            this.input = input;
            this.requiredFlux = requiredFlux;
            this.output = output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            fontRenderer.func_78276_b("Spark", 8, 8, 0x404040);
            String number = Library.getShortNumber(this.requiredFlux);
            fontRenderer.func_78276_b(number, 80 - fontRenderer.func_78256_a(number), 8, 11020814);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

