/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.Spaghetti;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemChemistryTemplate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Spaghetti(value="everything")
public class ChemplantRecipes {
    public static HashMap<EnumChemistryTemplate, RecipesCommon.AStack[]> recipeItemInputs = new HashMap();
    public static HashMap<EnumChemistryTemplate, FluidStack[]> recipeFluidInputs = new HashMap();
    public static HashMap<EnumChemistryTemplate, RecipesCommon.AStack[]> recipeItemOutputs = new HashMap();
    public static HashMap<EnumChemistryTemplate, FluidStack[]> recipeFluidOutputs = new HashMap();
    public static HashMap<EnumChemistryTemplate, Integer> recipeDurations = new HashMap();

    public static void registerRecipes() {
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FP_HEAVYOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.heavyoil, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.bitumen, 300), new FluidStack(ModForgeFluids.smear, 700)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FP_SMEAR, null, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 600), new FluidStack(ModForgeFluids.lubricant, 400)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FP_NAPHTHA, null, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 400), new FluidStack(ModForgeFluids.diesel, 600)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FP_LIGHTOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.lightoil, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.diesel, 400), new FluidStack(ModForgeFluids.kerosene, 600)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FR_REOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.reclaimed, 800)}, 30);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FR_PETROIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.reclaimed, 800), new FluidStack(ModForgeFluids.lubricant, 200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.petroil, 1000)}, 30);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FC_BITUMEN, null, new FluidStack[]{new FluidStack(ModForgeFluids.bitumen, 1200), new FluidStack(ModForgeFluids.steam, 2400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.oil, 1000), new FluidStack(ModForgeFluids.petroleum, 200)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FC_I_NAPHTHA, null, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 1400), new FluidStack(FluidRegistry.WATER, 800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 800)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FC_GAS_PETROLEUM, null, new FluidStack[]{new FluidStack(ModForgeFluids.gas, 1800), new FluidStack(FluidRegistry.WATER, 1200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 800)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FC_DIESEL_KEROSENE, null, new FluidStack[]{new FluidStack(ModForgeFluids.diesel, 1200), new FluidStack(ModForgeFluids.steam, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.kerosene, 400)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FC_KEROSENE_PETROLEUM, null, new FluidStack[]{new FluidStack(ModForgeFluids.kerosene, 1400), new FluidStack(ModForgeFluids.steam, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 800)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CC_OIL, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.oil, 600), new FluidStack(ModForgeFluids.steam, 1400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.oil, 2000)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CC_I, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 6), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 800), new FluidStack(FluidRegistry.WATER, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 1600)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CC_HEATING, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 6), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 800), new FluidStack(ModForgeFluids.steam, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 1800)}, 250);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CC_HEAVY, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.heavyoil, 600), new FluidStack(FluidRegistry.WATER, 1400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.heavyoil, 1800)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CC_NAPHTHA, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 8), new RecipesCommon.ComparableStack(ModItems.oil_tar, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 1200), new FluidStack(ModForgeFluids.steam, 2400)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 2000)}, 300);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_OIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.oil, 350)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_HEAVYOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.heavyoil, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.oil_tar, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_SMEAR, null, new FluidStack[]{new FluidStack(ModForgeFluids.smear, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.oil_tar, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_HEATINGOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 100)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_RECLAIMED, null, new FluidStack[]{new FluidStack(ModForgeFluids.reclaimed, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_PETROIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.petroil, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_LUBRICANT, null, new FluidStack[]{new FluidStack(ModForgeFluids.lubricant, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_NAPHTHA, null, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 300)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_DIESEL, null, new FluidStack[]{new FluidStack(ModForgeFluids.diesel, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_LIGHTOIL, null, new FluidStack[]{new FluidStack(ModForgeFluids.lightoil, 450)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_KEROSENE, null, new FluidStack[]{new FluidStack(ModForgeFluids.kerosene, 550)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_GAS, null, new FluidStack[]{new FluidStack(ModForgeFluids.gas, 750)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_PETROLEUM, null, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 600)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_BIOGAS, null, new FluidStack[]{new FluidStack(ModForgeFluids.biogas, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SF_BIOFUEL, null, new FluidStack[]{new FluidStack(ModForgeFluids.biofuel, 300)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)}, null, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.BP_BIOGAS, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 16)}, null, null, new FluidStack[]{new FluidStack(ModForgeFluids.biogas, 4000)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.BP_BIOFUEL, null, new FluidStack[]{new FluidStack(ModForgeFluids.biogas, 1500), new FluidStack(ModForgeFluids.ethanol, 250)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.biofuel, 1000)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.OIL_SAND, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ore_oil_sand, 16), new RecipesCommon.OreDictStack("oiltar", 1)}, null, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack((Block)Blocks.field_150354_m, 16)}, new FluidStack[]{new FluidStack(ModForgeFluids.bitumen, 1000)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.ASPHALT, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 2), new RecipesCommon.OreDictStack("sand", 6)}, new FluidStack[]{new FluidStack(ModForgeFluids.bitumen, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.asphalt, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.GNEISS_GAS, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ore_gneiss_gas, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.superhotsteam, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.stone_gneiss, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.gas, 1000), new FluidStack(ModForgeFluids.spentsteam, 1000)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.COOLANT, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.coolant, 2000)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CRYOGEL, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_ice, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.coolant, 1800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.cryogel, 2000)}, 50);
        if (GeneralConfig.enableBabyMode) {
            ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DESH, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_desh_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.lightoil, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_desh, 1)}, null, 300);
        } else {
            ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DESH, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_desh_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.mercury, 200), new FluidStack(ModForgeFluids.lightoil, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_desh, 1)}, null, 300);
        }
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.NITAN, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.kerosene, 600), new FluidStack(ModForgeFluids.mercury, 200)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.nitan, 1000)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.PEROXIDE, null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 800)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SULFURIC_ACID, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 800)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.sulfuric_acid, 500)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.NITRIC_ACID, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.sulfuric_acid, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.nitric_acid, 500)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SOLVENT, null, new FluidStack[]{new FluidStack(ModForgeFluids.naphtha, 800), new FluidStack(ModForgeFluids.aromatics, 300)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.solvent, 1000)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.RADIOSOLVENT, null, new FluidStack[]{new FluidStack(ModForgeFluids.solvent, 500), new FluidStack(ModForgeFluids.watz, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.radiosolvent, 1000)}, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CIRCUIT_4, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit_red_copper, 1), new RecipesCommon.ComparableStack(ModItems.wire_gold, 4), new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit_gold, 1)}, null, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CIRCUIT_5, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit_gold, 1), new RecipesCommon.ComparableStack(ModItems.wire_schrabidium, 4), new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 800), new FluidStack(ModForgeFluids.petroleum, 400)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit_schrabidium, 1)}, null, 250);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.POLYMER, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 2), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 600)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_polymer, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.BAKELITE, null, new FluidStack[]{new FluidStack(ModForgeFluids.aromatics, 500), new FluidStack(ModForgeFluids.petroleum, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_bakelite, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.RUBBER, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.unsaturateds, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_rubber, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYNAMITE, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Items.field_151102_aT), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust()), new RecipesCommon.OreDictStack("sand")}, new FluidStack[]{new FluidStack(ModForgeFluids.sulfuric_acid, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_dynamite, 2)}, null, 50);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.TNT, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.aromatics, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ball_tnt, 4)}, null, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.C4, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.unsaturateds, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_c4, 4)}, null, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.HEAVY_ELECTROLYSIS, null, new FluidStack[]{new FluidStack(ModForgeFluids.heavywater, 8000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.deuterium, 400), new FluidStack(ModForgeFluids.oxygen, 400)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DEUTERIUM, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 4000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.deuterium, 500)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.STEAM, null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.steam, 1000)}, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.ALGE, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 4), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.COAL.dustTiny(), 2)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.biomass, 36)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, 1200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.YELLOWCAKE, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.U.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_yellowcake, 1)}, null, 250);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.UF6, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_yellowcake, 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.uf6, 1000)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.PUF6, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PU.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.puf6, 1000)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SAS3, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.SA326.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 2000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.sas3, 1000)}, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYN_SCHRAB, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_higgs, 1), new RecipesCommon.OreDictStack(OreDictManager.U.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.coolant, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_schrabidium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.watz, 50)}, 600);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYN_STR, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_strange, 1), new RecipesCommon.ComparableStack(ModItems.nugget_radspice, 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.cryogel, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.egg_balefire, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.watz, 200)}, 1200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYN_EUPH, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_dark, 1), new RecipesCommon.OreDictStack(OreDictManager.SA327.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 16)}, new FluidStack[]{new FluidStack(ModForgeFluids.cryogel, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_euphemium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.watz, 100)}, 2400);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYN_DNT, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_sparkticle, 1), new RecipesCommon.OreDictStack(OreDictManager.SBD.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 32)}, new FluidStack[]{new FluidStack(ModForgeFluids.cryogel, 4000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_dineutronium, 8)}, new FluidStack[]{new FluidStack(ModForgeFluids.watz, 400)}, 6000);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DYN_EL, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_digamma, 1), new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.catalyst_clay, 64)}, new FluidStack[]{new FluidStack(ModForgeFluids.cryogel, 8000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.particle_empty, 1), new RecipesCommon.ComparableStack(ModItems.ingot_electronium, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.watz, 800)}, 12000);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CORDITE, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.OreDictStack("plankWood", 1), new RecipesCommon.ComparableStack(Items.field_151102_aT, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.heatingoil, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.cordite, 4)}, null, 40);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.KEVLAR, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.OreDictStack("ingotBrick", 1), new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 100)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_kevlar, 4)}, null, 40);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CONCRETE, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 8), new RecipesCommon.OreDictStack("sand", 8)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.CONCRETE_ASBESTOS, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("gravel", 2), new RecipesCommon.OreDictStack("sand", 2), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 4)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_asbestos, 16)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.DUCRETE, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("sand", 8), new RecipesCommon.OreDictStack(OreDictManager.U238.billet(), 2), new RecipesCommon.ComparableStack(Items.field_151119_aD, 4)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 2000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.ducrete, 8)}, null, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SOLID_FUEL, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 200)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rocket_fuel, 4)}, null, 200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.ELECTROLYSIS, null, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 8000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.hydrogen, 800), new FluidStack(ModForgeFluids.oxygen, 800)}, 150);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.XENON, null, null, null, new FluidStack[]{new FluidStack(ModForgeFluids.xenon, 50)}, 300);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.XENON_OXY, null, new FluidStack[]{new FluidStack(ModForgeFluids.oxygen, 250)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.xenon, 50)}, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SATURN, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DURA.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.P_RED.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 100), new FluidStack(ModForgeFluids.mercury, 50)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_saturnite, 2)}, null, 60);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.BALEFIRE, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.kerosene, 6000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_balefire, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.balefire, 8000)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SCHRABIDIC, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.pellet_charged, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.sas3, 8000), new FluidStack(ModForgeFluids.acid, 6000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.schrabidic, 16000)}, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.SCHRABIDATE, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.schrabidic, 250)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_schrabidate, 1)}, null, 600);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.COLTAN_CLEANING, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.COLTAN.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.acid, 250), new FluidStack(ModForgeFluids.hydrogen, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_coltan, 1), new RecipesCommon.ComparableStack(ModItems.powder_niobium, 1), new RecipesCommon.ComparableStack(ModItems.dust, 1)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 500)}, 60);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.COLTAN_PAIN, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_coltan, 1), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.gas, 1000), new FluidStack(ModForgeFluids.oxygen, 500)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.pain, 1000)}, 120);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.COLTAN_CRYSTAL, null, new FluidStack[]{new FluidStack(ModForgeFluids.pain, 1000), new FluidStack(ModForgeFluids.acid, 500)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.gem_tantalium, 1), new RecipesCommon.ComparableStack(ModItems.dust, 3)}, new FluidStack[]{new FluidStack(FluidRegistry.WATER, 250)}, 80);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.ARSENIC, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.scrap_oil, 64), new RecipesCommon.ComparableStack(ModItems.scrap_oil, 64), new RecipesCommon.ComparableStack(ModItems.scrap_oil, 64), new RecipesCommon.ComparableStack(ModItems.scrap_oil, 64)}, new FluidStack[]{new FluidStack(ModForgeFluids.sulfuric_acid, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nugget_arsenic, 1), new RecipesCommon.ComparableStack(ModItems.sulfur, 2)}, new FluidStack[]{new FluidStack(ModForgeFluids.heavyoil, 1500)}, 1200);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.VIT_LIQUID, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.sand_lead, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.wastefluid, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nuclear_waste_vitrified, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.VIT_GAS, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.sand_lead, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.wastegas, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nuclear_waste_vitrified, 1)}, null, 100);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.TEL, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("oiltar", 1), new RecipesCommon.OreDictStack(OreDictManager.PB.dust(), 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 100), new FluidStack(ModForgeFluids.steam, 1000)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, null, 40);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.GASOLINE, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.antiknock, 1)}, new FluidStack[]{new FluidStack(ModForgeFluids.petroil, 10000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.gasoline, 12000)}, 40);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.FRACKSOL, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust())}, new FluidStack[]{new FluidStack(ModForgeFluids.petroleum, 100), new FluidStack(FluidRegistry.WATER, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.fracksol, 1000)}, 20);
        ChemplantRecipes.makeRecipe(EnumChemistryTemplate.OSMIRIDIUM_DEATH, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_paleogenite), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 8), new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 4)}, new FluidStack[]{new FluidStack(ModForgeFluids.sulfuric_acid, 1000), new FluidStack(ModForgeFluids.sas3, 1000)}, null, new FluidStack[]{new FluidStack(ModForgeFluids.liquid_osmiridium, 1000)}, 240);
    }

    public static void makeRecipe(EnumChemistryTemplate name, RecipesCommon.AStack[] itemInputs, FluidStack[] fluidInputs, RecipesCommon.AStack[] outputItems, FluidStack[] outputFluids, int duration) {
        if (itemInputs != null) {
            recipeItemInputs.put(name, itemInputs);
        }
        if (fluidInputs != null) {
            recipeFluidInputs.put(name, fluidInputs);
        }
        if (outputItems != null) {
            recipeItemOutputs.put(name, outputItems);
        }
        if (outputFluids != null) {
            recipeFluidOutputs.put(name, outputFluids);
        }
        if (duration > 1) {
            recipeDurations.put(name, duration);
        }
    }

    public static List<RecipesCommon.AStack> getChemInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        EnumChemistryTemplate recipeName = EnumChemistryTemplate.getEnum(stack.func_77952_i());
        RecipesCommon.AStack[] inputs = recipeItemInputs.get((Object)recipeName);
        if (inputs != null) {
            return Arrays.asList(inputs);
        }
        return null;
    }

    public static FluidStack[] getFluidInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        EnumChemistryTemplate recipeName = EnumChemistryTemplate.getEnum(stack.func_77952_i());
        return recipeFluidInputs.get((Object)recipeName);
    }

    public static ItemStack[] getChemOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        EnumChemistryTemplate recipeName = EnumChemistryTemplate.getEnum(stack.func_77952_i());
        RecipesCommon.AStack[] outputs = recipeItemOutputs.get((Object)recipeName);
        if (outputs != null) {
            ItemStack[] stackOutputs = new ItemStack[outputs.length];
            for (int i = 0; i < stackOutputs.length; ++i) {
                stackOutputs[i] = outputs[i].getStack();
            }
            return stackOutputs;
        }
        return null;
    }

    public static FluidStack[] getFluidOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        EnumChemistryTemplate recipeName = EnumChemistryTemplate.getEnum(stack.func_77952_i());
        return recipeFluidOutputs.get((Object)recipeName);
    }

    public static int getProcessTime(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return 100;
        }
        EnumChemistryTemplate recipeName = EnumChemistryTemplate.getEnum(stack.func_77952_i());
        Integer time = recipeDurations.get((Object)recipeName);
        if (time != null) {
            return time;
        }
        return 100;
    }

    public static enum EnumChemistryTemplate {
        FP_HEAVYOIL,
        FP_SMEAR,
        FP_NAPHTHA,
        FP_LIGHTOIL,
        FR_REOIL,
        FR_PETROIL,
        FC_BITUMEN,
        FC_I_NAPHTHA,
        FC_GAS_PETROLEUM,
        FC_DIESEL_KEROSENE,
        FC_KEROSENE_PETROLEUM,
        CC_OIL,
        CC_I,
        CC_HEATING,
        CC_HEAVY,
        CC_NAPHTHA,
        SF_OIL,
        SF_HEAVYOIL,
        SF_SMEAR,
        SF_HEATINGOIL,
        SF_RECLAIMED,
        SF_PETROIL,
        SF_LUBRICANT,
        SF_NAPHTHA,
        SF_DIESEL,
        SF_LIGHTOIL,
        SF_KEROSENE,
        SF_GAS,
        SF_PETROLEUM,
        SF_BIOGAS,
        SF_BIOFUEL,
        BP_BIOGAS,
        BP_BIOFUEL,
        GNEISS_GAS,
        OIL_SAND,
        ASPHALT,
        COOLANT,
        CRYOGEL,
        DESH,
        NITAN,
        PEROXIDE,
        SULFURIC_ACID,
        NITRIC_ACID,
        SOLVENT,
        RADIOSOLVENT,
        CIRCUIT_4,
        CIRCUIT_5,
        POLYMER,
        BAKELITE,
        RUBBER,
        DYNAMITE,
        TNT,
        C4,
        ELECTROLYSIS,
        HEAVY_ELECTROLYSIS,
        DEUTERIUM,
        STEAM,
        ALGE,
        YELLOWCAKE,
        UF6,
        PUF6,
        SAS3,
        DYN_SCHRAB,
        DYN_STR,
        DYN_EUPH,
        DYN_DNT,
        DYN_EL,
        CORDITE,
        KEVLAR,
        CONCRETE,
        CONCRETE_ASBESTOS,
        DUCRETE,
        SOLID_FUEL,
        XENON,
        XENON_OXY,
        SATURN,
        BALEFIRE,
        SCHRABIDIC,
        SCHRABIDATE,
        COLTAN_CLEANING,
        COLTAN_PAIN,
        COLTAN_CRYSTAL,
        ARSENIC,
        VIT_LIQUID,
        VIT_GAS,
        TEL,
        GASOLINE,
        FRACKSOL,
        OSMIRIDIUM_DEATH;


        public static EnumChemistryTemplate getEnum(int i) {
            if (i < EnumChemistryTemplate.values().length) {
                return EnumChemistryTemplate.values()[i];
            }
            return FP_HEAVYOIL;
        }

        public String getName() {
            return this.toString();
        }
    }
}

