/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBedrockOre;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class CentrifugeRecipes {
    private static HashMap<Object, ItemStack[]> recipes = new HashMap();
    private static List<CentrifugeRecipe> centrifugeRecipes = null;

    public static void register() {
        recipes.put(new RecipesCommon.ComparableStack(ModItems.waste_uranium), new ItemStack[]{new ItemStack(ModItems.nugget_pu_mix, 2), new ItemStack(ModItems.nugget_plutonium, 1), new ItemStack(ModItems.nugget_technetium, 1), new ItemStack(ModItems.nuclear_waste_tiny, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.waste_plutonium), new ItemStack[]{new ItemStack(ModItems.nugget_pu_mix, 1), new ItemStack(ModItems.nugget_pu_mix, 1), new ItemStack(ModItems.nugget_technetium, 1), new ItemStack(ModItems.nuclear_waste_tiny, 3)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.waste_mox), new ItemStack[]{new ItemStack(ModItems.nugget_pu_mix, 1), new ItemStack(ModItems.nugget_technetium, 1), new ItemStack(ModItems.nugget_u238, 1), new ItemStack(ModItems.nuclear_waste_tiny, 3)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.waste_schrabidium), new ItemStack[]{new ItemStack(ModItems.nugget_beryllium, 2), new ItemStack(ModItems.nugget_lead, 1), new ItemStack(ModItems.nugget_solinium, 1), new ItemStack(ModItems.nuclear_waste_tiny, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.waste_thorium), new ItemStack[]{new ItemStack(ModItems.nugget_u238, 1), new ItemStack(ModItems.nugget_th232, 1), new ItemStack(ModItems.nugget_u233, 2), new ItemStack(ModItems.nuclear_waste_tiny, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.powder_cloud), new ItemStack[]{new ItemStack(ModItems.powder_copper, 1), new ItemStack(ModItems.sulfur, 1), new ItemStack(ModItems.dust, 1), new ItemStack(ModItems.dust, 1)});
        recipes.put(OreDictManager.COAL.ore(), new ItemStack[]{new ItemStack(ModItems.powder_coal, 2), new ItemStack(ModItems.powder_coal, 2), new ItemStack(ModItems.powder_coal, 2), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.LIGNITE.ore(), new ItemStack[]{new ItemStack(ModItems.powder_lignite, 2), new ItemStack(ModItems.powder_lignite, 2), new ItemStack(ModItems.powder_lignite, 2), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.IRON.ore(), new ItemStack[]{new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.GOLD.ore(), new ItemStack[]{new ItemStack(ModItems.powder_gold, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.DIAMOND.ore(), new ItemStack[]{new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.EMERALD.ore(), new ItemStack[]{new ItemStack(ModItems.powder_emerald, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.TI.ore(), new ItemStack[]{new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put("oreQuartz", new ItemStack[]{new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_lithium_tiny, 1), new ItemStack(Blocks.field_150424_aL, 1)});
        recipes.put(OreDictManager.W.ore(), new ItemStack[]{new ItemStack(ModItems.powder_tungsten, 1), new ItemStack(ModItems.powder_tungsten, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.CU.ore(), new ItemStack[]{new ItemStack(ModItems.powder_copper, 1), new ItemStack(ModItems.powder_copper, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.AL.ore(), new ItemStack[]{new ItemStack(ModItems.powder_aluminium, 1), new ItemStack(ModItems.powder_aluminium, 1), new ItemStack(ModItems.powder_iron, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.PB.ore(), new ItemStack[]{new ItemStack(ModItems.powder_lead, 1), new ItemStack(ModItems.powder_lead, 1), new ItemStack(ModItems.powder_gold, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.ASBESTOS.ore(), new ItemStack[]{new ItemStack(ModItems.powder_asbestos, 1), new ItemStack(ModItems.powder_asbestos, 1), new ItemStack(ModItems.powder_boron_tiny, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.SA326.ore(), new ItemStack[]{new ItemStack(ModItems.powder_schrabidium, 1), new ItemStack(ModItems.powder_schrabidium, 1), new ItemStack(ModItems.nugget_solinium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.RAREEARTH.ore(), new ItemStack[]{new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.nugget_zirconium, 1), new ItemStack(ModItems.nugget_zirconium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.CINNABAR.ore(), new ItemStack[]{new ItemStack(ModItems.cinnebar, 2), new ItemStack(ModItems.cinnebar, 2), new ItemStack(Items.field_151137_ax, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.PU.ore(), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.nugget_polonium, 3), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.U.ore(), new ItemStack[]{new ItemStack(ModItems.powder_uranium, 1), new ItemStack(ModItems.powder_uranium, 1), new ItemStack(ModItems.nugget_ra226, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.TH232.ore(), new ItemStack[]{new ItemStack(ModItems.powder_thorium, 1), new ItemStack(ModItems.powder_thorium, 1), new ItemStack(ModItems.powder_uranium, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.BE.ore(), new ItemStack[]{new ItemStack(ModItems.powder_beryllium, 1), new ItemStack(ModItems.powder_beryllium, 1), new ItemStack(ModItems.powder_emerald, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.REDSTONE.ore(), new ItemStack[]{new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), new ItemStack(ModItems.nugget_mercury, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.ore_tikite), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_nitan_mix, 1), new ItemStack(Blocks.field_150377_bs, 1)});
        recipes.put(OreDictManager.LAPIS.ore(), new ItemStack[]{new ItemStack(ModItems.powder_lapis, 3), new ItemStack(ModItems.powder_lapis, 3), new ItemStack(ModItems.powder_cobalt_tiny, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.STAR.ore(), new ItemStack[]{new ItemStack(ModItems.powder_dura_steel, 3), new ItemStack(ModItems.powder_astatine, 1), new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.powder_tektite), new ItemStack[]{new ItemStack(ModItems.powder_paleogenite_tiny, 1), new ItemStack(ModItems.powder_meteorite_tiny, 1), new ItemStack(ModItems.powder_meteorite_tiny, 1), new ItemStack(ModItems.dust, 6)});
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.block_euphemium_cluster), new ItemStack[]{new ItemStack(ModItems.nugget_euphemium, 7), new ItemStack(ModItems.powder_schrabidium, 4), new ItemStack(ModItems.ingot_starmetal, 2), new ItemStack(ModItems.nugget_solinium, 2)});
        recipes.put(OreDictManager.P_RED.ore(), new ItemStack[]{new ItemStack(Items.field_151065_br, 2), new ItemStack(ModItems.powder_fire, 2), new ItemStack(ModItems.ingot_phosphorus), new ItemStack(Blocks.field_150424_aL)});
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151072_bj), new ItemStack[]{new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151065_br, 1), new ItemStack(ModItems.powder_fire, 1), new ItemStack(ModItems.powder_fire, 1)});
        recipes.put(OreDictManager.SRN.ingot(), new ItemStack[]{new ItemStack(ModItems.nugget_schrabidium, 2), new ItemStack(ModItems.nugget_schrabidium, 1), new ItemStack(ModItems.nugget_uranium, 3), new ItemStack(ModItems.nugget_plutonium, 2)});
        recipes.put(OreDictManager.COAL.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_coal, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.IRON.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_iron, 2), new ItemStack(ModItems.powder_titanium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.GOLD.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_gold, 2), new ItemStack(ModItems.powder_gold, 2), new ItemStack(ModItems.nugget_mercury, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.REDSTONE.crystal(), new ItemStack[]{new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), new ItemStack(Items.field_151137_ax, 3), new ItemStack(ModItems.nugget_mercury, 3)});
        recipes.put(OreDictManager.LAPIS.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_lapis, 8), new ItemStack(ModItems.powder_lapis, 8), new ItemStack(ModItems.powder_cobalt, 1), new ItemStack(Blocks.field_150351_n, 1)});
        recipes.put(OreDictManager.DIAMOND.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1), new ItemStack(ModItems.powder_diamond, 1)});
        recipes.put(OreDictManager.U.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_uranium, 2), new ItemStack(ModItems.powder_uranium, 2), new ItemStack(ModItems.nugget_ra226, 2), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.TH232.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_thorium, 2), new ItemStack(ModItems.powder_thorium, 2), new ItemStack(ModItems.powder_uranium, 1), new ItemStack(ModItems.nugget_ra226, 1)});
        recipes.put(OreDictManager.PU.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_plutonium, 2), new ItemStack(ModItems.powder_polonium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.TI.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_titanium, 2), new ItemStack(ModItems.powder_titanium, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.S.crystal(), new ItemStack[]{new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.nugget_mercury, 1)});
        recipes.put(OreDictManager.KNO.crystal(), new ItemStack[]{new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.niter, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.CU.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_copper, 2), new ItemStack(ModItems.powder_copper, 2), new ItemStack(ModItems.sulfur, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.W.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_tungsten, 2), new ItemStack(ModItems.powder_tungsten, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.AL.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_aluminium, 2), new ItemStack(ModItems.powder_aluminium, 2), new ItemStack(ModItems.powder_iron, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.F.crystal(), new ItemStack[]{new ItemStack(ModItems.fluorite, 3), new ItemStack(ModItems.fluorite, 3), new ItemStack(ModItems.fluorite, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.BE.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_beryllium, 2), new ItemStack(ModItems.powder_beryllium, 2), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.PB.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_lead, 2), new ItemStack(ModItems.powder_lead, 2), new ItemStack(ModItems.powder_gold, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.SRN.crystal(), new ItemStack[]{new ItemStack(ModItems.nugget_schrabidium, 2), new ItemStack(ModItems.nugget_schrabidium, 2), new ItemStack(ModItems.nugget_uranium, 2), new ItemStack(ModItems.nugget_plutonium, 2)});
        recipes.put(OreDictManager.SA326.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_schrabidium, 2), new ItemStack(ModItems.powder_schrabidium, 2), new ItemStack(ModItems.powder_plutonium, 1), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.RAREEARTH.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.powder_desh_mix, 1), new ItemStack(ModItems.nugget_zirconium, 2), new ItemStack(ModItems.nugget_zirconium, 2)});
        recipes.put(OreDictManager.CINNABAR.crystal(), new ItemStack[]{new ItemStack(ModItems.cinnebar, 3), new ItemStack(ModItems.cinnebar, 3), new ItemStack(Items.field_151137_ax, 2), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.P_RED.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_fire, 3), new ItemStack(ModItems.powder_fire, 3), new ItemStack(ModItems.ingot_phosphorus, 2), new ItemStack(Items.field_151065_br, 2)});
        recipes.put(new RecipesCommon.ComparableStack(ModItems.crystal_trixite), new ItemStack[]{new ItemStack(ModItems.powder_plutonium, 3), new ItemStack(ModItems.powder_cobalt, 3), new ItemStack(ModItems.powder_spark_mix, 1), new ItemStack(ModItems.powder_nitan_mix, 2)});
        recipes.put(OreDictManager.LI.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_lithium, 2), new ItemStack(ModItems.powder_lithium, 2), new ItemStack(ModItems.powder_quartz, 1), new ItemStack(ModItems.fluorite, 1)});
        recipes.put(OreDictManager.STAR.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_dura_steel, 3), new ItemStack(ModItems.powder_cobalt, 3), new ItemStack(ModItems.powder_astatine, 2), new ItemStack(ModItems.nugget_mercury, 5)});
        recipes.put(OreDictManager.CO.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_cobalt, 2), new ItemStack(ModItems.powder_iron, 3), new ItemStack(ModItems.powder_copper, 3), new ItemStack(ModItems.powder_lithium_tiny, 1)});
        recipes.put(OreDictManager.ASBESTOS.crystal(), new ItemStack[]{new ItemStack(ModItems.powder_asbestos, 2), new ItemStack(ModItems.powder_asbestos, 2), new ItemStack(ModItems.powder_boron_tiny, 1), new ItemStack(Blocks.field_150351_n, 1)});
        for (Map.Entry<Integer, String> entry : BedrockOreRegistry.oreIndexes.entrySet()) {
            int oreMeta = entry.getKey();
            String oreName = entry.getValue();
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_centrifuged, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_centrifuged, 1, oreMeta), new ItemStack(Blocks.field_150351_n, 1), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_cleaned, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_separated, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_separated, 1, oreMeta), new ItemStack(Blocks.field_150351_n, 1), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_deepcleaned, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_purified, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_purified, 1, oreMeta), new ItemStack(Blocks.field_150351_n, 1), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_nitrated, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_nitrocrystalline, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_nitrocrystalline, 1, oreMeta), CentrifugeRecipes.getNugget(oreName), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_seared, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_exquisite, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_exquisite, 1, oreMeta), CentrifugeRecipes.getNugget(oreName), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_perfect, 1, oreMeta), new ItemStack[]{new ItemStack(ModItems.ore_bedrock_enriched, 1, oreMeta), new ItemStack(ModItems.ore_bedrock_enriched, 1, oreMeta), new ItemStack(Blocks.field_150351_n, 1), new ItemStack(Blocks.field_150351_n, 1)});
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ore_bedrock_enriched, 1, oreMeta), new ItemStack[]{ItemBedrockOre.getOut(oreMeta, 1), ItemBedrockOre.getOut(oreMeta, 1), ItemBedrockOre.getOut(oreMeta, 1), ItemBedrockOre.getOut(oreMeta, 1)});
        }
    }

    public static ItemStack getNugget(String oreName) {
        if (oreName.equals("oreLead") || oreName.equals("oreCopper")) {
            return new ItemStack(ModItems.nugget_cadmium, 1);
        }
        if (oreName.equals("oreGold") || oreName.equals("oreTungsten")) {
            return new ItemStack(ModItems.nugget_bismuth, 1);
        }
        if (oreName.equals("oreUranium")) {
            return new ItemStack(ModItems.nugget_ra226, 1);
        }
        if (oreName.equals("oreThorium")) {
            return new ItemStack(ModItems.nugget_technetium, 1);
        }
        if (oreName.equals("oreStarmetal")) {
            return new ItemStack(ModItems.powder_meteorite_tiny, 1);
        }
        if (oreName.equals("oreRedstone")) {
            return new ItemStack(ModItems.nugget_mercury, 1);
        }
        if (oreName.equals("oreRedPhosphorus")) {
            return new ItemStack(ModItems.nugget_arsenic, 1);
        }
        if (oreName.equals("oreNeodymium")) {
            return new ItemStack(ModItems.nugget_tantalium, 1);
        }
        return new ItemStack(Blocks.field_150351_n, 1);
    }

    public static void addRecipe(ItemStack in, ItemStack[] outputs) {
        recipes.put(new RecipesCommon.ComparableStack(in), outputs);
    }

    public static void removeRecipe(ItemStack in) {
        recipes.remove(new RecipesCommon.ComparableStack(in));
    }

    public static ItemStack[] getOutput(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77952_i());
        if (recipes.containsKey(comp)) {
            return RecipesCommon.copyStackArray(recipes.get(comp));
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!recipes.containsKey(key)) continue;
            return RecipesCommon.copyStackArray(recipes.get(key));
        }
        return null;
    }

    public static List<CentrifugeRecipe> getCentrifugeRecipes() {
        if (centrifugeRecipes != null) {
            return centrifugeRecipes;
        }
        centrifugeRecipes = new ArrayList<CentrifugeRecipe>();
        for (Map.Entry<Object, ItemStack[]> entry : recipes.entrySet()) {
            if (entry.getKey() instanceof String) {
                NonNullList ingredients = OreDictionary.getOres((String)((String)entry.getKey()));
                centrifugeRecipes.add(new CentrifugeRecipe((List<ItemStack>)ingredients, Arrays.asList((Object[])entry.getValue())));
                continue;
            }
            centrifugeRecipes.add(new CentrifugeRecipe(((RecipesCommon.ComparableStack)entry.getKey()).toStack(), Arrays.asList((Object[])entry.getValue())));
        }
        return centrifugeRecipes;
    }

    public static class CentrifugeRecipe
    implements IRecipeWrapper {
        private final ItemStack input;
        private final List<ItemStack> outputs;
        public final List<ItemStack> inputs;

        public CentrifugeRecipe(ItemStack input, List<ItemStack> outputs) {
            this.input = input;
            this.inputs = null;
            this.outputs = outputs;
        }

        public CentrifugeRecipe(List<ItemStack> inputs, List<ItemStack> outputs) {
            this.inputs = inputs;
            this.input = ItemStack.field_190927_a;
            this.outputs = outputs;
        }

        public void getIngredients(IIngredients ingredients) {
            if (this.inputs != null) {
                ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(this.inputs));
            } else {
                ingredients.setInput(VanillaTypes.ITEM, (Object)this.input);
            }
            ingredients.setOutputs(VanillaTypes.ITEM, this.outputs);
        }
    }
}

