/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.config.BedrockOreJsonConfig;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.Spaghetti;
import com.hbm.lib.Library;
import com.hbm.util.WeightedRandomObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@Spaghetti(value="everything")
public class BedrockOreRegistry {
    public static HashMap<Integer, String> oreIndexes = new HashMap();
    public static HashMap<String, Integer> oreToIndexes = new HashMap();
    public static HashMap<String, String> oreResults = new HashMap();
    public static HashMap<String, Integer> oreColors = new HashMap();
    public static HashMap<String, String> oreNames = new HashMap();
    public static HashMap<String, Integer> oreTiers = new HashMap();
    public static HashMap<Integer, List<WeightedRandomObject>> oreCasino = new HashMap();
    public static HashMap<String, Integer> oreScanColors = new HashMap();

    public static void registerBedrockOres() {
        BedrockOreRegistry.collectBedrockOres();
        BedrockOreRegistry.fillOreCasino();
    }

    public static void collectBedrockOres() {
        int index = 0;
        for (String oreName : OreDictionary.getOreNames()) {
            if (!oreName.startsWith("ore")) continue;
            String resourceName = oreName.substring(3);
            String oreGem = "gem" + resourceName;
            if (OreDictionary.doesOreNameExist((String)oreGem)) {
                oreIndexes.put(index, oreName);
                oreToIndexes.put(oreName, index);
                ++index;
                oreResults.put(oreName, oreGem);
                oreTiers.put(oreName, Math.max(1, 1 + BedrockOreRegistry.getDirectOreTier(oreName)));
                continue;
            }
            String oreDust = "dust" + resourceName;
            if (OreDictionary.doesOreNameExist((String)oreDust)) {
                oreIndexes.put(index, oreName);
                oreToIndexes.put(oreName, index);
                ++index;
                oreResults.put(oreName, oreDust);
                oreTiers.put(oreName, Math.max(1, 1 + BedrockOreRegistry.getDirectOreTier(oreName)));
                continue;
            }
            String oreIngot = "ingot" + resourceName;
            if (!OreDictionary.doesOreNameExist((String)oreIngot)) continue;
            oreIndexes.put(index, oreName);
            oreToIndexes.put(oreName, index);
            ++index;
            oreResults.put(oreName, oreIngot);
            oreTiers.put(oreName, Math.max(1, 1 + BedrockOreRegistry.getDirectOreTier(oreName)));
        }
    }

    public static int getOreIndex(String ore) {
        Integer x = oreToIndexes.get(ore);
        if (x == null) {
            return -1;
        }
        return x;
    }

    public static int getOreTier(String ore) {
        Integer x = oreTiers.get(ore);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public static FluidStack getFluidRequirement(int tier) {
        if (tier == 1) {
            return new FluidStack(ModForgeFluids.acid, 8000);
        }
        if (tier == 2) {
            return new FluidStack(ModForgeFluids.sulfuric_acid, 500);
        }
        if (tier == 3) {
            return new FluidStack(ModForgeFluids.nitric_acid, 500);
        }
        if (tier == 4) {
            return new FluidStack(ModForgeFluids.radiosolvent, 200);
        }
        if (tier == 5) {
            return new FluidStack(ModForgeFluids.schrabidic, 200);
        }
        if (tier == 6) {
            return new FluidStack(ModForgeFluids.uu_matter, 200);
        }
        if (tier > 6) {
            return new FluidStack(ModForgeFluids.liquid_osmiridium, 100);
        }
        return new FluidStack(ModForgeFluids.solvent, 300);
    }

    public static int getTierWeight(int tier) {
        if (tier == 1) {
            return 64;
        }
        if (tier == 2) {
            return 48;
        }
        if (tier == 3) {
            return 32;
        }
        if (tier == 4) {
            return 8;
        }
        if (tier == 5) {
            return 2;
        }
        if (tier == 6) {
            return 1;
        }
        return 1;
    }

    public static void fillOreCasino() {
        for (Integer dimID : BedrockOreJsonConfig.dimOres.keySet()) {
            ArrayList<WeightedRandomObject> oreWeights = new ArrayList<WeightedRandomObject>();
            for (String oreName : oreResults.keySet()) {
                if (!BedrockOreJsonConfig.isOreAllowed(dimID, oreName)) continue;
                oreWeights.add(new WeightedRandomObject(oreName, BedrockOreRegistry.getTierWeight(BedrockOreRegistry.getOreTier(oreName))));
            }
            oreCasino.put(dimID, oreWeights);
        }
    }

    public static String rollOreName(int dimID, Random rand) {
        if (oreCasino.get(dimID).isEmpty()) {
            return null;
        }
        return ((WeightedRandomObject)WeightedRandom.func_76271_a((Random)rand, oreCasino.get(dimID))).asString();
    }

    public static int getDirectOreTier(String oreName) {
        int tierCount = 0;
        int tierSum = 0;
        NonNullList outputs = OreDictionary.getOres((String)oreName);
        Block ore = null;
        for (ItemStack stack : outputs) {
            ore = Block.func_149634_a((Item)stack.func_77973_b());
            int tier = ore.getHarvestLevel(ore.func_176223_P());
            if (tier <= -1) continue;
            tierSum += tier;
            ++tierCount;
        }
        if (tierCount > 0) {
            return tierSum / tierCount;
        }
        return 0;
    }

    public static String getOreName(String oreName) {
        return oreName.substring(3).replaceAll("([A-Z])", " $1").trim();
    }

    public static void registerOreColors() {
        for (Map.Entry<String, String> entry : oreResults.entrySet()) {
            NonNullList oreResult = OreDictionary.getOres((String)entry.getValue());
            if (oreResult.size() <= 0) continue;
            int color = Library.getColorFromItemStack((ItemStack)oreResult.get(0));
            oreColors.put(entry.getKey(), color);
        }
        BedrockOreRegistry.registerScannerOreColors();
    }

    public static void registerScannerOreColors() {
        for (String entry : OreDictionary.getOreNames()) {
            NonNullList oreResult;
            if (!entry.startsWith("ore") || (oreResult = OreDictionary.getOres((String)entry)).size() <= 0) continue;
            int color = Library.getColorFromItemStack((ItemStack)oreResult.get(0));
            oreScanColors.put(entry, color);
        }
    }

    public static int getOreScanColor(String ore) {
        Integer x = oreScanColors.get(ore);
        if (x == null) {
            return 0;
        }
        return x;
    }

    public static ItemStack getResource(String ore) {
        NonNullList outputs = OreDictionary.getOres((String)oreResults.get(ore));
        if (outputs.size() > 0) {
            return (ItemStack)outputs.get(0);
        }
        return new ItemStack(Items.field_190931_a);
    }

    public static int getOreColor(String ore) {
        Integer x = oreColors.get(ore);
        if (x == null) {
            return 0xFFFFFF;
        }
        return x;
    }
}

