/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.config.GeneralConfig;
import com.hbm.hazard.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HazardTypeRadiation
extends HazardTypeBase {
    @Override
    public void onUpdate(EntityLivingBase target, float level, ItemStack stack) {
        boolean reacher = false;
        if (target instanceof EntityPlayer && !GeneralConfig.enable528) {
            reacher = Library.checkForHeld((EntityPlayer)target, ModItems.reacher);
        }
        if (level > 0.0f) {
            float rad = level / 20.0f;
            if (reacher) {
                rad = (float)Math.min(Math.sqrt(rad), (double)rad);
            }
            ContaminationUtil.contaminate(target, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad);
        }
    }

    @Override
    public void updateEntity(EntityItem item, float level) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHazardInformation(EntityPlayer player, List<String> list, float level, ItemStack stack, List<HazardModifier> modifiers) {
        level = HazardModifier.evalAllModifiers(stack, (EntityLivingBase)player, level, modifiers);
        list.add(TextFormatting.GREEN + "[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]");
        String rad = "" + Math.floor(level * 1000.0f) / 1000.0;
        list.add(TextFormatting.YELLOW + rad + " RAD/s");
        if (stack.func_190916_E() > 1) {
            list.add(TextFormatting.YELLOW + "Stack: " + Math.floor(level * 1000.0f * (float)stack.func_190916_E()) / 1000.0 + " RAD/s");
        }
    }
}

