/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.particle.EntityBSmokeFX;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.ArmorUtil;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.BobMathUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BulletConfigFactory {
    public static BulletConfiguration getTestConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.gun_revolver_ammo;
        bullet.velocity = 5.0f;
        bullet.spread = 0.05f;
        bullet.wear = 10;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 17.0f;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 90;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = true;
        bullet.style = 0;
        bullet.plink = 1;
        return bullet;
    }

    public static BulletConfiguration standardBulletConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 5.0;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = true;
        bullet.destroysBlocks = false;
        bullet.style = 0;
        bullet.plink = 1;
        bullet.leadChance = 5;
        return bullet;
    }

    public static BulletConfiguration standardShellConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 3.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.005;
        bullet.maxAge = 300;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 100;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.style = 9;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardNukeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 3.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 1000.0f;
        bullet.dmgMax = 1000.0f;
        bullet.gravity = 0.025;
        bullet.maxAge = 300;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = 7;
        bullet.plink = 2;
        return bullet;
    }

    public static BulletConfiguration standardBuckshotConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.05f;
        bullet.wear = 10;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 8;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 15.0;
        bullet.HBRC = 5;
        bullet.LBRC = 65;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = true;
        bullet.style = 2;
        bullet.plink = 1;
        bullet.leadChance = 10;
        return bullet;
    }

    public static BulletConfiguration standardRocketConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.005;
        bullet.maxAge = 300;
        bullet.doesRicochet = true;
        bullet.ricochetAngle = 10.0;
        bullet.HBRC = 2;
        bullet.LBRC = 100;
        bullet.bounceMod = 0.8;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 5.0f;
        bullet.style = 5;
        bullet.plink = 2;
        return bullet;
    }

    public static BulletConfiguration standardGrenadeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 2.0f;
        bullet.spread = 0.005f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.035;
        bullet.maxAge = 300;
        bullet.doesRicochet = false;
        bullet.ricochetAngle = 0.0;
        bullet.HBRC = 0;
        bullet.LBRC = 0;
        bullet.bounceMod = 1.0;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.explosive = 2.5f;
        bullet.style = 9;
        bullet.plink = 2;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration standardAirstrikeConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.wear = 50;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = false;
        bullet.doesBreakGlass = false;
        bullet.style = 3;
        bullet.leadChance = 0;
        bullet.vPFX = "reddust";
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                Random rand = bullet.field_70170_p.field_73012_v;
                int count = rand.nextInt(11) + 95;
                for (int i = 0; i < count; ++i) {
                    double dx = bullet.field_70165_t + rand.nextGaussian() * 4.0;
                    double dy = bullet.field_70163_u + 25.0 + rand.nextGaussian() * 5.0;
                    double dz = bullet.field_70161_v + rand.nextGaussian() * 4.0;
                    Vec3 motion = Vec3.createVectorHelper(bullet.field_70165_t - dx, bullet.field_70163_u - dy, bullet.field_70161_v - dz);
                    motion = motion.normalize();
                    EntityBulletBase bolt = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.R556_FLECHETTE_DU);
                    bolt.func_70107_b(dx, dy, dz);
                    bolt.func_70186_c(motion.xCoord, motion.yCoord, motion.zCoord, 0.5f, 0.1f);
                    bullet.field_70170_p.func_72838_d((Entity)bolt);
                    if (i >= 30) continue;
                    EntityBSmokeFX bsmoke = new EntityBSmokeFX(bullet.field_70170_p);
                    bsmoke.func_70107_b(dx, dy, dz);
                    bullet.field_70170_p.func_72838_d((Entity)bsmoke);
                }
            }
        };
        return bullet;
    }

    public static IBulletImpactBehavior getPhosphorousEffect(final int radius, final int duration, final int count, final double motion, final float hazeChance) {
        IBulletImpactBehavior impact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                List hit = bullet.field_70170_p.func_72839_b((Entity)bullet, new AxisAlignedBB(bullet.field_70165_t - (double)radius, bullet.field_70163_u - (double)radius, bullet.field_70161_v - (double)radius, bullet.field_70165_t + (double)radius, bullet.field_70163_u + (double)radius, bullet.field_70161_v + (double)radius));
                for (Entity e : hit) {
                    if (Library.isObstructed(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
                    e.func_70015_d(5);
                    if (!(e instanceof EntityLivingBase)) continue;
                    PotionEffect eff = new PotionEffect((Potion)HbmPotion.phosphorus, duration, 0, true, false);
                    eff.getCurativeItems().clear();
                    ((EntityLivingBase)e).func_70690_d(eff);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", count);
                data.func_74780_a("motion", motion);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
                if (bullet.field_70170_p.field_73012_v.nextFloat() < hazeChance) {
                    NBTTagCompound haze = new NBTTagCompound();
                    haze.func_74778_a("type", "haze");
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(haze, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 150.0));
                }
            }
        };
        return impact;
    }

    public static IBulletImpactBehavior getGasEffect(final int radius, final int duration) {
        IBulletImpactBehavior impact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                List hit = bullet.field_70170_p.func_72839_b((Entity)bullet, new AxisAlignedBB(bullet.field_70165_t - (double)radius, bullet.field_70163_u - (double)radius, bullet.field_70161_v - (double)radius, bullet.field_70165_t + (double)radius, bullet.field_70163_u + (double)radius, bullet.field_70161_v + (double)radius));
                for (Entity e : hit) {
                    if (Library.isObstructed(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v) || !(e instanceof EntityLivingBase)) continue;
                    EntityLivingBase entityLiving = (EntityLivingBase)e;
                    if (ArmorRegistry.hasAllProtection(entityLiving, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.GAS_CHLORINE)) {
                        ArmorUtil.damageGasMaskFilter(entityLiving, 1);
                        continue;
                    }
                    PotionEffect eff0 = new PotionEffect(MobEffects.field_76436_u, duration, 2, true, false);
                    PotionEffect eff1 = new PotionEffect(MobEffects.field_76419_f, duration, 2, true, false);
                    PotionEffect eff2 = new PotionEffect(MobEffects.field_76437_t, duration, 4, true, false);
                    PotionEffect eff3 = new PotionEffect(MobEffects.field_82731_v, (int)Math.ceil((double)duration * 0.1), 0, true, false);
                    eff0.getCurativeItems().clear();
                    eff1.getCurativeItems().clear();
                    eff2.getCurativeItems().clear();
                    eff3.getCurativeItems().clear();
                    entityLiving.func_70690_d(eff0);
                    entityLiving.func_70690_d(eff1);
                    entityLiving.func_70690_d(eff2);
                    entityLiving.func_70690_d(eff3);
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "cloud");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.1);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return impact;
    }

    public static IBulletUpdateBehavior getLaserSteering() {
        IBulletUpdateBehavior onUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                Vec3 vec;
                if (bullet.shooter == null || !(bullet.shooter instanceof EntityPlayer)) {
                    return;
                }
                if (Vec3.createVectorHelper(bullet.field_70165_t - bullet.shooter.field_70165_t, bullet.field_70163_u - bullet.shooter.field_70163_u, bullet.field_70161_v - bullet.shooter.field_70161_v).lengthVector() > 100.0) {
                    return;
                }
                RayTraceResult mop = Library.rayTraceIncludeEntities((EntityPlayer)bullet.shooter, 200.0, 1.0f);
                if (mop == null || mop.field_72307_f == null) {
                    return;
                }
                if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity ent = mop.field_72308_g;
                    mop.field_72307_f = new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)(ent.func_70047_e() / 2.0f), ent.field_70161_v);
                }
                if ((vec = Vec3.createVectorHelper(mop.field_72307_f.field_72450_a - bullet.field_70165_t, mop.field_72307_f.field_72448_b - bullet.field_70163_u, mop.field_72307_f.field_72449_c - bullet.field_70161_v)).lengthVector() < 1.0) {
                    return;
                }
                vec = vec.normalize();
                double speed = Vec3.createVectorHelper(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y).lengthVector();
                bullet.field_70159_w = vec.xCoord * speed;
                bullet.field_70181_x = vec.yCoord * speed;
                bullet.field_70179_y = vec.zCoord * speed;
            }
        };
        return onUpdate;
    }

    public static IBulletUpdateBehavior getHomingBehavior(final double range, final double angle) {
        IBulletUpdateBehavior onUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                Entity target;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget")) == null) {
                    this.chooseTarget(bullet);
                }
                if ((target = bullet.field_70170_p.func_73045_a(bullet.getEntityData().func_74762_e("homingTarget"))) != null) {
                    Vec3 delta = Vec3.createVectorHelper(target.field_70165_t - bullet.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f) - bullet.field_70163_u, target.field_70161_v - bullet.field_70161_v);
                    delta = delta.normalize();
                    double vel = Vec3.createVectorHelper(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y).lengthVector();
                    bullet.field_70159_w = delta.xCoord * vel;
                    bullet.field_70181_x = delta.yCoord * vel;
                    bullet.field_70179_y = delta.zCoord * vel;
                }
            }

            private void chooseTarget(EntityBulletBase bullet) {
                List entities = bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.func_174813_aQ().func_72314_b(range, range, range));
                Vec3 mot = Vec3.createVectorHelper(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y);
                EntityLivingBase target = null;
                double targetAngle = angle;
                for (EntityLivingBase e : entities) {
                    double deltaAngle;
                    double dist;
                    if (!e.func_70089_S() || e == bullet.shooter) continue;
                    Vec3 delta = Vec3.createVectorHelper(e.field_70165_t - bullet.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f) - bullet.field_70163_u, e.field_70161_v - bullet.field_70161_v);
                    if (bullet.field_70170_p.func_72933_a(new Vec3d(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new Vec3d(e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v)) != null || !((dist = e.func_70068_e((Entity)bullet)) < range * range) || !((deltaAngle = BobMathUtil.getCrossAngle(mot, delta)) < targetAngle)) continue;
                    target = e;
                    targetAngle = deltaAngle;
                }
                if (target != null) {
                    bullet.getEntityData().func_74768_a("homingTarget", target.func_145782_y());
                }
            }
        };
        return onUpdate;
    }

    public static void nuclearExplosion(EntityBulletBase bullet, int x, int y, int z, int size) {
        if (!bullet.field_70170_p.field_72995_K) {
            double posX = bullet.field_70165_t;
            double posY = bullet.field_70163_u + 0.5;
            double posZ = bullet.field_70161_v;
            if (y >= 0) {
                posX = (double)x + 0.5;
                posY = (double)y + 1.5;
                posZ = (double)z + 0.5;
            }
            ExplosionNukeSmall.explode(bullet.field_70170_p, posX, posY, posZ, size);
        }
    }
}

