/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.CentrifugeRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.Centrifuge")
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack[] inputs) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(output, inputs));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(output));
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input;

        public ActionRemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Centrifuge input item can not be an empty/air stack!");
                return;
            }
            CentrifugeRecipes.removeRecipe(this.input);
        }

        public String describe() {
            return "Removing NTM Centrifuge recipe for input " + this.input;
        }
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack[] outputs;
        private ItemStack input;

        public ActionAddRecipe(IItemStack input, IItemStack[] outputs) {
            this.outputs = new ItemStack[outputs.length];
            for (int i = 0; i < outputs.length; ++i) {
                this.outputs[i] = CraftTweakerMC.getItemStack((IItemStack)outputs[i]);
            }
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.outputs == null || this.outputs.length == 0) {
                CraftTweakerAPI.logError((String)"ERROR Centrifuge recipe output items can not be an empty array!");
                return;
            }
            if (this.outputs.length > 4) {
                CraftTweakerAPI.logError((String)("ERROR Centrifuge recipe output item count must be <=4 not " + this.outputs.length + "!"));
                return;
            }
            for (ItemStack i : this.outputs) {
                if (i != null && !i.func_190926_b()) continue;
                CraftTweakerAPI.logError((String)"ERROR Centrifuge recipe output items can not include an empty/air stack!");
                return;
            }
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Centrifuge recipe input item can not be an empty/air stack!");
                return;
            }
            CentrifugeRecipes.addRecipe(this.input, this.outputs);
        }

        public String describe() {
            return "Adding NTM Centrifuge recipe (" + this.input + " -> " + this.outputs + ")";
        }
    }
}

