/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.DiFurnaceRecipes;
import com.hbm.inventory.RecipesCommon;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.BlastFurnace")
public class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack input1, IItemStack input2, IItemStack output) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(input1, input2, output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input1, IItemStack input2) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(input1, input2));
    }

    @ZenMethod
    public static void addFuel(IItemStack input, int heatLvl) {
        NTMCraftTweaker.postInitActions.add(new ActionAddFuel(input, heatLvl));
    }

    @ZenMethod
    public static void removeFuel(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveFuel(input));
    }

    public static class ActionRemoveFuel
    implements IAction {
        private ItemStack input;

        public ActionRemoveFuel(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace fuel item can not be an empty/air stack!");
                return;
            }
            DiFurnaceRecipes.removeFuel(new RecipesCommon.ComparableStack(this.input));
        }

        public String describe() {
            return "Removing blast furnace heat for input " + this.input;
        }
    }

    public static class ActionAddFuel
    implements IAction {
        private ItemStack input;
        private int heatLvl = 0;

        public ActionAddFuel(IItemStack input, int heatLvl) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.heatLvl = heatLvl;
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace input item can not be an empty/air stack!");
                return;
            }
            if (this.heatLvl < 1 || this.heatLvl > 12800) {
                CraftTweakerAPI.logError((String)("ERROR Blast Furnace heat needs to be between 1-12800 not " + this.heatLvl + "!"));
                return;
            }
            DiFurnaceRecipes.addFuel(new RecipesCommon.ComparableStack(this.input), this.heatLvl);
        }

        public String describe() {
            return "Adding NTM blast furnace heat (" + this.input + " -> " + this.heatLvl + " HEAT)";
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input1;
        private ItemStack input2;

        public ActionRemoveRecipe(IItemStack input1, IItemStack input2) {
            this.input1 = CraftTweakerMC.getItemStack((IItemStack)input1);
            this.input2 = CraftTweakerMC.getItemStack((IItemStack)input2);
        }

        public void apply() {
            if (this.input1 == null || this.input1.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace input 1 item can not be an empty/air stack!");
                return;
            }
            if (this.input2 == null || this.input2.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace input 2 item can not be an empty/air stack!");
                return;
            }
            DiFurnaceRecipes.removeRecipe(new RecipesCommon.ComparableStack(this.input1), new RecipesCommon.ComparableStack(this.input2));
        }

        public String describe() {
            return "Removing NTM blast furnace recipe for inputs " + this.input1 + " and " + this.input2;
        }
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack input1;
        private ItemStack input2;
        private ItemStack output;

        public ActionAddRecipe(IItemStack input1, IItemStack input2, IItemStack output) {
            this.input1 = CraftTweakerMC.getItemStack((IItemStack)input1);
            this.input2 = CraftTweakerMC.getItemStack((IItemStack)input2);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            if (this.input1 == null || this.input1.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace input 1 item can not be an empty/air stack!");
                return;
            }
            if (this.input2 == null || this.input2.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace input 2 item can not be an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Blast Furnace recipe output item can not be an empty/air stack!");
                return;
            }
            DiFurnaceRecipes.addRecipe(new RecipesCommon.ComparableStack(this.input1), new RecipesCommon.ComparableStack(this.input2), this.output);
        }

        public String describe() {
            return "Adding NTM blast furnace recipe (" + this.input1 + " + " + this.input2 + " -> " + this.output + ")";
        }
    }
}

