/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.RadiationSaveStructure;
import com.hbm.saveddata.RadiationSavedData;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class RadiationWorldHandler {
    public static void handleWorldDestruction(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (!RadiationConfig.worldRadEffects || !GeneralConfig.enableRads) {
            return;
        }
        int count = 50;
        int threshold = 5;
        if (GeneralConfig.advancedRadiation) {
            Collection<RadiationSystemNT.RadPocket> activePockets;
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Starting world destruction processing");
            }
            if ((activePockets = RadiationSystemNT.getActiveCollection(world)).size() == 0) {
                return;
            }
            int randIdx = world.field_73012_v.nextInt(activePockets.size());
            int itr = 0;
            for (RadiationSystemNT.RadPocket p : activePockets) {
                if (itr == randIdx) {
                    if (p.radiation < (float)threshold) {
                        return;
                    }
                    BlockPos startPos = p.getSubChunkPos();
                    RadiationSystemNT.RadPocket[] pocketsByBlock = p.parent.pocketsByBlock;
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            for (int k = 0; k < 16; ++k) {
                                IBlockState state;
                                if (world.field_73012_v.nextInt(3) != 0 || pocketsByBlock != null && pocketsByBlock[i * 16 * 16 + j * 16 + k] != p) continue;
                                BlockPos pos = startPos.func_177982_a(i, j, k);
                                IBlockState b = world.func_180495_p(pos);
                                Block bblock = b.func_177230_c();
                                if (world.func_175623_d(pos)) continue;
                                if (bblock == Blocks.field_150349_c) {
                                    world.func_175656_a(pos, ModBlocks.waste_earth.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150346_d) {
                                    world.func_175656_a(pos, ModBlocks.waste_dirt.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150354_m) {
                                    BlockSand.EnumType meta = (BlockSand.EnumType)b.func_177229_b((IProperty)BlockSand.field_176504_a);
                                    if (world.field_73012_v.nextInt(60) == 0) {
                                        world.func_175656_a(pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_trinitite.func_176223_P() : ModBlocks.waste_trinitite_red.func_176223_P());
                                        continue;
                                    }
                                    world.func_175656_a(pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_sand.func_176223_P() : ModBlocks.waste_sand_red.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150351_n) {
                                    world.func_175656_a(pos, ModBlocks.waste_gravel.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150391_bh) {
                                    world.func_175656_a(pos, ModBlocks.waste_mycelium.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150431_aC) {
                                    world.func_175656_a(pos, ModBlocks.fallout.func_176223_P());
                                    continue;
                                }
                                if (bblock == Blocks.field_150433_aE) {
                                    world.func_175656_a(pos, ModBlocks.block_fallout.func_176223_P());
                                    continue;
                                }
                                if (bblock instanceof BlockBush) {
                                    world.func_175656_a(pos, ModBlocks.waste_grass_tall.func_176223_P());
                                    continue;
                                }
                                if (bblock == ModBlocks.waste_leaves) {
                                    if (world.field_73012_v.nextInt(8) != 0) continue;
                                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
                                    state = world.func_180495_p(pos);
                                    world.func_184138_a(pos, state, state, 1);
                                    continue;
                                }
                                if (!(bblock instanceof BlockLeaves)) continue;
                                world.func_180501_a(pos, ModBlocks.waste_leaves.func_176223_P(), 1);
                                state = world.func_180495_p(pos);
                                world.func_184138_a(pos, state, state, 1);
                            }
                        }
                    }
                    break;
                }
                ++itr;
            }
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Finished world destruction processing");
            }
            return;
        }
        WorldServer serv = (WorldServer)world;
        RadiationSavedData data = RadiationSavedData.getData((World)serv);
        ChunkProviderServer provider = serv.func_72863_F();
        Object[] entries = data.contamination.entrySet().toArray();
        if (entries.length == 0) {
            return;
        }
        Map.Entry randEnt = (Map.Entry)entries[world.field_73012_v.nextInt(entries.length)];
        ChunkPos coords = (ChunkPos)randEnt.getKey();
        if (randEnt == null || ((RadiationSaveStructure)randEnt.getValue()).radiation < (float)threshold) {
            return;
        }
        if (provider.func_73149_a(coords.field_77276_a, coords.field_77275_b)) {
            for (int a = 0; a < 16; ++a) {
                for (int b = 0; b < 16; ++b) {
                    IBlockState state;
                    if (world.field_73012_v.nextInt(3) != 0) continue;
                    int x = coords.func_180334_c() + a;
                    int z = coords.func_180333_d() + b;
                    int y = world.func_189649_b(x, z) - world.field_73012_v.nextInt(2);
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState c = world.func_180495_p(pos);
                    Block bblock = c.func_177230_c();
                    if (world.func_175623_d(pos)) continue;
                    if (bblock == Blocks.field_150349_c) {
                        world.func_175656_a(pos, ModBlocks.waste_earth.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150346_d) {
                        world.func_175656_a(pos, ModBlocks.waste_dirt.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150354_m) {
                        BlockSand.EnumType meta = (BlockSand.EnumType)c.func_177229_b((IProperty)BlockSand.field_176504_a);
                        if (world.field_73012_v.nextInt(60) == 0) {
                            world.func_175656_a(pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_trinitite.func_176223_P() : ModBlocks.waste_trinitite_red.func_176223_P());
                            continue;
                        }
                        world.func_175656_a(pos, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_sand.func_176223_P() : ModBlocks.waste_sand_red.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150351_n) {
                        world.func_175656_a(pos, ModBlocks.waste_gravel.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150391_bh) {
                        world.func_175656_a(pos, ModBlocks.waste_mycelium.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150431_aC) {
                        world.func_175656_a(pos, ModBlocks.fallout.func_176223_P());
                        continue;
                    }
                    if (bblock == Blocks.field_150433_aE) {
                        world.func_175656_a(pos, ModBlocks.block_fallout.func_176223_P());
                        continue;
                    }
                    if (bblock instanceof BlockBush) {
                        world.func_175656_a(pos, ModBlocks.waste_grass_tall.func_176223_P());
                        continue;
                    }
                    if (bblock == ModBlocks.waste_leaves) {
                        if (world.field_73012_v.nextInt(8) != 0) continue;
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 1);
                        state = world.func_180495_p(pos);
                        world.func_184138_a(pos, state, state, 1);
                        continue;
                    }
                    if (!(bblock instanceof BlockLeaves)) continue;
                    world.func_180501_a(pos, ModBlocks.waste_leaves.func_176223_P(), 1);
                    state = world.func_180495_p(pos);
                    world.func_184138_a(pos, state, state, 1);
                }
            }
        }
    }
}

