/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.interfaces.Untested;
import com.hbm.main.MainRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class HTTPHandler {
    public static String capsule = "ERROR         ";
    public static boolean newVersion = false;
    public static boolean optifine = false;
    public static String versionNumber = "";
    public static String changes = "";

    public static void loadStats() {
        try {
            HTTPHandler.loadVersion();
            HTTPHandler.loadOF();
            HTTPHandler.loadSoyuz();
        }
        catch (IOException e) {
            MainRegistry.logger.warn("Version checker failed!");
        }
    }

    @Untested
    private static void loadOF() {
        File mods = new File(MainRegistry.proxy.getDataDir().getPath() + "/mods/");
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) throws IOException {
                return Files.isDirectory(file, new LinkOption[0]);
            }
        };
        Path dir = mods.toPath();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path : stream) {
                if (!path.getFileName().toString().toLowerCase().contains("optifine")) continue;
                optifine = true;
                return;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (optifine) {
            MainRegistry.logger.warn("Optifine present. This may cause compatibility with NTM's shaders!\n If experiencing issues, turn the enableShaders2 option in the config to false in order to disable them.");
        }
    }

    private static void loadVersion() throws IOException {
        String line;
        URL github = new URL("https://raw.githubusercontent.com/Alcatergit/Hbm-s-Nuclear-Tech-GIT/Custom-1.12.2/src/main/java/com/hbm/lib/RefStrings.java");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        MainRegistry.logger.info("Searching for new versions...");
        while ((line = in.readLine()) != null) {
            String sub;
            int end;
            int begin;
            if (line.contains("String VERSION")) {
                begin = line.indexOf(34);
                sub = line.substring(begin + 1, end = line.lastIndexOf(34));
                newVersion = !"NTM-Extended-1.12.2-1.9.8".equals(sub);
                versionNumber = sub;
                MainRegistry.logger.info("Found version " + sub);
            }
            if (!line.contains("String CHANGELOG")) continue;
            begin = line.indexOf(34);
            end = line.lastIndexOf(34);
            sub = line.substring(begin + 1, end);
            changes = sub.replaceAll("\u00c2", "");
            MainRegistry.logger.info("Found changelog " + sub);
            break;
        }
        MainRegistry.logger.info("Version checker ended.");
        in.close();
    }

    private static void loadSoyuz() throws IOException {
        URL github = new URL("https://gist.githubusercontent.com/HbmMods/a1cad71d00b6915945a43961d0037a43/raw/soyuz_holo");
        BufferedReader in = new BufferedReader(new InputStreamReader(github.openStream()));
        String line = in.readLine();
        if (line != null) {
            capsule = line;
        }
        in.close();
    }
}

