/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.capability.HbmLivingCapability;
import com.hbm.capability.HbmLivingProps;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.ExtPropPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.AuxSavedData;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityEffectHandler {
    public static void onUpdate(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            if (entity.field_70173_aa % 20 == 0) {
                HbmLivingProps.setRadBuf(entity, HbmLivingProps.getRadEnv(entity));
                HbmLivingProps.setRadEnv(entity, 0.0f);
            }
            if (entity instanceof EntityPlayerMP) {
                NBTTagCompound data = new NBTTagCompound();
                HbmLivingCapability.IEntityHbmProps props = HbmLivingProps.getData(entity);
                props.saveNBTData(data);
                PacketDispatcher.wrapper.sendTo((IMessage)new ExtPropPacket(data), (EntityPlayerMP)entity);
            }
        }
        EntityEffectHandler.handleContamination(entity);
        EntityEffectHandler.handleContagion(entity);
        EntityEffectHandler.handleRadiation(entity);
        EntityEffectHandler.handleDigamma(entity);
        EntityEffectHandler.handleLungDisease(entity);
    }

    private static void handleContamination(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        List<HbmLivingProps.ContaminationEffect> contamination = HbmLivingProps.getCont(entity);
        ArrayList<HbmLivingProps.ContaminationEffect> rem = new ArrayList<HbmLivingProps.ContaminationEffect>();
        for (HbmLivingProps.ContaminationEffect con : contamination) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, con.ignoreArmor ? ContaminationUtil.ContaminationType.RAD_BYPASS : ContaminationUtil.ContaminationType.CREATIVE, con.getRad());
            --con.time;
            if (con.time > 0) continue;
            rem.add(con);
        }
        contamination.removeAll(rem);
    }

    private static void handleRadiation(EntityLivingBase entity) {
        if (ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        World world = entity.field_70170_p;
        RadiationSavedData data = RadiationSavedData.getData(world);
        if (!world.field_72995_K) {
            NBTTagCompound nbt;
            int ix = MathHelper.func_76128_c((double)entity.field_70165_t);
            int iy = MathHelper.func_76128_c((double)entity.field_70163_u);
            int iz = MathHelper.func_76128_c((double)entity.field_70161_v);
            float rad = data.getRadNumFromCoord(new BlockPos(ix, iy, iz));
            Object dimRad = CompatibilityConfig.dimensionRad.get(world.field_73011_w.getDimension());
            if (dimRad != null && rad < ((Float)dimRad).floatValue()) {
                rad = ((Float)dimRad).floatValue();
            }
            if (rad > 0.0f) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad / 20.0f);
            }
            if (entity.field_70170_p.func_72896_J() && RadiationConfig.cont > 0 && AuxSavedData.getThunder(entity.field_70170_p) > 0 && entity.field_70170_p.func_175710_j(new BlockPos(ix, iy, iz))) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, (float)RadiationConfig.cont * 5.0E-4f);
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            Random rand = new Random(entity.func_145782_y());
            if (HbmLivingProps.getRadiation(entity) > 600.0f && (world.func_82737_E() + (long)rand.nextInt(600)) % 600L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "bloodvomit");
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                world.func_184148_a(null, (double)ix, (double)iy, (double)iz, HBMSoundHandler.vomit, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60, 19));
            } else if (HbmLivingProps.getRadiation(entity) > 200.0f && (world.func_82737_E() + (long)rand.nextInt(1200)) % 1200L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                world.func_184148_a(null, (double)ix, (double)iy, (double)iz, HBMSoundHandler.vomit, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60, 19));
            }
            if (HbmLivingProps.getRadiation(entity) > 900.0f && (world.func_82737_E() + (long)rand.nextInt(10)) % 10L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "sweat");
                nbt.func_74768_a("count", 1);
                nbt.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        } else {
            float radiation = HbmLivingProps.getRadiation(entity);
            if (entity instanceof EntityPlayer && radiation > 600.0f) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "radiation");
                nbt.func_74768_a("count", radiation > 900.0f ? 4 : (radiation > 800.0f ? 2 : 1));
                MainRegistry.proxy.effectNT(nbt);
            }
        }
    }

    private static void handleDigamma(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            float digamma = HbmLivingProps.getDigamma(entity);
            if (digamma < 0.01f) {
                return;
            }
            int chance = Math.max(10 - (int)digamma, 1);
            if (chance == 1 || entity.func_70681_au().nextInt(chance) == 0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "sweat");
                data.func_74768_a("count", 1);
                data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
                data.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }

    private static void handleContagion(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        if (!entity.field_70170_p.field_72995_K) {
            Random rand = entity.func_70681_au();
            int minute = 1200;
            int hour = 60 * minute;
            int contagion = HbmLivingProps.getContagion(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                int randSlot = rand.nextInt(player.field_71071_by.field_70462_a.size());
                ItemStack stack = player.field_71071_by.func_70301_a(randSlot);
                if (rand.nextInt(100) == 0) {
                    stack = (ItemStack)player.field_71071_by.field_70460_b.get(rand.nextInt(4));
                }
                if (stack != null && stack.func_77976_d() == 1) {
                    if (contagion > 0) {
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        stack.func_77978_p().func_74757_a("ntmContagion", true);
                    } else if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("ntmContagion")) {
                        HbmLivingProps.setContagion((EntityLivingBase)player, 3 * hour);
                    }
                }
            }
            if (contagion > 0) {
                HbmLivingProps.setContagion(entity, contagion - 1);
                if (contagion < 2 * hour + 55 * minute && contagion % 20 == 0) {
                    double range = entity.func_70026_G() ? 16.0 : 2.0;
                    List list = world.func_72839_b((Entity)entity, entity.func_174813_aQ().func_72314_b(range, range, range));
                    for (Entity ent : list) {
                        EntityLivingBase living;
                        if (ent instanceof EntityLivingBase && HbmLivingProps.getContagion(living = (EntityLivingBase)ent) <= 0) {
                            HbmLivingProps.setContagion(living, 3 * hour);
                        }
                        if (!(ent instanceof EntityItem)) continue;
                        ItemStack stack = ((EntityItem)ent).func_92059_d();
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        stack.func_77978_p().func_74757_a("ntmContagion", true);
                    }
                }
                if (contagion < 2 * hour && rand.nextInt(1000) == 0) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 20, 0));
                }
                if (contagion < 1 * hour && rand.nextInt(100) == 0) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 60, 0));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 300, 4));
                }
                if (contagion < 30 * minute && rand.nextInt(400) == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 1.0f);
                }
                if (contagion < 5 * minute && rand.nextInt(100) == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 2.0f);
                }
                if (contagion < 30 * minute && (contagion + entity.func_145782_y()) % 200 < 20) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("type", "vomit");
                    nbt.func_74778_a("mode", "blood");
                    nbt.func_74768_a("count", 25);
                    nbt.func_74768_a("entity", entity.func_145782_y());
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                    if ((contagion + entity.func_145782_y()) % 200 == 19) {
                        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.vomit, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
                if (contagion == 0) {
                    entity.func_70097_a(ModDamageSource.mku, 1000.0f);
                }
            }
        }
    }

    private static void handleLungDisease(EntityLivingBase entity) {
        boolean coughs;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            HbmLivingProps.setBlackLung(entity, 0);
            HbmLivingProps.setAsbestos(entity, 0);
            return;
        }
        int bl = HbmLivingProps.getBlackLung(entity);
        if (bl > 0 && (double)bl < 18000.0) {
            HbmLivingProps.setBlackLung(entity, HbmLivingProps.getBlackLung(entity) - 1);
        }
        double blacklung = Math.min(HbmLivingProps.getBlackLung(entity), 72000);
        double asbestos = Math.min(HbmLivingProps.getAsbestos(entity), 72000);
        boolean bl2 = coughs = blacklung / 72000.0 > 0.25 || asbestos / 72000.0 > 0.25;
        if (!coughs) {
            return;
        }
        boolean coughsCoal = blacklung / 72000.0 > 0.5;
        boolean coughsALotOfCoal = blacklung / 72000.0 > 0.8;
        boolean coughsBlood = asbestos / 72000.0 > 0.75 || blacklung / 72000.0 > 0.75;
        double blacklungDelta = 1.0 - blacklung / 72000.0;
        double asbestosDelta = 1.0 - asbestos / 72000.0;
        double total = 1.0 - blacklungDelta * asbestosDelta;
        int freq = Math.max((int)(1000.0 - 950.0 * total), 20);
        World world = entity.field_70170_p;
        Random rand = new Random(entity.func_145782_y());
        if (total > 0.8) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 6));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 0));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 3));
            if (rand.nextInt(250) == 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 2));
            }
        } else if (total > 0.65) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 2));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 2));
            if (rand.nextInt(500) == 0) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 0));
            }
        } else if (total > 0.45) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 1));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 1));
        } else if (total > 0.25) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
        }
        if (world.func_82737_E() % (long)freq == (long)(entity.func_145782_y() % freq)) {
            NBTTagCompound nbt;
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.cough, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (coughsBlood) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74778_a("mode", "blood");
                nbt.func_74768_a("count", 5);
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
            if (coughsCoal) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74778_a("mode", "smoke");
                nbt.func_74768_a("count", coughsALotOfCoal ? 50 : 10);
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }
}

