/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.hbm.items.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class HbmFluidHandlerItemStackInf
implements IFluidHandlerItem,
ICapabilityProvider {
    public static final String FLUID_NBT_KEY = "HbmFluidKey";
    private ItemStack container;
    private int maxDrainAmount;

    public HbmFluidHandlerItemStackInf(ItemStack stack, int maxDrain) {
        this.container = stack;
        this.maxDrainAmount = maxDrain;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties((FluidStack)(this.container.func_77973_b() == ModItems.inf_water || this.container.func_77973_b() == ModItems.inf_water_mk2 || this.container.func_77973_b() == ModItems.inf_water_mk3 || this.container.func_77973_b() == ModItems.inf_water_mk4 ? new FluidStack(FluidRegistry.WATER, this.maxDrainAmount) : null), this.maxDrainAmount)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_77973_b() == ModItems.inf_water || this.container.func_77973_b() == ModItems.inf_water_mk2 || this.container.func_77973_b() == ModItems.inf_water_mk3 || this.container.func_77973_b() == ModItems.inf_water_mk4) {
            return new FluidStack(FluidRegistry.WATER, this.maxDrainAmount);
        }
        if (resource == null) {
            return null;
        }
        return new FluidStack(resource.getFluid(), this.maxDrainAmount);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_77973_b() == ModItems.inf_water || this.container.func_77973_b() == ModItems.inf_water_mk2 || this.container.func_77973_b() == ModItems.inf_water_mk3 || this.container.func_77973_b() == ModItems.inf_water_mk4) {
            return new FluidStack(FluidRegistry.WATER, this.maxDrainAmount);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null);
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

