/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.google.common.base.Predicate;
import com.hbm.forgefluid.FFPipeNetwork;
import com.hbm.forgefluid.FluidContainerRegistry;
import com.hbm.forgefluid.FluidTypeHandler;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.forgefluid.SpecialContainerFillLists;
import com.hbm.interfaces.IFluidPipe;
import com.hbm.interfaces.IFluidPipeMk2;
import com.hbm.interfaces.IFluidVisualConnectable;
import com.hbm.interfaces.IItemFluidHandler;
import com.hbm.inventory.FluidCombustionRecipes;
import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ModItems;
import com.hbm.items.armor.JetpackBase;
import com.hbm.items.machine.ItemFluidTank;
import com.hbm.items.special.ItemCell;
import com.hbm.items.tool.ItemFluidCanister;
import com.hbm.items.tool.ItemGasCanister;
import com.hbm.lib.Library;
import com.hbm.render.RenderHelper;
import com.hbm.tileentity.machine.TileEntityDummy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.lwjgl.input.Keyboard;

public class FFUtils {
    public static void drawLiquid(FluidTank tank, int guiLeft, int guiTop, float zLevel, int sizeX, int sizeY, int offsetX, int offsetY) {
        FFUtils.drawLiquid(tank, guiLeft, guiTop, zLevel, sizeX, sizeY, offsetX, offsetY, false);
    }

    public static void drawLogLiquid(FluidTank tank, int guiLeft, int guiTop, float zLevel, int sizeX, int sizeY, int offsetX, int offsetY) {
        FFUtils.drawLiquid(tank, guiLeft, guiTop, zLevel, sizeX, sizeY, offsetX, offsetY, true);
    }

    public static void drawLiquid(FluidTank tank, int guiLeft, int guiTop, float zLevel, int sizeX, int sizeY, int offsetX, int offsetY, boolean log) {
        TextureAtlasSprite liquidIcon;
        offsetY -= 44;
        RenderHelper.bindBlockTexture();
        if (tank.getFluid() != null && (liquidIcon = FFUtils.getTextureFromFluid(tank.getFluid().getFluid())) != null) {
            int level = 0;
            if (log) {
                if (tank.getFluidAmount() > 0) {
                    level = (int)((double)sizeY * (Math.log(tank.getFluidAmount()) / Math.log(tank.getCapacity())));
                }
            } else {
                level = (int)((double)tank.getFluidAmount() / (double)tank.getCapacity() * (double)sizeY);
            }
            FFUtils.drawFull(tank.getFluid().getFluid(), guiLeft, guiTop, zLevel, liquidIcon, level, sizeX, offsetX, offsetY, sizeY);
        }
    }

    public static void drawLiquid(FluidStack fluid, int guiLeft, int guiTop, float zLevel, int sizeX, int sizeY, int offsetX, int offsetY) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        FFUtils.drawLiquid(fluid.getFluid(), guiLeft, guiTop, zLevel, sizeX, sizeY, offsetX, offsetY);
    }

    public static void drawLiquid(Fluid fluid, int guiLeft, int guiTop, float zLevel, int sizeX, int sizeY, int offsetX, int offsetY) {
        TextureAtlasSprite liquidIcon;
        RenderHelper.bindBlockTexture();
        if (fluid != null && (liquidIcon = FFUtils.getTextureFromFluid(fluid)) != null) {
            FFUtils.drawFull(fluid, guiLeft, guiTop, zLevel, liquidIcon, sizeY, sizeX, offsetX, offsetY, sizeY);
        }
    }

    private static void drawFull(Fluid f, int guiLeft, int guiTop, float zLevel, TextureAtlasSprite liquidIcon, int level, int sizeX, int offsetX, int offsetY, int sizeY) {
        int color = f.getColor();
        RenderHelper.setColor(color);
        RenderHelper.startDrawingTexturedQuads();
        for (int i = 0; i < level; i += 16) {
            for (int j = 0; j < sizeX; j += 16) {
                int drawX = Math.min(16, sizeX - j);
                int drawY = Math.min(16, level - i);
                RenderHelper.drawScaledTexture(liquidIcon, guiLeft + offsetX + j, guiTop + offsetY - i + (16 - drawY), drawX, drawY, zLevel);
            }
        }
        RenderHelper.draw();
    }

    public static void renderTankInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height, FluidTank fluidTank) {
        FFUtils.renderTankInfo(gui, mouseX, mouseY, x, y, width, height, fluidTank, null);
    }

    public static void renderTankInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height, FluidTank fluidTank, Fluid fluid) {
        if (fluidTank.getFluid() != null) {
            FFUtils.renderFluidInfo(gui, mouseX, mouseY, x, y, width, height, fluidTank.getFluid().getFluid(), fluidTank.getFluidAmount(), fluidTank.getCapacity());
        } else {
            FFUtils.renderFluidInfo(gui, mouseX, mouseY, x, y, width, height, fluid, 0, fluidTank.getCapacity());
        }
    }

    public static void addFluidInfo(Fluid fluid, List<String> texts) {
        float dfcEff;
        String heat;
        int temp2 = fluid.getTemperature() - 273;
        if (temp2 != 27) {
            String tempColor = "";
            tempColor = temp2 < -130 ? "\u00a73" : (temp2 < 0 ? "\u00a7b" : (temp2 < 100 ? "\u00a7e" : (temp2 < 300 ? "\u00a76" : (temp2 < 1000 ? "\u00a7c" : (temp2 < 3000 ? "\u00a74" : (temp2 < 20000 ? "\u00a75" : "\u00a7d"))))));
            texts.add(String.format("%s%d\u00b0C", tempColor, temp2));
        }
        boolean hasInfo = false;
        boolean isKeyPressed = Keyboard.isKeyDown((int)42);
        if (FluidTypeHandler.isAntimatter(fluid)) {
            if (isKeyPressed) {
                texts.add("\u00a74[" + I18n.func_135052_a((String)"trait.antimatter", (Object[])new Object[0]) + "]");
            }
            hasInfo = true;
        }
        if (FluidTypeHandler.isCorrosivePlastic(fluid)) {
            if (FluidTypeHandler.isCorrosiveIron(fluid)) {
                if (isKeyPressed) {
                    texts.add("\u00a72[" + I18n.func_135052_a((String)"trait.corrosiveIron", (Object[])new Object[0]) + "]");
                }
            } else if (isKeyPressed) {
                texts.add("\u00a7a[" + I18n.func_135052_a((String)"trait.corrosivePlastic", (Object[])new Object[0]) + "]");
            }
            hasInfo = true;
        }
        if (FluidCombustionRecipes.hasFuelRecipe(fluid)) {
            if (isKeyPressed) {
                String energy = Library.getShortNumber((long)FluidCombustionRecipes.getFlameEnergy(fluid) * 1000L);
                texts.add("\u00a76[" + I18n.func_135052_a((String)"trait.flammable", (Object[])new Object[0]) + "]");
                texts.add(" " + I18n.func_135052_a((String)"trait.flammable.desc", (Object[])new Object[]{energy}));
            }
            hasInfo = true;
        }
        if (HeatRecipes.hasCoolRecipe(fluid)) {
            if (isKeyPressed) {
                heat = Library.getShortNumber(HeatRecipes.getResultingHeat(fluid) * 1000 / HeatRecipes.getInputAmountCold(fluid));
                texts.add("\u00a74[" + I18n.func_135052_a((String)"trait.coolable", (Object[])new Object[0]) + "]");
                texts.add(" " + I18n.func_135052_a((String)"trait.coolable.desc", (Object[])new Object[]{heat}));
            }
            hasInfo = true;
        }
        if (HeatRecipes.hasBoilRecipe(fluid)) {
            if (isKeyPressed) {
                heat = Library.getShortNumber(HeatRecipes.getRequiredHeat(fluid) * 1000 / HeatRecipes.getInputAmountHot(fluid));
                texts.add("\u00a73[" + I18n.func_135052_a((String)"trait.boilable", (Object[])new Object[0]) + "]");
                texts.add(" " + I18n.func_135052_a((String)"trait.boilable.desc", (Object[])new Object[]{heat}));
            }
            hasInfo = true;
        }
        if ((dfcEff = FluidTypeHandler.getDFCEfficiency(fluid)) >= 1.0f) {
            if (isKeyPressed) {
                texts.add("\u00a75[" + I18n.func_135052_a((String)"trait.dfcFuel", (Object[])new Object[0]) + "]");
                texts.add(" " + I18n.func_135052_a((String)"trait.dfcFuel.desc", (Object[])new Object[]{dfcEff >= 0.0f ? "+" + Library.getPercentage(dfcEff) : Library.getPercentage(dfcEff -= 1.0f)}));
            }
            hasInfo = true;
        }
        if (hasInfo && !isKeyPressed) {
            texts.add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Hold <" + TextFormatting.YELLOW + "" + TextFormatting.ITALIC + "LSHIFT" + TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "> to display more info");
        }
    }

    private static void renderFluidInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height, Fluid fluid, int amount, int capacity) {
        if (x <= mouseX && x + width > mouseX && y < mouseY && y + height >= mouseY) {
            ArrayList<String> texts = new ArrayList<String>();
            if (fluid != null) {
                texts.add(fluid.getLocalizedName(new FluidStack(fluid, 1)));
                texts.add(amount + "/" + capacity + "mB");
                FFUtils.addFluidInfo(fluid, texts);
            } else {
                texts.add(I18n.func_135052_a((String)"None", (Object[])new Object[0]));
                texts.add(amount + "/" + capacity + "mB");
            }
            gui.drawFluidInfo(texts, mouseX, mouseY);
        }
    }

    public static boolean hasEnoughFluid(FluidTank t, FluidStack f) {
        if (f == null || f.amount == 0) {
            return true;
        }
        if (t == null || t.getFluid() == null) {
            return false;
        }
        return t.getFluid().isFluidEqual(f) && t.getFluidAmount() >= f.amount;
    }

    public static boolean fillFluid(TileEntity tileEntity, FluidTank tank, World world, BlockPos toFill, int maxDrain) {
        if (tank.getFluidAmount() <= 0 || tank.getFluid() == null || tank.getFluid().getFluid() == null) {
            return false;
        }
        TileEntity te = world.func_175625_s(toFill);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler tef;
            if (te instanceof TileEntityDummy) {
                TileEntityDummy ted = (TileEntityDummy)te;
                if (world.func_175625_s(ted.target) == tileEntity) {
                    return false;
                }
            }
            if ((tef = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && tef.fill(new FluidStack(tank.getFluid(), Math.min(maxDrain, tank.getFluidAmount())), false) > 0) {
                tank.drain(tef.fill(new FluidStack(tank.getFluid(), Math.min(maxDrain, tank.getFluidAmount())), true), true);
                return true;
            }
        }
        return false;
    }

    public static boolean fillFromFluidContainer(IItemHandlerModifiable slots, FluidTank tank, int slot1, int slot2) {
        if (slots == null || tank == null || slots.getSlots() < slot1 || slots.getSlots() < slot2 || slots.getStackInSlot(slot1) == null || slots.getStackInSlot(slot1).func_190926_b()) {
            return false;
        }
        if (FFUtils.trySpecialFillFromFluidContainer(slots, tank, slot1, slot2)) {
            return true;
        }
        if (slots.getStackInSlot(slot1).func_77973_b() == ModItems.fluid_barrel_infinite && tank.getFluid() != null) {
            return tank.fill(new FluidStack(tank.getFluid(), Integer.MAX_VALUE), true) > 0;
        }
        if (FluidUtil.getFluidContained((ItemStack)slots.getStackInSlot(slot1)) == null) {
            FFUtils.moveItems(slots, slot1, slot2, false);
            return false;
        }
        if (slots.getStackInSlot(slot1).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            boolean returnValue = false;
            IFluidHandlerItem ifhi = (IFluidHandlerItem)slots.getStackInSlot(slot1).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (ifhi != null && (tank.getFluid() == null || FluidUtil.getFluidContained((ItemStack)slots.getStackInSlot(slot1)).getFluid() == tank.getFluid().getFluid())) {
                tank.fill(ifhi.drain(Math.min(6000, tank.getCapacity() - tank.getFluidAmount()), true), true);
                returnValue = true;
            }
            if (ifhi.drain(Integer.MAX_VALUE, false) == null) {
                FFUtils.moveItems(slots, slot1, slot2, true);
            }
            return returnValue;
        }
        ItemStack stack = slots.getStackInSlot(slot1);
        if (stack.func_77973_b() instanceof IItemFluidHandler) {
            boolean returnValue = false;
            IItemFluidHandler handler = (IItemFluidHandler)stack.func_77973_b();
            FluidStack contained = handler.drain(stack, Integer.MAX_VALUE, false);
            if (contained != null && (tank.getFluid() == null || contained.getFluid() == tank.getFluid().getFluid())) {
                tank.fill(handler.drain(stack, Math.min(6000, tank.getCapacity() - tank.getFluidAmount()), true), true);
                returnValue = true;
            }
            if (handler.drain(stack, Integer.MAX_VALUE, false) == null) {
                FFUtils.moveItems(slots, slot1, slot2, true);
            }
            return returnValue;
        }
        return false;
    }

    private static boolean trySpecialFillFromFluidContainer(IItemHandlerModifiable slots, FluidTank tank, int slot1, int slot2) {
        ItemStack in = slots.getStackInSlot(slot1);
        ItemStack out = slots.getStackInSlot(slot2);
        if (in.func_77973_b() == ModItems.fluid_tank_full && tank.fill(FluidUtil.getFluidContained((ItemStack)in), false) == 1000 && (ItemFluidTank.isEmptyTank(out) && out.func_190916_E() < 64 || out.func_190926_b())) {
            tank.fill(FluidUtil.getFluidContained((ItemStack)in), true);
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, new ItemStack(ModItems.fluid_tank_full));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (in.func_77973_b() == ModItems.fluid_barrel_full && tank.fill(FluidUtil.getFluidContained((ItemStack)in), false) == 16000 && (ItemFluidTank.isEmptyBarrel(out) && out.func_190916_E() < 64 || out.func_190926_b())) {
            tank.fill(FluidUtil.getFluidContained((ItemStack)in), true);
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, new ItemStack(ModItems.fluid_barrel_full));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (in.func_77973_b() == ModItems.canister_generic && tank.fill(FluidUtil.getFluidContained((ItemStack)in), false) == 1000 && (ItemFluidCanister.isEmptyCanister(out) && out.func_190916_E() < 64 || out.func_190926_b())) {
            tank.fill(FluidUtil.getFluidContained((ItemStack)in), true);
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, new ItemStack(ModItems.canister_generic));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (in.func_77973_b() == ModItems.gas_canister && tank.fill(FluidUtil.getFluidContained((ItemStack)in), false) == 4000 && (ItemGasCanister.isEmptyCanister(out) && out.func_190916_E() < 64 || out.func_190926_b())) {
            tank.fill(FluidUtil.getFluidContained((ItemStack)in), true);
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, new ItemStack(ModItems.gas_canister));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (in.func_77973_b() == ModItems.cell && tank.fill(FluidUtil.getFluidContained((ItemStack)in), false) == 1000 && (ItemCell.isEmptyCell(out) && out.func_190916_E() < 64 || out.func_190926_b())) {
            tank.fill(FluidUtil.getFluidContained((ItemStack)in), true);
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, new ItemStack(ModItems.cell));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (FluidContainerRegistry.hasFluid(in.func_77973_b())) {
            FluidStack fluid = FluidContainerRegistry.getFluidFromItem(in.func_77973_b());
            Item container = FluidContainerRegistry.getContainerItem(in.func_77973_b());
            if (tank.fill(fluid, false) == fluid.amount && (out.func_190926_b() || out.func_77973_b() == container && out.func_190916_E() < out.func_77976_d())) {
                tank.fill(fluid, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(container));
                } else {
                    out.func_190917_f(1);
                }
            }
        }
        return false;
    }

    public static boolean checkRestrictions(ItemStack stack, Predicate<FluidStack> fluidRestrictor) {
        if (stack.func_77973_b() == ModItems.fluid_barrel_infinite) {
            return true;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null && fluidRestrictor.apply((Object)fluid)) {
            return true;
        }
        return FluidContainerRegistry.hasFluid(stack.func_77973_b()) && (fluid = FluidContainerRegistry.getFluidFromItem(stack.func_77973_b())) != null && fluidRestrictor.apply((Object)fluid);
    }

    public static boolean fillFluidContainer(IItemHandlerModifiable slots, FluidTank tank, int slot1, int slot2) {
        if (slots == null || tank == null || tank.getFluid() == null || slots.getSlots() < slot1 || slots.getSlots() < slot2 || slots.getStackInSlot(slot1) == null || slots.getStackInSlot(slot1).func_190926_b()) {
            return false;
        }
        if (FFUtils.trySpecialFillFluidContainer(slots, tank, slot1, slot2)) {
            return true;
        }
        if (slots.getStackInSlot(slot1).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            boolean returnValue = false;
            IFluidHandlerItem ifhi = FluidUtil.getFluidHandler((ItemStack)slots.getStackInSlot(slot1));
            FluidStack stack = FluidUtil.getFluidContained((ItemStack)slots.getStackInSlot(slot1));
            if (stack != null && ifhi.fill(tank.getFluid(), false) <= 0) {
                FFUtils.moveItems(slots, slot1, slot2, false);
                return false;
            }
            if (stack == null || stack.getFluid() == tank.getFluid().getFluid()) {
                tank.drain(ifhi.fill(new FluidStack(tank.getFluid(), Math.min(6000, tank.getFluidAmount())), true), true);
                returnValue = true;
            }
            slots.setStackInSlot(slot1, ifhi.getContainer());
            stack = FluidUtil.getFluidContained((ItemStack)slots.getStackInSlot(slot1));
            if (stack != null && ifhi.fill(new FluidStack(stack.getFluid(), Integer.MAX_VALUE), false) <= 0) {
                FFUtils.moveItems(slots, slot1, slot2, false);
            }
            return returnValue;
        }
        ItemStack stack = slots.getStackInSlot(slot1);
        if (stack.func_77973_b() instanceof IItemFluidHandler) {
            boolean returnValue = false;
            IItemFluidHandler handler = (IItemFluidHandler)stack.func_77973_b();
            FluidStack contained = handler.drain(stack, Integer.MAX_VALUE, false);
            if (contained != null && handler.fill(stack, tank.getFluid(), false) <= 0) {
                FFUtils.moveItems(slots, slot1, slot2, true);
                return false;
            }
            if (contained == null || contained.getFluid() == tank.getFluid().getFluid()) {
                tank.drain(handler.fill(stack, new FluidStack(tank.getFluid(), Math.min(6000, tank.getFluidAmount())), true), true);
                returnValue = true;
            }
            if ((contained = handler.drain(stack, Integer.MAX_VALUE, false)) != null && handler.fill(stack, new FluidStack(contained.getFluid(), Integer.MAX_VALUE), false) <= 0) {
                FFUtils.moveItems(slots, slot1, slot2, true);
            }
            return returnValue;
        }
        return false;
    }

    private static boolean trySpecialFillFluidContainer(IItemHandlerModifiable slots, FluidTank tank, int slot1, int slot2) {
        ItemStack in = slots.getStackInSlot(slot1);
        ItemStack out = slots.getStackInSlot(slot2);
        if (tank.getFluid() != null && in.func_77973_b() == ModItems.fluid_tank_full && tank.drain(1000, false) != null && tank.drain((int)1000, (boolean)false).amount == 1000 && ItemFluidTank.isEmptyTank(in) && (ItemFluidTank.isFullTank(out, tank.getFluid().getFluid()) && out.func_190916_E() < 64 || out.func_190926_b())) {
            FluidStack f = tank.drain(1000, true);
            if (f == null) {
                return false;
            }
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, ItemFluidTank.getFullTank(f.getFluid()));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (tank.getFluid() != null && in.func_77973_b() == ModItems.fluid_barrel_full && tank.drain(16000, false) != null && tank.drain((int)16000, (boolean)false).amount == 16000 && ItemFluidTank.isEmptyBarrel(in) && (ItemFluidTank.isFullBarrel(out, tank.getFluid().getFluid()) && out.func_190916_E() < 64 || out.func_190926_b())) {
            FluidStack f = tank.drain(16000, true);
            if (f == null) {
                return false;
            }
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, ItemFluidTank.getFullBarrel(f.getFluid()));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (tank.getFluid() != null && in.func_77973_b() == ModItems.canister_generic && SpecialContainerFillLists.EnumCanister.contains(tank.getFluid().getFluid()) && tank.drain(1000, false) != null && tank.drain((int)1000, (boolean)false).amount == 1000 && ItemFluidCanister.isEmptyCanister(in) && (ItemFluidCanister.isFullCanister(out, tank.getFluid().getFluid()) && out.func_190916_E() < 64 || out.func_190926_b())) {
            FluidStack f = tank.drain(1000, true);
            if (f == null) {
                return false;
            }
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, ItemFluidCanister.getFullCanister(f.getFluid()));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (tank.getFluid() != null && in.func_77973_b() == ModItems.gas_canister && SpecialContainerFillLists.EnumGasCanister.contains(tank.getFluid().getFluid()) && tank.drain(4000, false) != null && tank.drain((int)4000, (boolean)false).amount == 4000 && ItemGasCanister.isEmptyCanister(in) && (ItemGasCanister.isFullCanister(out, tank.getFluid().getFluid()) && out.func_190916_E() < 64 || out.func_190926_b())) {
            FluidStack f = tank.drain(4000, true);
            if (f == null) {
                return false;
            }
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, ItemGasCanister.getFullCanister(f.getFluid()));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (tank.getFluid() != null && in.func_77973_b() == ModItems.cell && SpecialContainerFillLists.EnumCell.contains(tank.getFluid().getFluid()) && tank.drain(1000, false) != null && tank.drain((int)1000, (boolean)false).amount == 1000 && ItemCell.isEmptyCell(in) && (ItemCell.isFullCell(out, tank.getFluid().getFluid()) && out.func_190916_E() < 64 || out.func_190926_b())) {
            FluidStack f = tank.drain(1000, true);
            if (f == null) {
                return false;
            }
            in.func_190918_g(1);
            if (out.func_190926_b()) {
                slots.setStackInSlot(slot2, ItemCell.getFullCell(f.getFluid()));
            } else {
                out.func_190917_f(1);
            }
            return true;
        }
        if (in.func_77973_b() == ModItems.rod_empty) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.coolant && tank.getFluid().amount >= 1000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(1000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_coolant));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_coolant));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.tritium && tank.getFluid().amount >= 1000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(1000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_tritium));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_tritium));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == FluidRegistry.WATER && tank.getFluid().amount >= 1000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(1000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_water));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_water));
                }
                return true;
            }
        }
        if (in.func_77973_b() == ModItems.rod_dual_empty) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.coolant && tank.getFluid().amount >= 2000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(2000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_dual_coolant));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_dual_coolant));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.tritium && tank.getFluid().amount >= 2000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(2000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_dual_tritium));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_dual_tritium));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == FluidRegistry.WATER && tank.getFluid().amount >= 2000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(2000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_dual_water));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_dual_water));
                }
                return true;
            }
        }
        if (in.func_77973_b() == ModItems.rod_quad_empty) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.coolant && tank.getFluid().amount >= 4000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(4000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_quad_coolant));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_quad_coolant));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == ModForgeFluids.tritium && tank.getFluid().amount >= 4000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(4000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_quad_tritium));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_quad_tritium));
                }
                return true;
            }
            if (tank.getFluid() != null && tank.getFluid().getFluid() == FluidRegistry.WATER && tank.getFluid().amount >= 4000 && (out.func_190926_b() || in.func_190916_E() == 1)) {
                tank.drain(4000, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(ModItems.rod_quad_water));
                } else {
                    slots.setStackInSlot(slot1, new ItemStack(ModItems.rod_quad_water));
                }
                return true;
            }
        }
        if (in.func_77973_b() instanceof JetpackBase && ((JetpackBase)in.func_77973_b()).fuel == tank.getFluid().getFluid() && tank.getFluidAmount() > 0 && JetpackBase.getFuel(in) < ((JetpackBase)in.func_77973_b()).maxFuel) {
            FluidStack st = tank.drain(25, false);
            int fill = st == null ? 0 : st.amount;
            JetpackBase.setFuel(in, Math.min(JetpackBase.getFuel(in) + fill, ((JetpackBase)in.func_77973_b()).maxFuel));
            tank.drain(25, true);
            if (JetpackBase.getFuel(in) >= ((JetpackBase)in.func_77973_b()).maxFuel && out.func_190926_b()) {
                slots.setStackInSlot(slot2, in);
                slots.setStackInSlot(slot1, ItemStack.field_190927_a);
            }
            return true;
        }
        Item container = FluidContainerRegistry.getFullContainer(in.func_77973_b(), tank.getFluid().getFluid());
        if (container != null && container != Items.field_190931_a) {
            FluidStack stack = FluidContainerRegistry.getFluidFromItem(container);
            if (tank.drain((FluidStack)stack, (boolean)false).amount == stack.amount && (out.func_190926_b() || out.func_77973_b() == container && out.func_190916_E() < out.func_77976_d())) {
                tank.drain(stack, true);
                in.func_190918_g(1);
                if (out.func_190926_b()) {
                    slots.setStackInSlot(slot2, new ItemStack(container));
                } else {
                    out.func_190917_f(1);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean moveItems(IItemHandlerModifiable slots, int in, int out, boolean shouldUseContainerItem) {
        if (slots.getStackInSlot(in) != null && !slots.getStackInSlot(in).func_190926_b()) {
            if (shouldUseContainerItem && slots.getStackInSlot(in).func_77973_b().hasContainerItem(slots.getStackInSlot(in))) {
                slots.setStackInSlot(in, slots.getStackInSlot(in).func_77973_b().getContainerItem(slots.getStackInSlot(in)));
            }
            if (slots.getStackInSlot(out) == null || slots.getStackInSlot(out).func_190926_b()) {
                slots.setStackInSlot(out, slots.getStackInSlot(in));
                slots.setStackInSlot(in, ItemStack.field_190927_a);
                return true;
            }
            if (Library.areItemStacksEqualIgnoreCount(slots.getStackInSlot(in), slots.getStackInSlot(out))) {
                int amountToTransfer = Math.min(slots.getStackInSlot(out).func_77976_d() - slots.getStackInSlot(out).func_190916_E(), slots.getStackInSlot(in).func_190916_E());
                slots.getStackInSlot(in).func_190918_g(amountToTransfer);
                if (slots.getStackInSlot(in).func_190916_E() <= 0) {
                    slots.setStackInSlot(in, ItemStack.field_190927_a);
                }
                slots.getStackInSlot(out).func_190917_f(amountToTransfer);
                return true;
            }
        }
        return false;
    }

    public static FluidTank changeTankSize(FluidTank fluidTank, int i) {
        FluidTank newTank = new FluidTank(i);
        if (fluidTank.getFluid() == null) {
            return newTank;
        }
        newTank.fill(fluidTank.getFluid(), true);
        return newTank;
    }

    public static TextureAtlasSprite getTextureFromFluid(Fluid f) {
        if (f == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(f.getStill().toString());
    }

    public static int getColorFromFluid(Fluid f) {
        return Library.getColorFromResourceLocation(new ResourceLocation(f.getStill().func_110624_b(), "textures/" + f.getStill().func_110623_a() + ".png"));
    }

    public static void setColorFromFluid(Fluid f) {
        if (f == null) {
            return;
        }
        FFUtils.setRGBAFromHex(f.getColor());
    }

    public static void setRGBAFromHex(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void setRGBFromHex(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        if (stack.func_77973_b() == ModItems.fluid_barrel_infinite) {
            return true;
        }
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)stack);
        if (contained != null && contained.getFluid() == fluid) {
            return true;
        }
        return FluidContainerRegistry.hasFluid(stack.func_77973_b()) && (contained = FluidContainerRegistry.getFluidFromItem(stack.func_77973_b())) != null && contained.getFluid() == fluid;
    }

    public static NBTTagList serializeTankArray(FluidTank[] tanks) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < tanks.length; ++i) {
            if (tanks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("tank", (byte)i);
            tanks[i].writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static void deserializeTankArray(NBTTagList tankList, FluidTank[] tanks) {
        for (int i = 0; i < tankList.func_74745_c(); ++i) {
            NBTTagCompound tag = tankList.func_150305_b(i);
            byte b0 = tag.func_74771_c("tank");
            if (b0 < 0 || b0 >= tanks.length) continue;
            tanks[b0].readFromNBT(tag);
        }
    }

    public static boolean areTanksEqual(FluidTank tank1, FluidTank tank2) {
        if (tank1 == null && tank2 == null) {
            return true;
        }
        if (tank1 == null ^ tank2 == null) {
            return false;
        }
        if (tank1.getFluid() == null && tank2.getFluid() == null) {
            return true;
        }
        if (tank1.getFluid() == null ^ tank2.getFluid() == null) {
            return false;
        }
        return tank1.getFluid().amount == tank2.getFluid().amount && tank1.getFluid().getFluid() == tank2.getFluid().getFluid() && tank1.getCapacity() == tank2.getCapacity();
    }

    public static FluidTank copyTank(FluidTank tank) {
        if (tank == null) {
            return null;
        }
        return new FluidTank(tank.getFluid() != null ? tank.getFluid().copy() : null, tank.getCapacity());
    }

    public static boolean checkFluidConnectables(World world, BlockPos pos, FFPipeNetwork net, @Nullable EnumFacing facing) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof IFluidPipe && ((IFluidPipe)tileentity).getNetworkTrue() == net) {
            return true;
        }
        return tileentity != null && !(tileentity instanceof IFluidPipe) && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    public static boolean checkFluidConnectablesMk2(World world, BlockPos pos, Fluid type, @Nullable EnumFacing facing) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof IFluidPipeMk2 && ((IFluidPipeMk2)tileentity).getType() == type) {
            return true;
        }
        if (tileentity != null && !(tileentity instanceof IFluidPipeMk2) && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            return true;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IFluidVisualConnectable) {
            return ((IFluidVisualConnectable)block).shouldConnect(type);
        }
        return false;
    }
}

