/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.hbm.interfaces.IFluidPipeMk2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FFPipeNetworkMk2
implements IFluidHandler {
    protected static Random rand = new Random();
    protected Fluid type;
    protected Map<BlockPos, TileEntity> fillables = new HashMap<BlockPos, TileEntity>();
    protected Map<BlockPos, IFluidPipeMk2> pipes = new HashMap<BlockPos, IFluidPipeMk2>();

    public FFPipeNetworkMk2(IFluidPipeMk2 te) {
        this.type = te.getType();
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != this.type) {
            return 0;
        }
        ArrayList<IFluidHandler> handlers = new ArrayList<IFluidHandler>();
        Iterator<TileEntity> itr = this.fillables.values().iterator();
        while (itr.hasNext()) {
            IFluidHandler h;
            TileEntity te = itr.next();
            if (te.func_145837_r()) {
                itr.remove();
                continue;
            }
            if (!te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || (h = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) == null || h.fill(new FluidStack(resource.getFluid(), 1), false) <= 0) continue;
            handlers.add(h);
        }
        if (handlers.isEmpty()) {
            return 0;
        }
        int part = resource.amount / handlers.size();
        int totalDrained = 0;
        int remaining = resource.amount;
        int intRoundingCompensation = resource.amount - part * handlers.size();
        rand.setSeed(this.fillables.values().iterator().next().func_145831_w().func_72820_D());
        int randomFillIndex = rand.nextInt(handlers.size());
        for (int i = 0; i < handlers.size(); ++i) {
            IFluidHandler consumer = (IFluidHandler)handlers.get(i);
            int vol = consumer.fill(new FluidStack(resource.getFluid(), randomFillIndex == i ? part + intRoundingCompensation : part), doFill);
            totalDrained += vol;
            if ((remaining -= vol) > 0) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int size() {
        return this.fillables.size() + this.pipes.size();
    }

    public Fluid getType() {
        return this.type;
    }

    public void destroy() {
        this.pipes.values().forEach(pipe -> pipe.setNetwork(null));
        this.pipes.clear();
        this.fillables.clear();
    }

    public void checkForRemoval(TileEntity te) {
        if (te == null) {
            return;
        }
        if (te instanceof IFluidPipeMk2) {
            this.pipes.remove(te.func_174877_v());
        } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            this.fillables.remove(te.func_174877_v());
        }
    }

    public boolean tryAdd(TileEntity te) {
        if (te == null) {
            return false;
        }
        if (te instanceof IFluidPipeMk2) {
            if (!this.pipes.containsKey(te.func_174877_v()) && ((IFluidPipeMk2)te).getType() == this.type) {
                this.pipes.put(te.func_174877_v(), (IFluidPipeMk2)te);
                return true;
            }
        } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && !this.fillables.containsKey(te.func_174877_v())) {
            this.fillables.put(te.func_174877_v(), te);
            return true;
        }
        return false;
    }

    public static FFPipeNetworkMk2 mergeNetworks(FFPipeNetworkMk2 net1, FFPipeNetworkMk2 net2) {
        if (net1 == null || net2 == null || net1 == net2) {
            return net1;
        }
        for (IFluidPipeMk2 pipe : net2.pipes.values()) {
            pipe.setNetwork(net1);
        }
        net1.fillables.putAll(net2.fillables);
        net1.pipes.putAll(net2.pipes);
        net2.fillables.clear();
        net2.pipes.clear();
        return net1;
    }

    public static FFPipeNetworkMk2 buildNetwork(TileEntity te) {
        FFPipeNetworkMk2 net = null;
        if (te instanceof IFluidPipeMk2) {
            IFluidPipeMk2 pipe = (IFluidPipeMk2)te;
            if (pipe.getNetwork() != null) {
                return pipe.getNetwork();
            }
            Fluid type = pipe.getType();
            HashMap<BlockPos, IFluidPipeMk2> pipes = new HashMap<BlockPos, IFluidPipeMk2>();
            HashMap<BlockPos, TileEntity> consumers = new HashMap<BlockPos, TileEntity>();
            ArrayList<FFPipeNetworkMk2> toMerge = new ArrayList<FFPipeNetworkMk2>();
            FFPipeNetworkMk2.iteratePipes(pipes, consumers, toMerge, te, type);
            net = toMerge.size() > 0 ? (FFPipeNetworkMk2)toMerge.remove(0) : new FFPipeNetworkMk2(pipe);
            while (toMerge.size() > 0) {
                FFPipeNetworkMk2.mergeNetworks(net, (FFPipeNetworkMk2)toMerge.remove(0));
            }
            for (IFluidPipeMk2 p : pipes.values()) {
                p.setNetwork(net);
            }
            net.pipes.putAll(pipes);
            net.fillables.putAll(consumers);
        }
        return net;
    }

    public static void iteratePipes(Map<BlockPos, IFluidPipeMk2> pipes, Map<BlockPos, TileEntity> consumers, List<FFPipeNetworkMk2> networks, TileEntity te, Fluid type) {
        if (te == null) {
            return;
        }
        if (te instanceof IFluidPipeMk2) {
            IFluidPipeMk2 pipe = (IFluidPipeMk2)te;
            if (pipe.getType() == type && pipe.isValidForBuilding()) {
                if (pipe.getNetwork() == null) {
                    if (!pipes.containsKey(te.func_174877_v())) {
                        pipes.put(te.func_174877_v(), pipe);
                        for (EnumFacing e : EnumFacing.field_82609_l) {
                            BlockPos pos = te.func_174877_v().func_177972_a(e);
                            if (!te.func_145831_w().func_175667_e(pos)) continue;
                            FFPipeNetworkMk2.iteratePipes(pipes, consumers, networks, te.func_145831_w().func_175625_s(pos), type);
                        }
                    }
                } else if (pipe.getNetwork().type == type && !networks.contains(pipe.getNetwork())) {
                    networks.add(pipe.getNetwork());
                }
            }
        } else if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && !consumers.containsKey(te.func_174877_v())) {
            consumers.put(te.func_174877_v(), te);
        }
    }
}

