/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.hbm.interfaces.IFluidPipe;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class FFPipeNetwork
implements IFluidHandler {
    protected Fluid type;
    protected List<ICapabilityProvider> fillables = new ArrayList<ICapabilityProvider>();
    protected List<IFluidPipe> pipes = new ArrayList<IFluidPipe>();
    protected FluidTank internalNetworkTank = new FluidTank(4000);
    private int tickTimer = 0;

    public FFPipeNetwork() {
        this(null);
    }

    public FFPipeNetwork(Fluid fluid) {
        this.type = fluid;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MainRegistry.allPipeNetworks.add(this);
        }
    }

    public int getSize() {
        return this.pipes.size() + this.fillables.size();
    }

    public List<ICapabilityProvider> getConsumers() {
        return this.fillables;
    }

    public List<IFluidPipe> getPipes() {
        return this.pipes;
    }

    public World getNetworkWorld() {
        for (IFluidPipe pipe : this.pipes) {
            if (pipe == null || ((TileEntity)pipe).func_145831_w() == null) continue;
            return ((TileEntity)pipe).func_145831_w();
        }
        return null;
    }

    public void updateTick() {
        this.tickTimer = this.tickTimer < 20 ? ++this.tickTimer : 0;
        if (this.tickTimer == 9 || this.tickTimer == 19) {
            if (this.pipes.isEmpty()) {
                this.destroySoft();
            }
            this.fillFluidInit();
        }
    }

    public void fillFluidInit() {
        if (this.internalNetworkTank.getFluid() == null || this.internalNetworkTank.getFluidAmount() <= 0) {
            return;
        }
        ArrayList<Object> consumers = new ArrayList<Object>();
        for (ICapabilityProvider handle : this.fillables) {
            if (handle == null || !handle.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || ((IFluidHandler)handle.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(new FluidStack(this.type, 1), false) <= 0 || !consumers.contains(handle)) {
                // empty if block
            }
            consumers.add(handle.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        }
        int size = consumers.size();
        if (size <= 0) {
            return;
        }
        int part = this.internalNetworkTank.getFluidAmount() / size;
        int lastPart = part + this.internalNetworkTank.getFluidAmount() - part * size;
        int i = 1;
        for (IFluidHandler iFluidHandler : consumers) {
            ++i;
            if (this.internalNetworkTank.getFluid() == null || iFluidHandler == null) continue;
            this.internalNetworkTank.drain(iFluidHandler.fill(new FluidStack(this.internalNetworkTank.getFluid().getFluid(), i < consumers.size() ? part : lastPart), true), true);
        }
    }

    public static FFPipeNetwork mergeNetworks(FFPipeNetwork net, FFPipeNetwork merge) {
        if (net != null && merge != null && net != merge) {
            if (net.getType() == null || merge.getType() == null || net.getType() != merge.getType()) {
                return net;
            }
            for (IFluidPipe pipe : merge.pipes) {
                net.addPipe(pipe);
                pipe.setNetwork(net);
            }
            merge.pipes.clear();
            for (ICapabilityProvider fill : merge.fillables) {
                net.fillables.add(fill);
            }
            merge.Destroy();
            return net;
        }
        if (net != null) {
            return net;
        }
        return null;
    }

    public static FFPipeNetwork buildNewNetwork(TileEntity pipe) {
        FFPipeNetwork net = null;
        if (pipe instanceof IFluidPipe) {
            IFluidPipe fPipe = (IFluidPipe)pipe;
            fPipe.getNetwork().Destroy();
            net = new FFPipeNetwork(fPipe.getType());
            List[] netVars = FFPipeNetwork.iteratePipes(null, null, null, pipe, net.getType());
            net.pipes.clear();
            net.pipes.addAll(netVars[0]);
            for (IFluidPipe setPipe : net.pipes) {
                setPipe.setNetwork(net);
            }
            net.fillables.clear();
            net.fillables.addAll(netVars[1]);
            net.setType(fPipe.getType());
            List mergeList = netVars[2];
            for (FFPipeNetwork network : mergeList) {
                FFPipeNetwork.mergeNetworks(net, network);
            }
        }
        return net;
    }

    public static List[] iteratePipes(List<IFluidPipe> pipes, List<ICapabilityProvider> consumers, List<FFPipeNetwork> networks, TileEntity te, Fluid type) {
        if (pipes == null) {
            pipes = new ArrayList<IFluidPipe>();
        }
        if (consumers == null) {
            consumers = new ArrayList<ICapabilityProvider>();
        }
        if (networks == null) {
            networks = new ArrayList<FFPipeNetwork>();
        }
        if (te == null) {
            return new List[]{pipes, consumers, networks};
        }
        TileEntity next = null;
        if (te.func_145831_w().func_175625_s(te.func_174877_v()) != null) {
            if (!pipes.contains((IFluidPipe)te) && ((IFluidPipe)te).getIsValidForForming()) {
                pipes.add((IFluidPipe)te);
            }
            for (int i = 0; i < 6; ++i) {
                next = FFPipeNetwork.getTileEntityAround(te, i);
                if (next instanceof IFluidHandler && next instanceof IFluidPipe && ((IFluidPipe)next).getIsValidForForming() && ((IFluidPipe)next).getType() == type && !pipes.contains((IFluidPipe)next)) {
                    FFPipeNetwork.iteratePipes(pipes, consumers, networks, next, type);
                    continue;
                }
                if (next == null || !next.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || next instanceof IFluidPipe || consumers.contains(next)) continue;
                consumers.add((ICapabilityProvider)next);
            }
            if (((IFluidPipe)te).getNetworkTrue() != null && ((IFluidPipe)te).getIsValidForForming() && ((IFluidPipe)te).getNetworkTrue().getType() == type && !networks.contains(((IFluidPipe)te).getNetwork())) {
                networks.add(((IFluidPipe)te).getNetwork());
            }
        }
        return new List[]{pipes, consumers, networks};
    }

    public static TileEntity getTileEntityAround(TileEntity te, int dir) {
        if (te == null) {
            return null;
        }
        switch (dir) {
            case 0: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177974_f());
            }
            case 1: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177976_e());
            }
            case 2: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177968_d());
            }
            case 3: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177978_c());
            }
            case 4: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177984_a());
            }
            case 5: {
                return te.func_145831_w().func_175625_s(te.func_174877_v().func_177977_b());
            }
        }
        return null;
    }

    public void Destroy() {
        this.fillables.clear();
        for (IFluidPipe pipe : this.pipes) {
            pipe.setNetwork(null);
        }
        this.pipes.clear();
        MainRegistry.allPipeNetworks.remove(this);
    }

    public void destroySoft() {
        this.fillables.clear();
        for (IFluidPipe pipe : this.pipes) {
            pipe.setNetwork(null);
        }
        this.pipes.clear();
    }

    public void setType(Fluid fluid) {
        for (IFluidPipe pipe : this.pipes) {
            pipe.setTypeTrue(fluid);
        }
        this.type = fluid;
    }

    public Fluid getType() {
        return this.type;
    }

    public boolean addPipe(IFluidPipe pipe) {
        if (pipe.getType() != null && pipe.getType() == this.getType()) {
            this.pipes.add(pipe);
            return this.pipes.add(pipe);
        }
        return false;
    }

    public boolean removePipe(IFluidPipe pipe) {
        if (this.pipes.contains(pipe)) {
            return this.pipes.remove(pipe);
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.internalNetworkTank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.type) {
            return this.internalNetworkTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.type) {
            return this.internalNetworkTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.internalNetworkTank.drain(maxDrain, doDrain);
    }
}

