/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.WasteLog;
import com.hbm.handler.ArmorUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ExplosionThermo {
    public static void freeze(World world, int x, int y, int z, int bombStartStrength) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength * 2;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ < r22 + world.field_73012_v.nextInt(r22 / 2)) {
                        pos.func_181079_c(X, Y, Z);
                    }
                    ExplosionThermo.freezeDest(world, (BlockPos)pos);
                }
            }
        }
    }

    public static void scorch(World world, int x, int y, int z, int bombStartStrength) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength * 2;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ < r22 + world.field_73012_v.nextInt(r22 / 2)) {
                        pos.func_181079_c(X, Y, Z);
                    }
                    ExplosionThermo.scorchDest(world, (BlockPos)pos);
                }
            }
        }
    }

    public static void scorchDest(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150349_c) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == ModBlocks.frozen_grass) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == Blocks.field_150346_d) {
            world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
        } else if (block == ModBlocks.frozen_dirt) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == Blocks.field_150424_aL) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else if (block == ModBlocks.frozen_log) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.waste_log).withSameRotationState(world.func_180495_p(pos)));
        } else if (block instanceof BlockLog) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(world.func_180495_p(pos)));
        } else if (block == ModBlocks.frozen_planks) {
            world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
        } else if (block == Blocks.field_150344_f) {
            world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
        } else if (block == Blocks.field_150348_b) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else if (block == Blocks.field_150347_e) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else if (block == Blocks.field_150417_aV) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else if (block == Blocks.field_150343_Z) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else if (block instanceof BlockLeaves) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150355_j) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150358_i) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150403_cj) {
            world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
        } else if (block == Blocks.field_150432_aD) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150433_aE) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150431_aC) {
            world.func_175698_g(pos);
        }
    }

    public static void freezeDest(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150349_c) {
            world.func_175656_a(pos, ModBlocks.frozen_grass.func_176223_P());
        } else if (block == Blocks.field_150346_d) {
            world.func_175656_a(pos, ModBlocks.frozen_dirt.func_176223_P());
        } else if (block == Blocks.field_150344_f) {
            world.func_175656_a(pos, ModBlocks.frozen_planks.func_176223_P());
        } else if (block == ModBlocks.waste_log) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.frozen_log).withSameRotationState(world.func_180495_p(pos)));
        } else if (block instanceof BlockLog) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.frozen_log).getSameRotationState(world.func_180495_p(pos)));
        } else if (block == ModBlocks.waste_planks) {
            world.func_175656_a(pos, ModBlocks.frozen_planks.func_176223_P());
        } else if (block == Blocks.field_150348_b) {
            world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (block == Blocks.field_150347_e) {
            world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (block == Blocks.field_150417_aV) {
            world.func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (block instanceof BlockLeaves) {
            world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
        } else if (block == Blocks.field_150353_l) {
            world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
        } else if (block == Blocks.field_150356_k) {
            world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
        } else if (block == Blocks.field_150355_j) {
            world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
        } else if (block == Blocks.field_150358_i) {
            world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
        }
    }

    public static void freezer(World world, int x, int y, int z, int bombStartStrength) {
        float f = bombStartStrength;
        double wat = bombStartStrength;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || entity instanceof EntityOcelot || !(entity instanceof EntityLivingBase)) continue;
            for (int a = (int)entity.field_70165_t - 2; a < (int)entity.field_70165_t + 1; ++a) {
                for (int b = (int)entity.field_70163_u; b < (int)entity.field_70163_u + 3; ++b) {
                    for (int c = (int)entity.field_70161_v - 1; c < (int)entity.field_70161_v + 2; ++c) {
                        pos.func_181079_c(a, b, c);
                        world.func_175656_a((BlockPos)pos, Blocks.field_150432_aD.func_176223_P());
                    }
                }
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2400, 4));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1800, 2));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 3600, 2));
        }
        bombStartStrength = (int)f;
    }

    public static void setEntitiesOnFire(World world, double x, double y, double z, int radius) {
        List list = world.func_72839_b(null, new AxisAlignedBB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius));
        for (Entity e : list) {
            if (!(e.func_70011_f(x, y, z) <= (double)radius) || e instanceof EntityPlayer && ArmorUtil.checkForAsbestos((EntityPlayer)e)) continue;
            if (e instanceof EntityLivingBase) {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 300, 4));
            }
            e.func_70015_d(10);
        }
    }

    public static void scorchLight(World world, int x, int y, int z, int bombStartStrength) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength * 2;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 2)) continue;
                    ExplosionThermo.scorchDestLight(world, (BlockPos)pos.func_181079_c(X, Y, Z));
                }
            }
        }
    }

    public static void scorchDestLight(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_150349_c) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == ModBlocks.frozen_grass) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == Blocks.field_150346_d) {
            world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
        } else if (block == ModBlocks.frozen_dirt) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (block == ModBlocks.waste_earth) {
            world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
        } else if (block == ModBlocks.frozen_log) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.waste_log).withSameRotationState(world.func_180495_p(pos)));
        } else if (block instanceof BlockLog) {
            world.func_175656_a(pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(world.func_180495_p(pos)));
        } else if (block == ModBlocks.frozen_planks) {
            world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
        } else if (block == Blocks.field_150344_f) {
            world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
        } else if (block == Blocks.field_150343_Z) {
            world.func_175656_a(pos, ModBlocks.gravel_obsidian.func_176223_P());
        } else if (block instanceof BlockLeaves) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150355_j) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150358_i) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150403_cj) {
            world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
        } else if (block == Blocks.field_150432_aD) {
            world.func_175698_g(pos);
        } else if (block == Blocks.field_150354_m) {
            world.func_175656_a(pos, Blocks.field_150359_w.func_176223_P());
        } else if (block == Blocks.field_150435_aG) {
            world.func_175656_a(pos, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.values()[world.field_73012_v.nextInt(16)]));
        }
    }

    public static void snow(World world, int x, int y, int z, int bound) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    pos.func_181079_c(X, Y + 1, Z);
                    if (!Blocks.field_150431_aC.func_176196_c(world, (BlockPos)pos) || world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a && world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150480_ab) continue;
                    world.func_175656_a((BlockPos)pos, Blocks.field_150431_aC.func_176223_P());
                }
            }
        }
    }
}

