/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.BombConfig;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExplosionNukeSmall {
    public static final int safe = 0;
    public static final int tots = 1;
    public static final int low = 2;
    public static final int medium = 3;
    public static final int high = 4;

    public static void explode(World world, double posX, double posY, double posZ, int size) {
        NBTTagCompound data = new NBTTagCompound();
        if (size == 1) {
            data.func_74778_a("type", "tinytot");
        } else {
            data.func_74778_a("type", "muke");
        }
        if (MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0) {
            data.func_74757_a("balefire", true);
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, posX, posY + 0.5, posZ), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), posX, posY, posZ, 250.0));
        world.func_184148_a(null, posX, posY, posZ, HBMSoundHandler.mukeExplosion, SoundCategory.HOSTILE, 15.0f, 1.0f);
        if (size != 4 && size != 1) {
            ExplosionLarge.spawnShrapnels(world, posX, posY, posZ, 25);
        }
        if (size == 0) {
            ExplosionNukeGeneric.dealDamage(world, posX, posY, posZ, 45.0);
        } else if (size > 0 && size < 4) {
            switch (size) {
                case 1: {
                    new ExplosionNT(world, null, posX, posY, posZ, 10.0f).addAllAttrib(ExplosionNT.nukeAttribs).overrideResolution(32).explode();
                    ExplosionNukeGeneric.dealDamage(world, posX, posY, posZ, 30.0);
                    break;
                }
                case 2: {
                    new ExplosionNT(world, null, posX, posY, posZ, 15.0f).addAllAttrib(ExplosionNT.nukeAttribs).overrideResolution(64).explode();
                    ExplosionNukeGeneric.dealDamage(world, posX, posY, posZ, 45.0);
                    break;
                }
                case 3: {
                    new ExplosionNT(world, null, posX, posY, posZ, 20.0f).addAllAttrib(ExplosionNT.nukeAttribs).overrideResolution(64).explode();
                    ExplosionNukeGeneric.dealDamage(world, posX, posY, posZ, 55.0);
                }
            }
        } else if (size == 4) {
            world.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(world, BombConfig.fatmanRadius, posX, posY, posZ).mute());
        }
        float radMod = (float)size * 0.33f;
        if (size == 0) {
            radMod = 0.66f;
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (i + j >= 4) continue;
                RadiationSavedData.incrementRad(world, new BlockPos((double)((int)posX + i * 16), posY, (double)((int)posZ + j * 16)), (float)(50 / (Math.abs(i) + Math.abs(j) + 1)) * radMod, 1000.0f);
            }
        }
    }
}

