/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.lib.Library;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionNukeRay {
    private int maxSamples;
    private double phi;
    public boolean isContained = true;
    World world;
    float posX;
    float posY;
    float posZ;
    int radius;
    int processed;
    int currentSample;
    private List<FloatTriplet> affectedBlocks = new ArrayList<FloatTriplet>();
    public boolean isAusf3Complete = false;
    public Random rand = new Random();

    public ExplosionNukeRay(World world, int x, int y, int z, int radius) {
        this.world = world;
        this.posX = (float)x + 0.5f;
        this.posY = (float)y + 0.5f;
        this.posZ = (float)z + 0.5f;
        this.radius = radius;
        this.currentSample = 0;
        this.maxSamples = (int)(Math.PI * 5 * Math.pow(radius, 2.0));
        this.phi = Math.PI * 2 * ((1.0 + Math.sqrt(5.0)) / 2.0);
    }

    public void collectTipMk6(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int raysProcessed = 0;
        FloatTriplet lastPos = new FloatTriplet(this.posX, this.posY, this.posZ);
        for (int s = this.currentSample; s < this.maxSamples; ++s) {
            FloatTriplet direction = this.getNormalFibVec(s);
            float rayEnergy = (float)this.radius * 0.7f;
            for (int l = 0; l < this.radius + 1; ++l) {
                float x0 = this.posX + direction.xCoord * (float)l;
                float y0 = this.posY + direction.yCoord * (float)l;
                float z0 = this.posZ + direction.zCoord * (float)l;
                if (y0 < 1.0f || y0 > 256.0f) {
                    if (this.affectedBlocks.size() >= 2147483547) break;
                    this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                    break;
                }
                pos.func_189532_c((double)x0, (double)y0, (double)z0);
                rayEnergy = (float)((double)rayEnergy - Math.pow(this.getNukeResistance(pos), 7.0f * (float)(l / this.radius) + 0.5f));
                if (rayEnergy > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(rayEnergy <= 0.0f) && l != this.radius) continue;
                if (this.isContained && l == this.radius) {
                    this.isContained = false;
                }
                if (this.affectedBlocks.size() >= 2147483547) break;
                this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                break;
            }
            if (++raysProcessed < count) continue;
            this.currentSample = s;
            return;
        }
        this.isAusf3Complete = true;
    }

    private float getNukeResistance(BlockPos.MutableBlockPos pos) {
        if (this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d()) {
            return 0.1f;
        }
        return this.world.func_180495_p((BlockPos)pos).func_177230_c().func_149638_a(null) + 0.1f;
    }

    private FloatTriplet getNormalFibVec(int sample) {
        double angle1 = Math.acos((double)sample * 2.0 / (double)this.maxSamples - 1.0);
        double angle2 = this.phi * (double)sample;
        double x = Math.sin(angle1) * Math.cos(angle2);
        double y = Math.cos(angle1);
        double z = Math.sin(angle1) * Math.sin(angle2);
        return new FloatTriplet((float)x, (float)y, (float)z);
    }

    public void processTip(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int processedBlocks = 0;
        int braker = 0;
        for (int l = 0; l < Integer.MAX_VALUE; ++l) {
            if (processedBlocks >= count) {
                return;
            }
            if (braker >= count * 50) {
                return;
            }
            if (l > this.affectedBlocks.size() - 1) break;
            if (this.affectedBlocks.isEmpty()) {
                return;
            }
            int in = this.affectedBlocks.size() - 1;
            float x = this.affectedBlocks.get((int)in).xCoord;
            float y = this.affectedBlocks.get((int)in).yCoord;
            float z = this.affectedBlocks.get((int)in).zCoord;
            pos.func_189532_c((double)x, (double)y, (double)z);
            this.world.func_175698_g((BlockPos)pos);
            Vec3 vec = Vec3.createVectorHelper(x - this.posX, y - this.posY, z - this.posZ);
            double pX = vec.xCoord / vec.lengthVector();
            double pY = vec.yCoord / vec.lengthVector();
            double pZ = vec.zCoord / vec.lengthVector();
            int i = 0;
            while ((double)i < vec.lengthVector()) {
                int x0 = (int)((double)this.posX + pX * (double)i);
                int y0 = (int)((double)this.posY + pY * (double)i);
                int z0 = (int)((double)this.posZ + pZ * (double)i);
                pos.func_181079_c(x0, y0, z0);
                if (!this.world.func_175623_d((BlockPos)pos)) {
                    this.world.func_175698_g((BlockPos)pos);
                    this.world.func_180497_b((BlockPos)pos, this.world.func_180495_p((BlockPos)pos).func_177230_c(), 0, 0);
                    ++processedBlocks;
                }
                ++braker;
                ++i;
            }
            this.affectedBlocks.remove(in);
        }
        this.processed += count;
    }

    public void collectTip(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int k = 0; k < count; ++k) {
            double phi = this.rand.nextDouble() * (Math.PI * 2);
            double costheta = this.rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = Vec3.createVectorHelper(x, y, z);
            int length = (int)Math.ceil(this.radius);
            float res = this.radius;
            FloatTriplet lastPos = null;
            Explosion dummy = Library.explosionDummy(this.world, x, y, z);
            for (int i = 0; i < length && i <= this.radius; ++i) {
                float x0 = (float)((double)this.posX + vec.xCoord * (double)i);
                float y0 = (float)((double)this.posY + vec.yCoord * (double)i);
                float z0 = (float)((double)this.posZ + vec.zCoord * (double)i);
                pos.func_189532_c((double)x0, (double)y0, (double)z0);
                res = !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_180495_p((BlockPos)pos).func_177230_c().getExplosionResistance(this.world, (BlockPos)pos, null, dummy), 1.25)) : (float)((double)res - Math.pow(Blocks.field_150350_a.getExplosionResistance(this.world, (BlockPos)pos, null, dummy), 1.25));
                if (res > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(res <= 0.0f) && i + 1 < this.radius) continue;
                if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) continue block0;
                this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                continue block0;
            }
        }
    }

    public void collectTipExperimental(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int k = 0; k < count; ++k) {
            double phi = this.rand.nextDouble() * (Math.PI * 2);
            double costheta = this.rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = Vec3.createVectorHelper(x, y, z);
            int length = (int)Math.ceil(this.radius);
            float res = this.radius;
            FloatTriplet lastPos = null;
            for (int i = 0; i < length && i <= this.radius; ++i) {
                float x0 = (float)((double)this.posX + vec.xCoord * (double)i);
                float y0 = (float)((double)this.posY + vec.yCoord * (double)i);
                float z0 = (float)((double)this.posZ + vec.zCoord * (double)i);
                pos.func_189532_c((double)x0, (double)y0, (double)z0);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                res = !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_180495_p((BlockPos)pos).func_177230_c().func_149638_a(null), 7.5 - fac)) : (float)((double)res - Math.pow(Blocks.field_150350_a.func_149638_a(null), 7.5 - (fac *= 0.07)));
                if (res > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(res <= 0.0f) && i + 1 < this.radius) continue;
                if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) continue block0;
                this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                continue block0;
            }
        }
    }

    public void deleteStorage() {
        this.affectedBlocks.clear();
    }

    public int getStoredSize() {
        return this.affectedBlocks.size();
    }

    public int getProgress() {
        return this.processed;
    }

    public class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }
}

