/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import api.hbm.energy.IEnergyUser;
import cofh.redstoneflux.api.IEnergyProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.WasteLog;
import com.hbm.config.VersatileConfig;
import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.grenade.EntityGrenadeASchrab;
import com.hbm.entity.grenade.EntityGrenadeNuclear;
import com.hbm.entity.missile.EntityMIRV;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.entity.projectile.EntityExplosiveBeam;
import com.hbm.entity.projectile.EntityMiniMIRV;
import com.hbm.entity.projectile.EntityMiniNuke;
import com.hbm.handler.ArmorUtil;
import com.hbm.interfaces.Spaghetti;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.logging.log4j.Level;

public class ExplosionNukeGeneric {
    private static final Random random = new Random();
    public static Map<Block, Block> soliniumConfig = new HashMap<Block, Block>();

    public static void empBlast(World world, int x, int y, int z, int bombStartStrength) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    pos.func_181079_c(X, Y, Z);
                    ExplosionNukeGeneric.emp(world, (BlockPos)pos);
                }
            }
        }
    }

    public static void dealDamage(World world, double x, double y, double z, double radius) {
        ExplosionNukeGeneric.dealDamage(world, x, y, z, radius, 250.0f);
    }

    public static void dealDamage(World world, double x, double y, double z, double radius, float maxDamage) {
        List list = world.func_72839_b(null, new AxisAlignedBB(x, y, z, x, y, z).func_72314_b(radius, radius, radius));
        for (Entity e : list) {
            double dist = e.func_70011_f(x, y, z);
            if (!(dist <= radius)) continue;
            double entX = e.field_70165_t;
            double entY = e.field_70163_u + (double)e.func_70047_e();
            double entZ = e.field_70161_v;
            if (ExplosionNukeGeneric.isExplosionExempt(e) || Library.isObstructed(world, x, y, z, entX, entY, entZ)) continue;
            double damage = (double)maxDamage * (radius - dist) / radius;
            e.func_70097_a(ModDamageSource.nuclearBlast, (float)damage);
            e.func_70015_d(5);
            double knockX = e.field_70165_t - x;
            double knockY = e.field_70163_u + (double)e.func_70047_e() - y;
            double knockZ = e.field_70161_v - z;
            Vec3d knock = new Vec3d(knockX, knockY, knockZ);
            knock = knock.func_72432_b();
            e.field_70159_w += knock.field_72450_a * 0.2;
            e.field_70181_x += knock.field_72448_b * 0.2;
            e.field_70179_y += knock.field_72449_c * 0.2;
        }
    }

    @Spaghetti(value="just look at it")
    private static boolean isExplosionExempt(Entity e) {
        if (e instanceof EntityOcelot || e instanceof EntityNukeCloudSmall || e instanceof EntityMIRV || e instanceof EntityMiniNuke || e instanceof EntityMiniMIRV || e instanceof EntityGrenadeASchrab || e instanceof EntityGrenadeNuclear || e instanceof EntityExplosiveBeam || e instanceof EntityBulletBase || e instanceof EntityPlayer && ArmorUtil.checkArmor((EntityPlayer)e, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots)) {
            return true;
        }
        return e instanceof EntityPlayerMP && (((EntityPlayerMP)e).func_184812_l_() || ((EntityPlayerMP)e).func_175149_v());
    }

    public static void succ(World world, int x, int y, int z, int radius) {
        double wat = radius;
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            double d4;
            Entity entity = (Entity)list.get(i1);
            if (entity instanceof EntityBlackHole || !((d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius) <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || entity instanceof EntityPlayer && ArmorUtil.checkArmor((EntityPlayer)entity, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots)) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
            double d8 = 0.125 + random.nextDouble() * 0.25;
            entity.field_70159_w -= d5 * d8;
            entity.field_70181_x -= d6 * d8;
            entity.field_70179_y -= d7 * d8;
        }
    }

    public static boolean dedify(World world, int x, int y, int z, int radius) {
        double wat = radius;
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || entity instanceof EntityPlayer && ArmorUtil.checkArmor((EntityPlayer)entity, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots)) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            if (entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() == ModItems.flame_pony) {
                entity.func_70106_y();
                return true;
            }
            if (entity instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() == ModItems.pellet_antimatter) {
                entity.func_70106_y();
                return true;
            }
            if (!(entity instanceof EntityPlayerMP) || ((EntityPlayerMP)entity).field_71134_c.func_73081_b() != GameType.CREATIVE) {
                entity.func_70097_a(ModDamageSource.blackhole, 1000.0f);
            }
            if (entity instanceof EntityLivingBase || entity instanceof EntityPlayerMP || entity instanceof EntityBlackHole || random.nextInt(8) != 0) continue;
            entity.func_70106_y();
        }
        return false;
    }

    public static int destruction(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState b = world.func_180495_p(pos);
            if (b.func_177230_c().func_149638_a(null) >= 200.0f) {
                int protection = (int)(b.func_177230_c().func_149638_a(null) / 300.0f);
                if (b.func_177230_c() == ModBlocks.brick_concrete) {
                    int rand = random.nextInt(8);
                    if (rand == 0) {
                        world.func_180501_a(pos, Blocks.field_150351_n.func_176223_P(), 3);
                        return 0;
                    }
                } else if (b.func_177230_c() == ModBlocks.brick_light) {
                    int rand = random.nextInt(3);
                    if (rand == 0) {
                        world.func_180501_a(pos, ModBlocks.waste_planks.func_176223_P(), 3);
                        return 0;
                    }
                    if (rand == 1) {
                        world.func_175656_a(pos, ModBlocks.block_scrap.func_176223_P());
                        return 0;
                    }
                } else if (b.func_177230_c() == ModBlocks.brick_obsidian) {
                    int rand = random.nextInt(20);
                    if (rand == 0) {
                        world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                    }
                } else {
                    if (b.func_177230_c() == Blocks.field_150343_Z) {
                        world.func_180501_a(pos, ModBlocks.gravel_obsidian.func_176223_P(), 3);
                        return 0;
                    }
                    if (random.nextInt(protection + 3) == 0) {
                        world.func_175656_a(pos, ModBlocks.block_scrap.func_176223_P());
                    }
                }
                return protection;
            }
            world.func_175698_g(pos);
        }
        return 0;
    }

    public static int vaporDest(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState b = world.func_180495_p(pos);
            if (b.func_177230_c().func_149638_a(null) < 0.5f || b.func_177230_c() == Blocks.field_150321_G || b.func_177230_c() == ModBlocks.red_cable || b.func_177230_c() instanceof BlockLiquid) {
                world.func_175698_g(pos);
                return 0;
            }
            if (b.func_177230_c().func_149638_a(null) <= 3.0f && !b.func_185914_p() && b.func_177230_c() != Blocks.field_150486_ae && b.func_177230_c() != Blocks.field_150458_ak) {
                world.func_175698_g(pos);
                return 0;
            }
            if (b.func_177230_c().isFlammable((IBlockAccess)world, pos, EnumFacing.UP) && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                world.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
            }
            return (int)(b.func_177230_c().func_149638_a(null) / 300.0f);
        }
        return 0;
    }

    public static void waste(World world, int x, int y, int z, int radius) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 5) || world.func_180495_p((BlockPos)pos.func_181079_c(X, Y, Z)).func_177230_c() == Blocks.field_150350_a) continue;
                    ExplosionNukeGeneric.wasteDest(world, (BlockPos)pos);
                }
            }
        }
    }

    public static void wasteDest(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState bs = world.func_180495_p(pos);
            Block b = bs.func_177230_c();
            if (b == Blocks.field_150350_a) {
                return;
            }
            if (b == Blocks.field_180410_as || b == Blocks.field_180412_aq || b == Blocks.field_180409_at || b == Blocks.field_180411_ar || b == Blocks.field_180413_ao || b == Blocks.field_180414_ap || b == Blocks.field_150454_av) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (b == Blocks.field_150349_c) {
                world.func_175656_a(pos, ModBlocks.waste_earth.func_176223_P());
            } else if (b == Blocks.field_150391_bh) {
                world.func_175656_a(pos, ModBlocks.waste_mycelium.func_176223_P());
            } else if (b == Blocks.field_150354_m) {
                int rand = random.nextInt(20);
                if (rand == 1 && bs.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
                    world.func_175656_a(pos, ModBlocks.waste_trinitite.func_176223_P());
                }
                if (rand == 1 && bs.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
                    world.func_175656_a(pos, ModBlocks.waste_trinitite_red.func_176223_P());
                }
            } else if (b == Blocks.field_150435_aG) {
                world.func_175656_a(pos, Blocks.field_150405_ch.func_176223_P());
            } else if (b == Blocks.field_150341_Y) {
                world.func_175656_a(pos, Blocks.field_150365_q.func_176223_P());
            } else if (b == Blocks.field_150365_q) {
                int rand = random.nextInt(10);
                if (rand == 1 || rand == 2 || rand == 3) {
                    world.func_175656_a(pos, Blocks.field_150482_ag.func_176223_P());
                }
                if (rand == 9) {
                    world.func_175656_a(pos, Blocks.field_150412_bA.func_176223_P());
                }
            } else if (b instanceof BlockLog) {
                world.func_175656_a(pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(bs));
            } else if (b == Blocks.field_150420_aW) {
                if (bs.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a) == BlockHugeMushroom.EnumType.STEM) {
                    world.func_175656_a(pos, ModBlocks.waste_log.func_176223_P());
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            } else if (b == Blocks.field_150346_d) {
                world.func_175656_a(pos, ModBlocks.waste_dirt.func_176223_P());
            } else if (b == Blocks.field_150431_aC) {
                world.func_175656_a(pos, ModBlocks.fallout.func_176223_P());
            } else if (b == Blocks.field_150433_aE) {
                world.func_175656_a(pos, ModBlocks.block_fallout.func_176223_P());
            } else if (b instanceof BlockBush || b == Blocks.field_150329_H) {
                world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
            } else if (b == Blocks.field_150348_b) {
                world.func_175656_a(pos, ModBlocks.sellafield_slaked.func_176223_P());
            } else if (b == Blocks.field_150357_h) {
                world.func_175656_a(pos.func_177982_a(0, 1, 0), ModBlocks.toxic_block.func_176223_P());
            } else if (b == Blocks.field_150419_aX) {
                if (bs.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a) == BlockHugeMushroom.EnumType.STEM) {
                    world.func_175656_a(pos, ModBlocks.waste_log.func_176223_P());
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            } else if (bs.func_185904_a() == Material.field_151575_d && bs.func_185914_p() && b != ModBlocks.waste_log) {
                world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
            } else if (b == ModBlocks.ore_uranium) {
                int rand = random.nextInt(VersatileConfig.getSchrabOreChance());
                if (rand == 1) {
                    world.func_175656_a(pos, ModBlocks.ore_schrabidium.func_176223_P());
                } else {
                    world.func_175656_a(pos, ModBlocks.ore_uranium_scorched.func_176223_P());
                }
            } else if (b == ModBlocks.ore_nether_uranium) {
                int rand = random.nextInt(VersatileConfig.getSchrabOreChance());
                if (rand == 1) {
                    world.func_175656_a(pos, ModBlocks.ore_nether_schrabidium.func_176223_P());
                } else {
                    world.func_175656_a(pos, ModBlocks.ore_nether_uranium_scorched.func_176223_P());
                }
            } else if (b == ModBlocks.ore_gneiss_uranium) {
                int rand = random.nextInt(VersatileConfig.getSchrabOreChance());
                if (rand == 1) {
                    world.func_175656_a(pos, ModBlocks.ore_gneiss_schrabidium.func_176223_P());
                } else {
                    world.func_175656_a(pos, ModBlocks.ore_gneiss_uranium_scorched.func_176223_P());
                }
            }
        }
    }

    public static void wasteNoSchrab(World world, BlockPos pos, int radius) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(pos);
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 5)) continue;
                    mpos.func_181079_c(X, Y, Z);
                    if (world.func_180495_p((BlockPos)mpos).func_177230_c() == Blocks.field_150350_a) continue;
                    ExplosionNukeGeneric.wasteDestNoSchrab(world, (BlockPos)mpos);
                }
            }
        }
    }

    public static void wasteDestNoSchrab(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            Block b = world.func_180495_p(pos).func_177230_c();
            if (b == Blocks.field_150350_a) {
                return;
            }
            if (b == Blocks.field_150359_w || b == Blocks.field_150399_cn || b == Blocks.field_180410_as || b == Blocks.field_180412_aq || b == Blocks.field_180409_at || b == Blocks.field_180411_ar || b == Blocks.field_180413_ao || b == Blocks.field_180414_ap || b == Blocks.field_150454_av || b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
                world.func_175698_g(pos);
            } else if (b == Blocks.field_150349_c) {
                world.func_175656_a(pos, ModBlocks.waste_earth.func_176223_P());
            } else if (b == Blocks.field_150391_bh) {
                world.func_175656_a(pos, ModBlocks.waste_mycelium.func_176223_P());
            } else if (b == Blocks.field_150354_m) {
                int rand = random.nextInt(20);
                if (rand == 1 && world.func_180495_p(pos).func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
                    world.func_175656_a(pos, ModBlocks.waste_trinitite.func_176223_P());
                } else if (rand == 1 && world.func_180495_p(pos).func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
                    world.func_175656_a(pos, ModBlocks.waste_trinitite_red.func_176223_P());
                }
            } else if (b == Blocks.field_150435_aG) {
                world.func_175656_a(pos, Blocks.field_150405_ch.func_176223_P());
            } else if (b == Blocks.field_150346_d) {
                world.func_175656_a(pos, ModBlocks.waste_dirt.func_176223_P());
            } else if (b == Blocks.field_150431_aC) {
                world.func_175656_a(pos, ModBlocks.fallout.func_176223_P());
            } else if (b == Blocks.field_150433_aE) {
                world.func_175656_a(pos, ModBlocks.block_fallout.func_176223_P());
            } else if (b instanceof BlockBush || b == Blocks.field_150329_H) {
                world.func_175656_a(pos, Blocks.field_150330_I.func_176223_P());
            } else if (b == Blocks.field_150348_b) {
                world.func_175656_a(pos, ModBlocks.sellafield_slaked.func_176223_P());
            } else if (b == Blocks.field_150357_h) {
                world.func_175656_a(pos.func_177982_a(0, 1, 0), ModBlocks.toxic_block.func_176223_P());
            } else if (b == Blocks.field_150341_Y) {
                world.func_175656_a(pos, Blocks.field_150365_q.func_176223_P());
            } else if (b == Blocks.field_150365_q) {
                int rand = random.nextInt(30);
                if (rand == 1 || rand == 2 || rand == 3) {
                    world.func_175656_a(pos, Blocks.field_150482_ag.func_176223_P());
                }
                if (rand == 29) {
                    world.func_175656_a(pos, Blocks.field_150412_bA.func_176223_P());
                }
            } else if (b == Blocks.field_150364_r || b == Blocks.field_150363_s) {
                world.func_175656_a(pos, ModBlocks.waste_log.func_176223_P());
            } else if (b == Blocks.field_150344_f) {
                world.func_175656_a(pos, ModBlocks.waste_planks.func_176223_P());
            } else if (b == Blocks.field_150420_aW) {
                if (world.func_180495_p(pos).func_177229_b((IProperty)BlockHugeMushroom.field_176380_a) == BlockHugeMushroom.EnumType.STEM) {
                    world.func_175656_a(pos, ModBlocks.waste_log.func_176223_P());
                } else {
                    world.func_175698_g(pos);
                }
            } else if (b == Blocks.field_150419_aX) {
                if (world.func_180495_p(pos).func_177229_b((IProperty)BlockHugeMushroom.field_176380_a) == BlockHugeMushroom.EnumType.STEM) {
                    world.func_175656_a(pos, ModBlocks.waste_log.func_176223_P());
                } else {
                    world.func_175698_g(pos);
                }
            }
        }
    }

    public static void emp(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            Block b = world.func_180495_p(pos).func_177230_c();
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof IEnergyUser) {
                ((IEnergyUser)te).setPower(0L);
                if (random.nextInt(5) < 1) {
                    world.func_175656_a(pos, ModBlocks.block_electrical_scrap.func_176223_P());
                }
            }
            if (te != null && te instanceof IEnergyProvider) {
                ((IEnergyProvider)te).extractEnergy(EnumFacing.UP, ((IEnergyProvider)te).getEnergyStored(EnumFacing.UP), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.DOWN, ((IEnergyProvider)te).getEnergyStored(EnumFacing.DOWN), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.NORTH, ((IEnergyProvider)te).getEnergyStored(EnumFacing.NORTH), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.SOUTH, ((IEnergyProvider)te).getEnergyStored(EnumFacing.SOUTH), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.EAST, ((IEnergyProvider)te).getEnergyStored(EnumFacing.EAST), false);
                ((IEnergyProvider)te).extractEnergy(EnumFacing.WEST, ((IEnergyProvider)te).getEnergyStored(EnumFacing.WEST), false);
                if (random.nextInt(5) <= 1) {
                    world.func_175656_a(pos, ModBlocks.block_electrical_scrap.func_176223_P());
                }
            }
            if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage handle = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
                handle.extractEnergy(handle.getEnergyStored(), false);
                if (random.nextInt(5) <= 1) {
                    world.func_175656_a(pos, ModBlocks.block_electrical_scrap.func_176223_P());
                }
            }
            if ((b == ModBlocks.fusion_conductor || b == ModBlocks.fwatz_conductor || b == ModBlocks.fusion_motor || b == ModBlocks.fusion_heater || b == ModBlocks.fwatz_computer) && random.nextInt(10) == 0) {
                world.func_175656_a(pos, ModBlocks.block_electrical_scrap.func_176223_P());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSoliniumFromFile() {
        File config = new File(MainRegistry.proxy.getDataDir().getPath() + "/config/hbm/solinium.cfg");
        if (!config.exists()) {
            try {
                config.getParentFile().mkdirs();
                FileWriter write = new FileWriter(config);
                write.write("# Format: modid:blockName|modid:blockName\n# Left blocks are transformed to right, one per line\n");
                write.close();
            }
            catch (IOException e) {
                MainRegistry.logger.log(Level.ERROR, "ERROR: Could not create config file: " + config.getAbsolutePath());
                e.printStackTrace();
                return;
            }
        }
        if (config.exists()) {
            BufferedReader read = null;
            int lineCount = 0;
            try {
                read = new BufferedReader(new FileReader(config));
                String currentLine = null;
                while ((currentLine = read.readLine()) != null) {
                    String[] blocks;
                    ++lineCount;
                    if (currentLine.startsWith("#") || currentLine.length() == 0 || (blocks = currentLine.trim().split("|")).length != 2) continue;
                    String[] modidBlock1 = blocks[0].split(":");
                    String[] modidBlock2 = blocks[1].split(":");
                    Block b1 = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modidBlock1[0], modidBlock1[1]));
                    Block b2 = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(modidBlock2[0], modidBlock2[1]));
                    if (b1 == null || b2 == null) {
                        MainRegistry.logger.log(Level.ERROR, "Failed to find block for solinium config on line: " + lineCount);
                        continue;
                    }
                    soliniumConfig.put(b1, b2);
                }
            }
            catch (FileNotFoundException e) {
                MainRegistry.logger.log(Level.ERROR, "Could not find solinium config file! This should never happen.");
                e.printStackTrace();
            }
            catch (IOException e) {
                MainRegistry.logger.log(Level.ERROR, "Error reading solinium config!");
                e.printStackTrace();
            }
            finally {
                if (read != null) {
                    try {
                        read.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public static void solinium(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState b = world.func_180495_p(pos);
            Material m = b.func_185904_a();
            if (soliniumConfig.containsKey(b.func_177230_c())) {
                world.func_175656_a(pos, soliniumConfig.get(b.func_177230_c()).func_176223_P());
                return;
            }
            if (b.func_177230_c() == Blocks.field_150349_c || b.func_177230_c() == Blocks.field_150346_d || b.func_177230_c() == Blocks.field_150391_bh || b.func_177230_c() == ModBlocks.waste_earth || b.func_177230_c() == ModBlocks.waste_dirt || b.func_177230_c() == ModBlocks.waste_mycelium) {
                if (random.nextInt(5) < 2) {
                    world.func_175656_a(pos, Blocks.field_150346_d.func_176203_a(1));
                } else {
                    world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                }
                return;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_slaked) {
                world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
                return;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_0 || b.func_177230_c() == ModBlocks.sellafield_1) {
                world.func_175656_a(pos, Blocks.field_150348_b.func_176203_a(5));
                return;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_2 || b.func_177230_c() == ModBlocks.sellafield_3) {
                world.func_175656_a(pos, Blocks.field_150348_b.func_176203_a(3));
                return;
            }
            if (b.func_177230_c() == ModBlocks.sellafield_4 || b.func_177230_c() == ModBlocks.sellafield_core) {
                world.func_175656_a(pos, Blocks.field_150348_b.func_176203_a(1));
                return;
            }
            if (b.func_177230_c() == ModBlocks.waste_trinitite || b.func_177230_c() == ModBlocks.waste_sand) {
                world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
                return;
            }
            if (b.func_177230_c() == ModBlocks.waste_trinitite_red) {
                world.func_175656_a(pos, Blocks.field_150354_m.func_176203_a(1));
                return;
            }
            if (b.func_177230_c() == ModBlocks.waste_gravel) {
                world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
                return;
            }
            if (b.func_177230_c() == ModBlocks.taint) {
                world.func_175656_a(pos, ModBlocks.stone_gneiss.func_176223_P());
                return;
            }
            if (m == Material.field_151570_A || m == Material.field_151589_v || m == Material.field_151584_j || m == Material.field_151585_k || m == Material.field_151583_m || m == Material.field_151582_l || m == Material.field_151572_C || m == Material.field_151575_d) {
                world.func_175698_g(pos);
            }
        }
    }
}

