/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.explosion.ExplosionNukeGeneric;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExplosionNukeAdvanced {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    public float explosionCoefficient = 1.0f;
    public int type = 0;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
        nbt.func_74776_a(name + "explosionCoefficient", this.explosionCoefficient);
        nbt.func_74768_a(name + "type", this.type);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = nbt.func_74762_e(name + "n");
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
        this.explosionCoefficient = nbt.func_74760_g(name + "explosionCoefficient");
        this.type = nbt.func_74762_e(name + "type");
    }

    public ExplosionNukeAdvanced(int x, int y, int z, World world, int rad, float coefficient, int typ) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.explosionCoefficient = Math.min(Math.max(((float)rad + coefficient * (float)(y - 60)) / (coefficient * (float)rad), 1.0f / coefficient), 1.0f);
        this.type = typ;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        switch (this.type) {
            case 0: {
                this.breakColumn(this.lastposX, this.lastposZ);
                break;
            }
            case 1: {
                this.vapor(this.lastposX, this.lastposZ);
                break;
            }
            case 2: {
                this.waste(this.lastposX, this.lastposZ);
            }
        }
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int y = dist = (int)Math.sqrt(dist);
            while ((float)y > (float)(-dist) * this.explosionCoefficient) {
                pos.func_181079_c(this.posX + x, this.posY + y, this.posZ + z);
                if (y < 8) {
                    y -= ExplosionNukeGeneric.destruction(this.worldObj, (BlockPos)pos);
                } else {
                    ExplosionNukeGeneric.destruction(this.worldObj, (BlockPos)pos);
                }
                --y;
            }
        }
    }

    private void vapor(int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int y = dist = (int)Math.sqrt(dist);
            while ((float)y > (float)(-dist) * this.explosionCoefficient) {
                pos.func_181079_c(this.posX + x, this.posY + y, this.posZ + z);
                y -= ExplosionNukeGeneric.vaporDest(this.worldObj, (BlockPos)pos);
                --y;
            }
        }
    }

    private void waste(int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int y = dist = (int)Math.sqrt(dist);
            while ((float)y > (float)(-dist) * this.explosionCoefficient) {
                pos.func_181079_c(this.posX + x, this.posY + y, this.posZ + z);
                if (this.radius >= 95) {
                    ExplosionNukeGeneric.wasteDest(this.worldObj, (BlockPos)pos);
                } else {
                    ExplosionNukeGeneric.wasteDestNoSchrab(this.worldObj, (BlockPos)pos);
                }
                --y;
            }
        }
    }
}

