/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.particle.EntityTSmokeFX;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityRocketHoming
extends Entity
implements IProjectile {
    public static final DataParameter<Boolean> CRITICAL = EntityDataManager.func_187226_a(EntityMissileBaseAdvanced.class, (DataSerializer)DataSerializers.field_187198_h);
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    public double gravity = 0.0;
    private Block field_145790_g;
    private int inData;
    private boolean inGround;
    public int canBePickedUp;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    private double damage = 2.0;
    private int knockbackStrength;
    public int homingRadius = 35;
    public int homingMod = 15;
    public float acceptance = 120.0f;
    int lockonTicks = 0;
    boolean hasBeeped = false;

    public EntityRocketHoming(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            EntityRocketHoming.func_184227_b((double)10.0);
        }
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityRocketHoming(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityRocketHoming(World world, EntityLivingBase shooter, EntityLivingBase shootingAt, float velocity, float inaccuracy) {
        this(world);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = shootingAt.field_70165_t - shooter.field_70165_t;
        double d1 = shootingAt.func_174813_aQ().field_72338_b + (double)(shootingAt.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = shootingAt.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, velocity, inaccuracy);
        }
    }

    public EntityRocketHoming(World world, EntityLivingBase shooter, float velocity, EnumHand hand) {
        this(world);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
    }

    public EntityRocketHoming(World world, int x, int y, int z, double mx, double my, double mz, double grav) {
        this(world);
        this.field_70165_t = (float)x + 0.5f;
        this.field_70163_u = (float)y + 0.5f;
        this.field_70161_v = (float)z + 0.5f;
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        this.gravity = grav;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CRITICAL, (Object)Boolean.FALSE);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        BlockPos pos;
        IBlockState blockstate;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        }
        if ((blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).func_185904_a() != Material.field_151579_a && (axisalignedbb = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, pos)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            if (!this.field_70170_p.field_72995_K) {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
            }
            this.func_70106_y();
        } else {
            float f1;
            ++this.ticksInAir;
            Vec3d vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec3 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.shootingEntity && this.ticksInAir < 5) continue;
                f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)f1);
                RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vec31, vec3);
                if (movingobjectposition1 == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null) {
                if (movingobjectposition.field_72308_g != null) {
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    int k = MathHelper.func_76143_f((double)((double)f2 * this.damage));
                    if (this.getIsCritical()) {
                        k += this.field_70146_Z.nextInt(k / 2 + 2);
                    }
                    DamageSource damagesource = null;
                    damagesource = this.shootingEntity == null ? DamageSource.func_76354_b((Entity)this, (Entity)this) : DamageSource.func_76354_b((Entity)this, (Entity)this);
                    if (this.func_70027_ad() && !(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                        movingobjectposition.field_72308_g.func_70015_d(5);
                    }
                    if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)k)) {
                        if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                            float f4;
                            EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                            if (this.knockbackStrength > 0 && (f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                movingobjectposition.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f4, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f4);
                            }
                            if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                                EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                            }
                            if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                            }
                        }
                        if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                            if (!this.field_70170_p.field_72995_K) {
                                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
                            }
                            this.func_70106_y();
                        }
                    } else {
                        if (!this.field_70170_p.field_72995_K) {
                            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
                        }
                        this.func_70106_y();
                    }
                } else {
                    Block block1;
                    this.field_145791_d = movingobjectposition.func_178782_a().func_177958_n();
                    this.field_145792_e = movingobjectposition.func_178782_a().func_177956_o();
                    this.field_145789_f = movingobjectposition.func_178782_a().func_177952_p();
                    BlockPos newPos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                    IBlockState state1 = this.field_70170_p.func_180495_p(newPos);
                    this.field_145790_g = block1 = state1.func_177230_c();
                    this.inData = block1.func_176201_c(state1);
                    this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.setIsCritical(false);
                    if (state1.func_185904_a() != Material.field_151579_a) {
                        this.field_145790_g.func_180634_a(this.field_70170_p, newPos, state1, (Entity)this);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 1) {
                this.field_70170_p.func_72838_d((Entity)new EntityTSmokeFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0));
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            f1 = 0.05f;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (!this.steer()) {
            this.lockonTicks = 0;
        }
        if (this.field_70173_aa > 250) {
            this.func_70106_y();
        }
    }

    private boolean steer() {
        List all = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - (double)this.homingRadius, this.field_70163_u - (double)this.homingRadius, this.field_70161_v - (double)this.homingRadius, this.field_70165_t + (double)this.homingRadius, this.field_70163_u + (double)this.homingRadius, this.field_70161_v + (double)this.homingRadius));
        HashMap<Entity, Double> targetable = new HashMap<Entity, Double>();
        Vec3d path = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        double startSpeed = path.func_72433_c();
        path.func_72432_b();
        if (all.isEmpty()) {
            return false;
        }
        for (Entity e : all) {
            Vec3d rel;
            if (e == this.shootingEntity) continue;
            double vecProd = rel.field_72450_a * path.field_72450_a + rel.field_72448_b * path.field_72448_b + rel.field_72449_c * path.field_72449_c;
            rel = new Vec3d(e.field_70165_t - this.field_70165_t, e.field_70163_u + (double)e.func_70047_e() - this.field_70163_u, e.field_70161_v - this.field_70161_v);
            double bot = rel.func_72433_c() * path.func_72433_c();
            double angle = Math.acos(vecProd / bot) * 180.0 / Math.PI;
            if (angle <= (double)this.acceptance) {
                // empty if block
            }
            if (!((double)(e.field_70131_O * e.field_70130_N * e.field_70130_N) >= 0.5) || Library.isObstructed(this.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v)) continue;
            targetable.put(e, angle);
        }
        if (targetable.isEmpty()) {
            return false;
        }
        double smallest = Double.POSITIVE_INFINITY;
        Entity nearestE = null;
        for (Map.Entry entry : targetable.entrySet()) {
            if (!((Double)entry.getValue() < smallest)) continue;
            smallest = (Double)entry.getValue();
            nearestE = (Entity)entry.getKey();
        }
        if (nearestE == null) {
            return false;
        }
        Vec3d winVec = new Vec3d(nearestE.field_70165_t - this.field_70165_t, nearestE.field_70163_u - this.field_70163_u, nearestE.field_70161_v - this.field_70161_v);
        winVec.func_72432_b();
        double newX = (path.field_72450_a * (smallest * (double)this.homingMod - 1.0) + winVec.field_72450_a) / (smallest * (double)this.homingMod);
        double newY = (path.field_72448_b * (smallest * (double)this.homingMod - 1.0) + winVec.field_72448_b) / (smallest * (double)this.homingMod);
        double newZ = (path.field_72449_c * (smallest * (double)this.homingMod - 1.0) + winVec.field_72449_c) / (smallest * (double)this.homingMod);
        Vec3d newPath = new Vec3d(newX, newY, newZ);
        newPath.func_72432_b();
        newPath = new Vec3d(newPath.field_72450_a * startSpeed, newPath.field_72448_b * startSpeed, newPath.field_72449_c * startSpeed);
        this.field_70159_w = newPath.field_72450_a;
        this.field_70181_x = newPath.field_72448_b;
        this.field_70179_y = newPath.field_72449_c;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, (float)startSpeed, 0.0f);
        ++this.lockonTicks;
        if (this.lockonTicks == 5 && !this.hasBeeped) {
            if (this.getIsCritical()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.stingerLockon, SoundCategory.HOSTILE, 10.0f, 0.75f, true);
            } else {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.stingerLockon, SoundCategory.HOSTILE, 10.0f, 1.0f, true);
            }
            this.hasBeeped = true;
        }
        return true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_145791_d = compound.func_74765_d("xTile");
        this.field_145792_e = compound.func_74765_d("yTile");
        this.field_145789_f = compound.func_74765_d("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.field_145790_g = Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.func_184212_Q().func_187227_b(CRITICAL, (Object)compound.func_74767_n("critical"));
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.canBePickedUp = compound.func_74771_c("pickup");
        } else if (compound.func_150297_b("player", 99)) {
            this.canBePickedUp = compound.func_74767_n("player") ? 1 : 0;
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("xTile", (short)this.field_145791_d);
        compound.func_74777_a("yTile", (short)this.field_145792_e);
        compound.func_74777_a("zTile", (short)this.field_145789_f);
        compound.func_74777_a("life", (short)this.ticksInGround);
        compound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.field_145790_g));
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.canBePickedUp);
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("critical", this.getIsCritical());
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && entityIn.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == 1 && !entityIn.field_71071_by.func_70441_a(new ItemStack(ModItems.gun_stinger_ammo, 1))) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setIsCritical(boolean crit) {
        this.func_184212_Q().func_187227_b(CRITICAL, (Object)crit);
    }

    public boolean getIsCritical() {
        return (Boolean)this.func_184212_Q().func_187225_a(CRITICAL);
    }
}

