/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.entity.mob.ai.EntityAINuclearCreeperSwell;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.interfaces.IRadiationImmune;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNuclearCreeper
extends EntityMob
implements IRadiationImmune {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityNuclearCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityNuclearCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityNuclearCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 75;
    private int explosionRadius = 20;

    public EntityNuclearCreeper(World p_i1733_1_) {
        super(p_i1733_1_);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINuclearCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityOcelot.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == ModDamageSource.radiation || source == ModDamageSource.mudPoisoning) {
            this.func_70691_i(amount);
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        super.func_70628_a(wasRecentlyHit, lootingModifier);
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a(ModItems.coin_creeper, 1);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IGNITED, (Object)Boolean.FALSE);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            this.field_70128_L = false;
            this.func_70691_i(10.0f);
        }
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 0.4f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0, this.timeSinceIgnited + 25);
        super.func_70071_h_();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 10 == 0) {
            this.func_70691_i(1.0f);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        for (EntityPlayer player : players) {
            AdvancementManager.grantAchievement(player, AdvancementManager.bossCreeper);
        }
        if (p_70645_1_.func_76346_g() instanceof EntitySkeleton || p_70645_1_.func_76352_a() && p_70645_1_.func_76364_f() instanceof EntityArrow && ((EntityArrow)p_70645_1_.func_76364_f()).field_70250_c == null) {
            int i = this.field_70146_Z.nextInt(11);
            int j = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_145779_a(ModItems.nugget_u235, j);
            }
            if (i == 1) {
                this.func_145779_a(ModItems.nugget_pu238, j);
            }
            if (i == 2) {
                this.func_145779_a(ModItems.nugget_pu239, j);
            }
            if (i == 3) {
                this.func_145779_a(ModItems.nugget_neptunium, j);
            }
            if (i == 4) {
                this.func_145779_a(ModItems.man_core, 1);
            }
            if (i == 5) {
                this.func_145779_a(ModItems.sulfur, j * 2);
                this.func_145779_a(ModItems.niter, j * 2);
            }
            if (i == 6) {
                this.func_145779_a(ModItems.syringe_awesome, 1);
            }
            if (i == 7) {
                this.func_145779_a(ModItems.fusion_core, 1);
            }
            if (i == 8) {
                this.func_145779_a(ModItems.syringe_metal_stimpak, 1);
            }
            if (i == 9) {
                switch (this.field_70146_Z.nextInt(4)) {
                    case 0: {
                        this.func_145779_a(ModItems.t45_helmet, 1);
                        break;
                    }
                    case 1: {
                        this.func_145779_a(ModItems.t45_plate, 1);
                        break;
                    }
                    case 2: {
                        this.func_145779_a(ModItems.t45_legs, 1);
                        break;
                    }
                    case 3: {
                        this.func_145779_a(ModItems.t45_boots, 1);
                    }
                }
                this.func_145779_a(ModItems.fusion_core, 1);
            }
            if (i == 10) {
                this.func_145779_a(ModItems.gun_fatman_ammo, 1);
            }
        }
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150335_W);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int i) {
        this.field_70180_af.func_187227_b(STATE, (Object)i);
    }

    public void func_70077_a(EntityLightningBolt p_70077_1_) {
        super.func_70077_a(p_70077_1_);
        this.field_70180_af.func_187227_b(POWERED, (Object)Boolean.TRUE);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (this.getPowered()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "muke");
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 250.0));
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, HBMSoundHandler.mukeExplosion, SoundCategory.HOSTILE, 15.0f, 1.0f);
                if (flag) {
                    this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(this.field_70170_p, 50, this.field_70165_t, this.field_70163_u, this.field_70161_v).mute());
                } else {
                    ExplosionNukeGeneric.dealDamage(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 100.0);
                }
            } else {
                ExplosionNukeSmall.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 3);
            }
            this.func_70106_y();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)Boolean.TRUE);
    }

    public void setPowered(boolean power) {
        this.field_70180_af.func_187227_b(POWERED, (Object)power);
    }
}

