/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.BlockTaint;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.missile.EntityMIRV;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.MissileStruct;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedEntitySoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMissileCustom
extends Entity
implements IChunkLoader,
IRadarDetectable,
IConstantRenderer {
    public static final DataParameter<Integer> HEALTH = EntityDataManager.func_187226_a(EntityMissileCustom.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<MissileStruct> TEMPLATE = EntityDataManager.func_187226_a(EntityMissileCustom.class, MissileStruct.SERIALIZER);
    int chunkX = 0;
    int chunkZ = 0;
    int startX;
    int startZ;
    int targetX;
    int targetZ;
    double velocity;
    double decelY;
    double accelXZ;
    float fuel;
    float consumption;
    private ForgeChunkManager.Ticket loaderTicket;
    public int health = 50;
    MissileStruct template;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityMissileCustom(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
    }

    public EntityMissileCustom(World world, float x, float y, float z, int a, int b, MissileStruct template) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        this.template = template;
        this.func_184212_Q().func_187227_b(TEMPLATE, (Object)template);
        Vec3d vector = new Vec3d((double)(this.targetX - this.startX), 0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        ItemMissile fuselage = template.fuselage;
        ItemMissile thruster = template.thruster;
        this.fuel = ((Float)fuselage.attributes[1]).floatValue();
        this.consumption = ((Float)thruster.attributes[1]).floatValue();
        this.func_70105_a(1.5f, 1.5f);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.func_70106_y();
                this.killMissile();
            }
        }
        return true;
    }

    private void killMissile() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.func_184212_Q().func_187214_a(HEALTH, (Object)this.health);
        this.func_184212_Q().func_187214_a(TEMPLATE, (Object)this.template);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70159_w = nbt.func_74769_h("moX");
        this.field_70181_x = nbt.func_74769_h("moY");
        this.field_70179_y = nbt.func_74769_h("moZ");
        this.field_70165_t = nbt.func_74769_h("poX");
        this.field_70163_u = nbt.func_74769_h("poY");
        this.field_70161_v = nbt.func_74769_h("poZ");
        this.decelY = nbt.func_74769_h("decel");
        this.accelXZ = nbt.func_74769_h("accel");
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startZ = nbt.func_74762_e("sZ");
        this.velocity = nbt.func_74769_h("veloc");
        this.fuel = nbt.func_74760_g("fuel");
        this.consumption = nbt.func_74760_g("consumption");
        int i = nbt.func_74762_e("fins");
        if (nbt.func_74764_b("noTemplate")) {
            this.template = null;
            this.func_70106_y();
        } else {
            this.template = new MissileStruct(Item.func_150899_d((int)nbt.func_74762_e("warhead")), Item.func_150899_d((int)nbt.func_74762_e("fuselage")), i < 0 ? null : Item.func_150899_d((int)i), Item.func_150899_d((int)nbt.func_74762_e("thruster")));
        }
        this.func_184212_Q().func_187227_b(TEMPLATE, (Object)this.template);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("moX", this.field_70159_w);
        nbt.func_74780_a("moY", this.field_70181_x);
        nbt.func_74780_a("moZ", this.field_70179_y);
        nbt.func_74780_a("poX", this.field_70165_t);
        nbt.func_74780_a("poY", this.field_70163_u);
        nbt.func_74780_a("poZ", this.field_70161_v);
        nbt.func_74780_a("decel", this.decelY);
        nbt.func_74780_a("accel", this.accelXZ);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74780_a("veloc", this.velocity);
        nbt.func_74776_a("fuel", this.fuel);
        nbt.func_74776_a("consumption", this.consumption);
        this.template = (MissileStruct)this.func_184212_Q().func_187225_a(TEMPLATE);
        if (this.template == null) {
            nbt.func_74757_a("noTemplate", true);
        } else {
            nbt.func_74768_a("warhead", Item.func_150891_b((Item)this.template.warhead));
            nbt.func_74768_a("fuselage", Item.func_150891_b((Item)this.template.fuselage));
            nbt.func_74768_a("fins", this.template.fins == null ? -1 : Item.func_150891_b((Item)this.template.fins));
            nbt.func_74768_a("thruster", Item.func_150891_b((Item)this.template.thruster));
        }
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void func_70071_h_() {
        ItemMissile.WarheadType wType;
        if (this.field_70173_aa < 10) {
            ExplosionLarge.spawnParticlesRadial(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15);
            return;
        }
        this.func_184212_Q().func_187227_b(HEALTH, (Object)this.health);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, 0.0f, 0.0f);
        this.rotation();
        if (this.fuel > 0.0f || this.field_70170_p.field_72995_K) {
            this.fuel -= this.consumption;
            this.field_70181_x -= this.decelY * this.velocity;
            Vec3 vector = Vec3.createVectorHelper(this.targetX - this.startX, 0.0, this.targetZ - this.startZ);
            vector = vector.normalize();
            vector.xCoord *= this.accelXZ * this.velocity;
            vector.zCoord *= this.accelXZ * this.velocity;
            if (this.field_70181_x > 0.0) {
                this.field_70159_w += vector.xCoord;
                this.field_70179_y += vector.zCoord;
            }
            if (this.field_70181_x < 0.0) {
                this.field_70159_w -= vector.xCoord;
                this.field_70179_y -= vector.zCoord;
            }
            if (this.velocity < 6.0) {
                this.velocity += 0.005 * (double)this.consumption;
            }
        } else {
            this.field_70159_w *= 0.99;
            this.field_70179_y *= 0.99;
            if (this.field_70181_x > -1.5) {
                this.field_70181_x -= 0.05;
            }
        }
        Block b = this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c();
        if (b != Blocks.field_150350_a && b != Blocks.field_150355_j && b != Blocks.field_150358_i || this.field_70163_u < 1.0) {
            if (this.field_70163_u < 1.0) {
                this.func_70012_b((int)this.field_70165_t, this.field_70170_p.func_189649_b((int)this.field_70165_t, (int)this.field_70161_v), (int)this.field_70161_v, 0.0f, 0.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 60) {
                this.onImpact();
            }
            this.func_70106_y();
            return;
        }
        PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedEntitySoundPacket(this.func_145782_y()));
        if ((int)(this.field_70165_t / 16.0) != this.chunkX || (int)(this.field_70161_v / 16.0) != this.chunkZ) {
            this.chunkX = (int)(this.field_70165_t / 16.0);
            this.chunkZ = (int)(this.field_70161_v / 16.0);
            this.loadNeighboringChunks(this.chunkX, this.chunkZ);
        }
        if (this.field_70170_p.field_72995_K) {
            this.template = (MissileStruct)this.func_184212_Q().func_187225_a(TEMPLATE);
            this.spawnRocketExhaust();
        }
        if ((wType = (ItemMissile.WarheadType)((Object)this.template.warhead.attributes[0])) == ItemMissile.WarheadType.MIRV) {
            this.mirvSplit();
        }
    }

    public void mirvSplit() {
        if (this.field_70181_x <= 0.0) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.func_70106_y();
            double modx = 0.0;
            double modz = 0.0;
            for (int i = 0; i < 7; ++i) {
                EntityMIRV nuke3 = new EntityMIRV(this.field_70170_p);
                nuke3.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (i == 0) {
                    modx = 0.0;
                    modz = 0.0;
                }
                if (i == 1) {
                    modx = 0.45;
                    modz = 0.0;
                }
                if (i == 2) {
                    modx = -0.45;
                    modz = 0.0;
                }
                if (i == 3) {
                    modx = 0.15;
                    modz = 0.3;
                }
                if (i == 4) {
                    modx = -0.15;
                    modz = -0.3;
                }
                if (i == 5) {
                    modx = 0.15;
                    modz = -0.3;
                }
                if (i == 6) {
                    modx = -0.15;
                    modz = 0.3;
                }
                nuke3.field_70159_w = this.field_70159_w + modx;
                nuke3.field_70181_x = this.field_70181_x;
                nuke3.field_70179_y = this.field_70179_y + modz;
                this.field_70170_p.func_72838_d((Entity)nuke3);
            }
        }
    }

    private void spawnRocketExhaust() {
        Vec3 v = Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        v = v.normalize();
        String smoke = "exDark";
        ItemMissile.FuelType type = (ItemMissile.FuelType)((Object)this.template.fuselage.attributes[0]);
        switch (type) {
            case BALEFIRE: {
                smoke = "exBalefire";
                break;
            }
            case HYDROGEN: {
                smoke = "exHydrogen";
                break;
            }
            case KEROSENE: {
                smoke = "exKerosene";
                break;
            }
            case SOLID: {
                smoke = "exSolid";
                break;
            }
        }
        for (int i = 0; i < 2; ++i) {
            MainRegistry.proxy.spawnParticle(this.field_70165_t - v.xCoord * (double)i, this.field_70163_u - v.yCoord * (double)i, this.field_70161_v - v.zCoord * (double)i, smoke, new float[]{(float)(this.field_70159_w * -3.0), (float)(this.field_70181_x * -3.0), (float)(this.field_70179_y * -3.0)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 5000.0;
    }

    public void onImpact() {
        ItemMissile.WarheadType type = (ItemMissile.WarheadType)((Object)this.template.warhead.attributes[0]);
        float strength = ((Float)this.template.warhead.attributes[1]).floatValue();
        int maxLifetime = (int)Math.max(100.0, 240.0 * (Math.pow(strength, 3.0) / Math.pow(48.0, 3.0)));
        switch (type) {
            case HE: {
                ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, (int)(strength * 50.0f), 0.25);
                break;
            }
            case INC: {
                ExplosionLarge.explodeFire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, strength, true, false, true);
                ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)strength * 1.5, (int)(strength * 50.0f), 0.25);
                break;
            }
            case CLUSTER: {
                break;
            }
            case BUSTER: {
                ExplosionLarge.buster(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y), strength, strength * 4.0f);
                break;
            }
            case NUCLEAR: 
            case TX: 
            case MIRV: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK4.statFac(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeCloudSmall nuke = new EntityNukeCloudSmall(this.field_70170_p, strength);
                nuke.field_70165_t = this.field_70165_t;
                nuke.field_70163_u = this.field_70163_u;
                nuke.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)nuke);
                break;
            }
            case VOLCANO: {
                ExplosionLarge.buster(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y), strength, strength * 2.0f);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            this.field_70170_p.func_175656_a(new BlockPos((int)Math.floor(this.field_70165_t + (double)x), (int)Math.floor(this.field_70163_u + (double)y), (int)Math.floor(this.field_70161_v + (double)z)), ModBlocks.volcanic_lava_block.func_176223_P());
                        }
                    }
                }
                this.field_70170_p.func_175656_a(new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)), ModBlocks.volcano_core.func_176223_P());
                break;
            }
            case BALEFIRE: {
                EntityBalefire bf = new EntityBalefire(this.field_70170_p);
                bf.field_70165_t = this.field_70165_t;
                bf.field_70163_u = this.field_70163_u;
                bf.field_70161_v = this.field_70161_v;
                bf.destructionRange = (int)strength;
                this.field_70170_p.func_72838_d((Entity)bf);
                this.field_70170_p.func_72838_d((Entity)EntityNukeCloudSmall.statFacBale(this.field_70170_p, this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, strength));
                break;
            }
            case N2: {
                this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK4.statFacNoRad(this.field_70170_p, (int)strength, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                EntityNukeCloudSmall n2 = new EntityNukeCloudSmall(this.field_70170_p, strength);
                n2.field_70165_t = this.field_70165_t;
                n2.field_70163_u = this.field_70163_u;
                n2.field_70161_v = this.field_70161_v;
                this.field_70170_p.func_72838_d((Entity)n2);
                break;
            }
            case TAINT: {
                int r = (int)strength;
                BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
                for (int i = 0; i < r * 10; ++i) {
                    int c;
                    int b;
                    int a = this.field_70146_Z.nextInt(r) + (int)this.field_70165_t - (r / 2 - 1);
                    if (!this.field_70170_p.func_180495_p((BlockPos)mPos.func_181079_c(a, b = this.field_70146_Z.nextInt(r) + (int)this.field_70163_u - (r / 2 - 1), c = this.field_70146_Z.nextInt(r) + (int)this.field_70161_v - (r / 2 - 1))).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, (BlockPos)mPos.func_181079_c(a, b, c)) || !BlockTaint.hasPosNeightbour(this.field_70170_p, (BlockPos)mPos.func_181079_c(a, b, c))) continue;
                    this.field_70170_p.func_180501_a((BlockPos)mPos.func_181079_c(a, b, c), ModBlocks.taint.func_176223_P().func_177226_a((IProperty)BlockTaint.TEXTURE, (Comparable)Integer.valueOf(this.field_70146_Z.nextInt(3) + 4)), 2);
                }
                break;
            }
            case CLOUD: {
                this.field_70170_p.func_175718_b(2002, new BlockPos((int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v)), 0);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y, 750, 2.5, 2);
                break;
            }
        }
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        ItemMissile part = ((MissileStruct)this.field_70180_af.func_187225_a(EntityMissileCustom.TEMPLATE)).fuselage;
        ItemMissile.PartSize top = part.top;
        ItemMissile.PartSize bottom = part.bottom;
        if (top == ItemMissile.PartSize.SIZE_10 && bottom == ItemMissile.PartSize.SIZE_10) {
            return IRadarDetectable.RadarTargetType.MISSILE_10;
        }
        if (top == ItemMissile.PartSize.SIZE_10 && bottom == ItemMissile.PartSize.SIZE_15) {
            return IRadarDetectable.RadarTargetType.MISSILE_10_15;
        }
        if (top == ItemMissile.PartSize.SIZE_15 && bottom == ItemMissile.PartSize.SIZE_15) {
            return IRadarDetectable.RadarTargetType.MISSILE_15;
        }
        if (top == ItemMissile.PartSize.SIZE_15 && bottom == ItemMissile.PartSize.SIZE_20) {
            return IRadarDetectable.RadarTargetType.MISSILE_15_20;
        }
        if (top == ItemMissile.PartSize.SIZE_20 && bottom == ItemMissile.PartSize.SIZE_20) {
            return IRadarDetectable.RadarTargetType.MISSILE_20;
        }
        return IRadarDetectable.RadarTargetType.PLAYER;
    }
}

