/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityDrying;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.entity.effect.EntityFalloutUnderGround;
import com.hbm.entity.effect.EntityRainDrop;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.mob.EntityGlowingOne;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.explosion.ExplosionNukeRay;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.Level;

public class EntityNukeExplosionMK4
extends Entity
implements IChunkLoader {
    public int radius;
    public int speed;
    public boolean mute = false;
    public boolean fallout = true;
    private boolean floodPlease = false;
    private int falloutAdd = 0;
    private ForgeChunkManager.Ticket loaderTicket;
    ExplosionNukeRay explosion;
    EntityFalloutUnderGround falloutBall;
    EntityDrying dryingBomb;
    EntityFalloutRain falloutRain;
    EntityRainDrop rainDrop;
    EntityDrying waterBomb;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityNukeExplosionMK4(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public EntityNukeExplosionMK4(World world, int radius, int speed) {
        super(world);
        this.radius = radius;
        this.speed = speed;
    }

    public void func_70071_h_() {
        if (this.radius == 0) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.fallout && this.falloutRain == null) {
            RadiationSavedData.getData(this.field_70170_p);
            float radMax = Math.min((float)(Math.pow(this.radius, 2.5) * 17.5), 1500000.0f);
            float rad = radMax / 10.0f;
            RadiationSavedData.incrementRad(this.field_70170_p, this.func_180425_c(), rad, radMax);
            ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.radius * 1.5, radMax * 0.1f);
            EntityGlowingOne.convertInRadiusToGlow(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.radius * 1.5);
        }
        if (!this.mute) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            }
        }
        ExplosionNukeGeneric.dealDamage(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.radius * 2);
        if (CompatibilityConfig.doEvaporateWater && this.dryingBomb == null) {
            this.dryingBomb = new EntityDrying(this.field_70170_p);
            this.dryingBomb.field_70165_t = this.field_70165_t;
            this.dryingBomb.field_70163_u = this.field_70163_u;
            this.dryingBomb.field_70161_v = this.field_70161_v;
            this.dryingBomb.setScale(this.radius + 16);
            this.field_70170_p.func_72838_d((Entity)this.dryingBomb);
        }
        if (!CompatibilityConfig.doEvaporateWater || CompatibilityConfig.doEvaporateWater && this.dryingBomb.done) {
            if (this.explosion == null) {
                this.explosion = new ExplosionNukeRay(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.radius);
            }
            if (!this.explosion.isAusf3Complete) {
                this.explosion.collectTipMk6(this.speed);
            } else if (this.explosion.getStoredSize() > 0) {
                this.explosion.processTip(BombConfig.mk4);
            } else if (this.fallout) {
                if (this.falloutBall == null) {
                    this.falloutBall = new EntityFalloutUnderGround(this.field_70170_p);
                    this.falloutBall.field_70165_t = this.field_70165_t;
                    this.falloutBall.field_70163_u = this.field_70163_u;
                    this.falloutBall.field_70161_v = this.field_70161_v;
                    this.falloutBall.setScale((int)((float)this.radius * ((float)BombConfig.falloutRange / 100.0f) + (float)this.falloutAdd));
                    this.field_70170_p.func_72838_d((Entity)this.falloutBall);
                }
                if (this.falloutBall.done) {
                    if (CompatibilityConfig.doFillCraterWithWater && this.floodPlease) {
                        if (this.waterBomb == null) {
                            this.waterBomb = new EntityDrying(this.field_70170_p);
                            this.waterBomb.field_70165_t = this.field_70165_t;
                            this.waterBomb.field_70163_u = this.field_70163_u;
                            this.waterBomb.field_70161_v = this.field_70161_v;
                            this.waterBomb.dryingmode = false;
                            this.waterBomb.setScale(this.radius + 18);
                            this.field_70170_p.func_72838_d((Entity)this.waterBomb);
                        } else if (this.waterBomb.done) {
                            if (!this.explosion.isContained) {
                                this.falloutRain = new EntityFalloutRain(this.field_70170_p);
                                this.falloutRain.field_70165_t = this.field_70165_t;
                                this.falloutRain.field_70163_u = this.field_70163_u;
                                this.falloutRain.field_70161_v = this.field_70161_v;
                                this.falloutRain.setScale((int)((float)this.radius * (1.0f + (float)BombConfig.falloutRange / 100.0f) + (float)this.falloutAdd), this.radius + 4);
                                this.field_70170_p.func_72838_d((Entity)this.falloutRain);
                            }
                            this.func_70106_y();
                        }
                    } else {
                        if (!this.explosion.isContained) {
                            this.falloutRain = new EntityFalloutRain(this.field_70170_p);
                            this.falloutRain.field_70165_t = this.field_70165_t;
                            this.falloutRain.field_70163_u = this.field_70163_u;
                            this.falloutRain.field_70161_v = this.field_70161_v;
                            this.falloutRain.setScale((int)((float)this.radius * (1.0f + (float)BombConfig.falloutRange / 100.0f) + (float)this.falloutAdd), this.radius + 4);
                            this.field_70170_p.func_72838_d((Entity)this.falloutRain);
                        }
                        this.func_70106_y();
                    }
                }
            } else if (CompatibilityConfig.doFillCraterWithWater && this.floodPlease) {
                if (this.waterBomb == null) {
                    this.waterBomb = new EntityDrying(this.field_70170_p);
                    this.waterBomb.field_70165_t = this.field_70165_t;
                    this.waterBomb.field_70163_u = this.field_70163_u;
                    this.waterBomb.field_70161_v = this.field_70161_v;
                    this.waterBomb.dryingmode = false;
                    this.waterBomb.setScale(this.radius + 18);
                    this.field_70170_p.func_72838_d((Entity)this.waterBomb);
                } else if (this.waterBomb.done) {
                    this.rainDrop = new EntityRainDrop(this.field_70170_p);
                    this.rainDrop.field_70165_t = this.field_70165_t;
                    this.rainDrop.field_70163_u = this.field_70163_u;
                    this.rainDrop.field_70161_v = this.field_70161_v;
                    this.rainDrop.setScale(this.radius + 16);
                    this.field_70170_p.func_72838_d((Entity)this.rainDrop);
                    this.func_70106_y();
                }
            } else {
                this.rainDrop = new EntityRainDrop(this.field_70170_p);
                this.rainDrop.field_70165_t = this.field_70165_t;
                this.rainDrop.field_70163_u = this.field_70163_u;
                this.rainDrop.field_70161_v = this.field_70161_v;
                this.rainDrop.setScale(this.radius + 16);
                this.field_70170_p.func_72838_d((Entity)this.rainDrop);
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    private static boolean isWet(World world, BlockPos pos) {
        Biome b = world.func_180494_b(pos);
        return b.func_150561_m() == Biome.TempCategory.OCEAN || b.func_76736_e() || b == Biomes.field_76787_r || b == Biomes.field_76771_b || b == Biomes.field_76781_i || b == Biomes.field_150575_M || b == Biomes.field_76776_l || b == Biomes.field_76777_m || b == Biomes.field_150576_N || b == Biomes.field_76780_h;
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public static EntityNukeExplosionMK4 statFac(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized explosion at " + x + " / " + y + " / " + z + " with radius " + r + "!");
        }
        if (r == 0) {
            r = 25;
        }
        EntityNukeExplosionMK4 mk4 = new EntityNukeExplosionMK4(world);
        mk4.radius = r;
        mk4.speed = 1000 * BombConfig.mk4 / r;
        mk4.func_70107_b(x, y, z);
        mk4.floodPlease = EntityNukeExplosionMK4.isWet(world, new BlockPos(x, y, z));
        if (BombConfig.disableNuclear) {
            mk4.fallout = false;
        }
        return mk4;
    }

    public static EntityNukeExplosionMK4 statFacExperimental(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized eX explosion at " + x + " / " + y + " / " + z + " with radius " + r + "!");
        }
        EntityNukeExplosionMK4 mk4 = new EntityNukeExplosionMK4(world);
        mk4.radius = r;
        mk4.speed = 1000 * BombConfig.mk4 / r;
        mk4.func_70107_b(x, y, z);
        mk4.floodPlease = EntityNukeExplosionMK4.isWet(world, new BlockPos(x, y, z));
        if (BombConfig.disableNuclear) {
            mk4.fallout = false;
        }
        return mk4;
    }

    public static EntityNukeExplosionMK4 statFacNoRad(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized nR explosion at " + x + " / " + y + " / " + z + " with radius " + r + "!");
        }
        EntityNukeExplosionMK4 mk4 = new EntityNukeExplosionMK4(world);
        mk4.radius = r;
        mk4.speed = 1000 * BombConfig.mk4 / r;
        mk4.func_70107_b(x, y, z);
        mk4.floodPlease = EntityNukeExplosionMK4.isWet(world, new BlockPos(x, y, z));
        mk4.fallout = false;
        return mk4;
    }

    public EntityNukeExplosionMK4 moreFallout(int fallout) {
        this.falloutAdd = fallout;
        return this;
    }

    public EntityNukeExplosionMK4 mute() {
        this.mute = true;
        return this;
    }
}

