/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.particle.EntityGasFlameFX;
import com.hbm.entity.projectile.EntityBombletZeta;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.entity.projectile.EntityRocketHoming;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedEntitySoundPacket;
import com.hbm.packet.PacketDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBomber
extends Entity
implements IChunkLoader,
IConstantRenderer {
    public static final DataParameter<Integer> HEALTH = EntityDataManager.func_187226_a(EntityBomber.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Byte> STYLE = EntityDataManager.func_187226_a(EntityBomber.class, (DataSerializer)DataSerializers.field_187191_a);
    int timer = 200;
    int bombStart = 75;
    int bombStop = 125;
    int bombRate = 3;
    int type = 0;
    public int health = 50;
    private ForgeChunkManager.Ticket loaderTicket;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityBomber(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.func_70105_a(8.0f, 4.0f);
    }

    public boolean func_70067_L() {
        return this.health > 0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == ModDamageSource.nuclearBlast) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K && this.health > 0) {
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.killBomber();
            }
        }
        return true;
    }

    private void killBomber() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, HBMSoundHandler.planeShotDown, SoundCategory.HOSTILE, 25.0f, 1.0f, false);
    }

    public boolean isBomberAlive() {
        return this.health > 0;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70169_q = this.field_70165_t;
        this.field_70137_T = this.field_70167_r = this.field_70163_u;
        this.field_70136_U = this.field_70166_s = this.field_70161_v;
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(HEALTH, (Object)this.health);
            if (this.health > 0) {
                PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedEntitySoundPacket(this.func_145782_y()));
            }
        } else {
            this.health = (Integer)this.func_184212_Q().func_187225_a(HEALTH);
        }
        this.rotation();
        if (this.health <= 0) {
            this.field_70181_x -= 0.025;
            for (int i = 0; i < 10; ++i) {
                this.field_70170_p.func_72838_d((Entity)new EntityGasFlameFX(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70159_w * 2.0, this.field_70163_u + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70181_x * 2.0, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70179_y * 2.0, 0.0, 0.1, 0.0));
            }
            if (this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)).func_185915_l() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                ExplosionLarge.explodeFire(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0f, true, false, true);
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, HBMSoundHandler.planeCrash, SoundCategory.HOSTILE, 10.0f, 1.0f, true);
                return;
            }
        }
        if (this.field_70173_aa > this.timer) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.health > 0 && this.field_70173_aa > this.bombStart && this.field_70173_aa < this.bombStop && this.field_70173_aa % this.bombRate == 0) {
            if (this.type == 3) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f, true);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, 10, 0.5, 3);
            } else if (this.type == 5) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, HBMSoundHandler.missileTakeoff, SoundCategory.HOSTILE, 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, true);
                EntityRocketHoming rocket = new EntityRocketHoming(this.field_70170_p);
                rocket.setIsCritical(true);
                rocket.field_70181_x = -1.0;
                rocket.shootingEntity = this;
                rocket.homingRadius = 50;
                rocket.homingMod = 5;
                rocket.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                rocket.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                rocket.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                this.field_70170_p.func_72838_d((Entity)rocket);
            } else if (this.type == 6) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, HBMSoundHandler.missileTakeoff, SoundCategory.HOSTILE, 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, true);
                EntityBoxcar rocket = new EntityBoxcar(this.field_70170_p);
                rocket.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                rocket.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                rocket.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                this.field_70170_p.func_72838_d((Entity)rocket);
            } else if (this.type == 7) {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f, true);
                ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t, this.field_70170_p.func_189649_b((int)this.field_70165_t, (int)this.field_70161_v) + 2, this.field_70161_v, 10, 1.0, 2);
            } else {
                this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, HBMSoundHandler.bombWhistle, SoundCategory.HOSTILE, 10.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, true);
                EntityBombletZeta zeta = new EntityBombletZeta(this.field_70170_p);
                zeta.rotation();
                zeta.type = this.type;
                zeta.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5;
                zeta.field_70163_u = this.field_70163_u - this.field_70146_Z.nextDouble();
                zeta.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5;
                if (this.type == 0) {
                    zeta.field_70159_w = this.field_70159_w + this.field_70146_Z.nextGaussian() * 0.15;
                    zeta.field_70179_y = this.field_70179_y + this.field_70146_Z.nextGaussian() * 0.15;
                } else {
                    zeta.field_70159_w = this.field_70159_w;
                    zeta.field_70179_y = this.field_70179_y;
                }
                this.field_70170_p.func_72838_d((Entity)zeta);
            }
        }
    }

    public void fac(World world, double x, double y, double z) {
        Vec3d vector = new Vec3d(world.field_73012_v.nextDouble() - 0.5, 0.0, world.field_73012_v.nextDouble() - 0.5);
        vector = vector.func_72432_b();
        vector = new Vec3d(vector.field_72450_a * (double)(GeneralConfig.enableBomberShortMode ? 1 : 2), vector.field_72448_b, vector.field_72449_c * (double)(GeneralConfig.enableBomberShortMode ? 1 : 2));
        this.func_70012_b(x - vector.field_72450_a * 100.0, y + 50.0, z - vector.field_72449_c * 100.0, 0.0f, 0.0f);
        this.field_70159_w = vector.field_72450_a;
        this.field_70179_y = vector.field_72449_c;
        this.field_70181_x = 0.0;
        this.rotation();
        int i = 1;
        int rand = world.field_73012_v.nextInt(7);
        switch (rand) {
            case 0: 
            case 1: {
                i = 1;
                break;
            }
            case 2: 
            case 3: {
                i = 2;
                break;
            }
            case 4: {
                i = 5;
                break;
            }
            case 5: {
                i = 6;
                break;
            }
            case 6: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            rand = world.field_73012_v.nextInt(4);
            switch (rand) {
                case 0: {
                    i = 0;
                    break;
                }
                case 1: {
                    i = 3;
                    break;
                }
                case 2: {
                    i = 4;
                    break;
                }
                case 3: {
                    i = 8;
                }
            }
        }
        this.func_184212_Q().func_187227_b(STYLE, (Object)((byte)i));
        this.func_70105_a(8.0f, 4.0f);
    }

    public static EntityBomber statFacCarpet(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 2;
        bomber.fac(world, x, y, z);
        bomber.type = 0;
        return bomber;
    }

    public static EntityBomber statFacNapalm(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 5;
        bomber.fac(world, x, y, z);
        bomber.type = 1;
        return bomber;
    }

    public static EntityBomber statFacChlorine(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 100;
        bomber.bombRate = 4;
        bomber.fac(world, x, y, z);
        bomber.type = 2;
        return bomber;
    }

    public static EntityBomber statFacOrange(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.type = 3;
        return bomber;
    }

    public static EntityBomber statFacABomb(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 60;
        bomber.bombStop = 70;
        bomber.bombRate = 65;
        bomber.fac(world, x, y, z);
        int i = 1;
        int rand = world.field_73012_v.nextInt(3);
        switch (rand) {
            case 0: {
                i = 5;
                break;
            }
            case 1: {
                i = 6;
                break;
            }
            case 2: {
                i = 7;
            }
        }
        if (world.field_73012_v.nextInt(100) == 0) {
            i = 8;
        }
        bomber.func_184212_Q().func_187227_b(STYLE, (Object)((byte)i));
        bomber.type = 4;
        return bomber;
    }

    public static EntityBomber statFacStinger(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_184212_Q().func_187227_b(STYLE, (Object)4);
        bomber.type = 5;
        return bomber;
    }

    public static EntityBomber statFacBoxcar(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 50;
        bomber.bombStop = 150;
        bomber.bombRate = 10;
        bomber.fac(world, x, y, z);
        bomber.func_184212_Q().func_187227_b(STYLE, (Object)6);
        bomber.type = 6;
        return bomber;
    }

    public static EntityBomber statFacPC(World world, double x, double y, double z) {
        EntityBomber bomber = new EntityBomber(world);
        bomber.timer = 200;
        bomber.bombStart = 75;
        bomber.bombStop = 125;
        bomber.bombRate = 1;
        bomber.fac(world, x, y, z);
        bomber.func_184212_Q().func_187227_b(STYLE, (Object)6);
        bomber.type = 7;
        return bomber;
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.func_184212_Q().func_187214_a(STYLE, (Object)0);
        this.func_184212_Q().func_187214_a(HEALTH, (Object)50);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70173_aa = nbt.func_74762_e("ticksExisted");
        this.bombStart = nbt.func_74762_e("bombStart");
        this.bombStop = nbt.func_74762_e("bombStop");
        this.bombRate = nbt.func_74762_e("bombRate");
        this.type = nbt.func_74762_e("type");
        this.func_184212_Q().func_187227_b(STYLE, (Object)nbt.func_74771_c("style"));
        this.func_184212_Q().func_187227_b(HEALTH, (Object)nbt.func_74762_e("health"));
        this.func_70105_a(8.0f, 4.0f);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksExisted", this.field_70173_aa);
        nbt.func_74768_a("bombStart", this.bombStart);
        nbt.func_74768_a("bombStop", this.bombStop);
        nbt.func_74768_a("bombRate", this.bombRate);
        nbt.func_74768_a("type", this.type);
        nbt.func_74774_a("style", ((Byte)this.func_184212_Q().func_187225_a(STYLE)).byteValue());
        nbt.func_74768_a("health", ((Integer)this.func_184212_Q().func_187225_a(HEALTH)).intValue());
    }

    protected void rotation() {
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 500000.0;
    }
}

